/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user.custom;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomColumn;

public class UserCustomTable
extends UserTable<UserCustomColumn> {
    public UserCustomTable(String tableName, List<UserCustomColumn> columns) {
        this(tableName, columns, null);
    }

    public UserCustomTable(String tableName, List<UserCustomColumn> columns, Collection<String> requiredColumns) {
        super(tableName, columns);
        if (requiredColumns != null && !requiredColumns.isEmpty()) {
            HashSet<String> search = new HashSet<String>(requiredColumns);
            HashMap<String, Integer> found = new HashMap<String, Integer>();
            for (UserCustomColumn column : columns) {
                String columnName = column.getName();
                int columnIndex = column.getIndex();
                if (!search.contains(columnName)) continue;
                Integer previousIndex = (Integer)found.get(columnName);
                this.duplicateCheck(columnIndex, previousIndex, columnName);
                found.put(columnName, columnIndex);
            }
            for (String requiredColumn : search) {
                this.missingCheck((Integer)found.get(requiredColumn), requiredColumn);
            }
        }
    }

    public UserCustomTable(UserCustomTable userCustomTable) {
        super(userCustomTable);
    }

    public UserCustomTable copy() {
        return new UserCustomTable(this);
    }

    @Override
    public String getDataType() {
        return null;
    }
}

