/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.ConstraintType;
import mil.nga.geopackage.user.UserColumn;

public abstract class UserTable<TColumn extends UserColumn> {
    private String tableName;
    private String[] columnNames;
    private final List<TColumn> columns;
    private final Map<String, Integer> nameToIndex;
    private int pkIndex;
    private final List<Constraint> constraints;
    private final Map<ConstraintType, List<Constraint>> typedContraints;
    private Contents contents;

    protected UserTable(String tableName, List<TColumn> columns) {
        this.nameToIndex = new HashMap<String, Integer>();
        this.constraints = new ArrayList<Constraint>();
        this.typedContraints = new HashMap<ConstraintType, List<Constraint>>();
        this.tableName = tableName;
        this.columns = columns;
        this.updateColumns();
    }

    protected UserTable(UserTable<TColumn> userTable) {
        this.tableName = userTable.tableName;
        this.columnNames = new String[userTable.columnNames.length];
        System.arraycopy(userTable.columnNames, 0, this.columnNames, 0, this.columnNames.length);
        this.columns = new ArrayList<TColumn>();
        for (UserColumn column : userTable.columns) {
            UserColumn copiedColumn = column.copy();
            this.columns.add(copiedColumn);
        }
        this.nameToIndex = new HashMap<String, Integer>();
        this.nameToIndex.putAll(userTable.nameToIndex);
        this.pkIndex = userTable.pkIndex;
        this.constraints = new ArrayList<Constraint>();
        this.typedContraints = new HashMap<ConstraintType, List<Constraint>>();
        for (Constraint constraint : userTable.constraints) {
            this.addConstraint(constraint.copy());
        }
        this.contents = userTable.contents;
    }

    public abstract UserTable<TColumn> copy();

    protected void updateColumns() {
        this.nameToIndex.clear();
        HashSet<Integer> indices = new HashSet<Integer>();
        ArrayList<Object> needsIndex = new ArrayList<Object>();
        for (Object column : this.columns) {
            if (((UserColumn)column).hasIndex()) {
                int n = ((UserColumn)column).getIndex();
                if (indices.contains(n)) {
                    throw new GeoPackageException("Duplicate index: " + n + ", Table Name: " + this.tableName);
                }
                indices.add(n);
                continue;
            }
            needsIndex.add(column);
        }
        int currentIndex = -1;
        for (UserColumn userColumn : needsIndex) {
            while (indices.contains(++currentIndex)) {
            }
            userColumn.setIndex(currentIndex);
        }
        Collections.sort(this.columns);
        this.pkIndex = -1;
        this.columnNames = new String[this.columns.size()];
        for (int index = 0; index < this.columns.size(); ++index) {
            String columnName;
            UserColumn userColumn = (UserColumn)this.columns.get(index);
            if (userColumn.getIndex() != index) {
                throw new GeoPackageException("No column found at index: " + index + ", Table Name: " + this.tableName);
            }
            if (userColumn.isPrimaryKey()) {
                if (this.pkIndex != -1) {
                    throw new GeoPackageException("More than one primary key column was found for table '" + this.tableName + "'. Index " + this.pkIndex + " and " + index);
                }
                this.pkIndex = index;
            }
            this.columnNames[index] = columnName = userColumn.getName();
            this.nameToIndex.put(columnName, index);
        }
    }

    public abstract String getDataType();

    protected void duplicateCheck(int index, Integer previousIndex, String column) {
        if (previousIndex != null) {
            throw new GeoPackageException("More than one " + column + " column was found for table '" + this.tableName + "'. Index " + previousIndex + " and " + index);
        }
    }

    protected void typeCheck(GeoPackageDataType expected, TColumn column) {
        GeoPackageDataType actual = ((UserColumn)column).getDataType();
        if (actual == null || !actual.equals((Object)expected)) {
            throw new GeoPackageException("Unexpected " + ((UserColumn)column).getName() + " column data type was found for table '" + this.tableName + "', expected: " + expected.name() + ", actual: " + (actual != null ? actual.name() : "null"));
        }
    }

    protected void missingCheck(Integer index, String column) {
        if (index == null) {
            throw new GeoPackageException("No " + column + " column was found for table '" + this.tableName + "'");
        }
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.nameToIndex.get(columnName);
        if (index == null) {
            throw new GeoPackageException("Column does not exist in table '" + this.tableName + "', column: " + columnName);
        }
        return index;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public TColumn getColumn(int index) {
        return (TColumn)((UserColumn)this.columns.get(index));
    }

    public TColumn getColumn(String columnName) {
        return this.getColumn(this.getColumnIndex(columnName));
    }

    public boolean hasColumn(String columnName) {
        return this.nameToIndex.containsKey(columnName);
    }

    public int columnCount() {
        return this.columns.size();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean hasPkColumn() {
        return this.pkIndex >= 0;
    }

    public int getPkColumnIndex() {
        return this.pkIndex;
    }

    public TColumn getPkColumn() {
        UserColumn column = null;
        if (this.hasPkColumn()) {
            column = (UserColumn)this.columns.get(this.pkIndex);
        }
        return (TColumn)column;
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        List<Constraint> typeConstraints = this.typedContraints.get((Object)constraint.getType());
        if (typeConstraints == null) {
            typeConstraints = new ArrayList<Constraint>();
            this.typedContraints.put(constraint.getType(), typeConstraints);
        }
        typeConstraints.add(constraint);
    }

    public void addConstraints(Collection<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            this.addConstraint(constraint);
        }
    }

    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Constraint> getConstraints(ConstraintType type) {
        List<Constraint> constraints = this.typedContraints.get((Object)type);
        if (constraints == null) {
            constraints = new ArrayList<Constraint>();
        }
        return constraints;
    }

    public List<Constraint> clearConstraints() {
        ArrayList<Constraint> constraintsCopy = new ArrayList<Constraint>(this.constraints);
        this.constraints.clear();
        this.typedContraints.clear();
        return constraintsCopy;
    }

    public List<TColumn> columnsOfType(GeoPackageDataType type) {
        ArrayList<UserColumn> columnsOfType = new ArrayList<UserColumn>();
        for (UserColumn column : this.columns) {
            if (column.getDataType() != type) continue;
            columnsOfType.add(column);
        }
        return columnsOfType;
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        if (contents != null) {
            this.validateContents(contents);
        }
    }

    protected void validateContents(Contents contents) {
    }

    public void addColumn(TColumn column) {
        this.columns.add(column);
        this.updateColumns();
    }

    public void renameColumn(TColumn column, String newColumnName) {
        this.renameColumn(((UserColumn)column).getName(), newColumnName);
        ((UserColumn)column).setName(newColumnName);
    }

    public void renameColumn(String columnName, String newColumnName) {
        this.renameColumn(this.getColumnIndex(columnName), newColumnName);
    }

    public void renameColumn(int index, String newColumnName) {
        ((UserColumn)this.columns.get(index)).setName(newColumnName);
        this.updateColumns();
    }

    public void dropColumn(TColumn column) {
        this.dropColumn(((UserColumn)column).getIndex());
    }

    public void dropColumn(String columnName) {
        this.dropColumn(this.getColumnIndex(columnName));
    }

    public void dropColumn(int index) {
        this.columns.remove(index);
        for (int i = index; i < this.columns.size(); ++i) {
            ((UserColumn)this.columns.get(i)).resetIndex();
        }
        this.updateColumns();
    }

    public void alterColumn(TColumn column) {
        TColumn existingColumn = this.getColumn(((UserColumn)column).getName());
        ((UserColumn)column).setIndex(((UserColumn)existingColumn).getIndex());
        this.columns.set(((UserColumn)column).getIndex(), column);
    }
}

