/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.matrix;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrix.TileMatrixKey;

@DatabaseTable(tableName="gpkg_tile_matrix", daoClass=TileMatrixDao.class)
public class TileMatrix {
    public static final String TABLE_NAME = "gpkg_tile_matrix";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_ZOOM_LEVEL = "zoom_level";
    public static final String COLUMN_ID_1 = "table_name";
    public static final String COLUMN_ID_2 = "zoom_level";
    public static final String COLUMN_MATRIX_WIDTH = "matrix_width";
    public static final String COLUMN_MATRIX_HEIGHT = "matrix_height";
    public static final String COLUMN_TILE_WIDTH = "tile_width";
    public static final String COLUMN_TILE_HEIGHT = "tile_height";
    public static final String COLUMN_PIXEL_X_SIZE = "pixel_x_size";
    public static final String COLUMN_PIXEL_Y_SIZE = "pixel_y_size";
    @DatabaseField(columnName="table_name", canBeNull=false, unique=true, foreign=true, foreignAutoRefresh=true)
    private Contents contents;
    @DatabaseField(columnName="table_name", id=true, canBeNull=false, uniqueCombo=true, readOnly=true)
    private String tableName;
    @DatabaseField(columnName="zoom_level", canBeNull=false, uniqueCombo=true)
    private long zoomLevel;
    @DatabaseField(columnName="matrix_width", canBeNull=false)
    private long matrixWidth;
    @DatabaseField(columnName="matrix_height", canBeNull=false)
    private long matrixHeight;
    @DatabaseField(columnName="tile_width", canBeNull=false)
    private long tileWidth;
    @DatabaseField(columnName="tile_height", canBeNull=false)
    private long tileHeight;
    @DatabaseField(columnName="pixel_x_size", canBeNull=false)
    private double pixelXSize;
    @DatabaseField(columnName="pixel_y_size", canBeNull=false)
    private double pixelYSize;

    public TileMatrix() {
    }

    public TileMatrix(TileMatrix tileMatrix) {
        this.contents = tileMatrix.contents;
        this.tableName = tileMatrix.tableName;
        this.zoomLevel = tileMatrix.zoomLevel;
        this.matrixWidth = tileMatrix.matrixWidth;
        this.matrixHeight = tileMatrix.matrixHeight;
        this.tileWidth = tileMatrix.tileWidth;
        this.tileHeight = tileMatrix.tileHeight;
        this.pixelXSize = tileMatrix.pixelXSize;
        this.pixelYSize = tileMatrix.pixelYSize;
    }

    public TileMatrixKey getId() {
        return new TileMatrixKey(this.tableName, this.zoomLevel);
    }

    public void setId(TileMatrixKey id) {
        this.tableName = id.getTableName();
        this.zoomLevel = id.getZoomLevel();
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        if (contents != null) {
            ContentsDataType dataType = contents.getDataType();
            if (dataType == null || dataType != ContentsDataType.TILES && dataType != ContentsDataType.GRIDDED_COVERAGE) {
                throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + TileMatrix.class.getSimpleName() + " must have a data type of " + ContentsDataType.TILES.getName() + " or " + ContentsDataType.GRIDDED_COVERAGE.getName());
            }
            this.tableName = contents.getId();
        } else {
            this.tableName = null;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(long zoomLevel) {
        this.validateValues("zoom_level", zoomLevel, true);
        this.zoomLevel = zoomLevel;
    }

    public long getMatrixWidth() {
        return this.matrixWidth;
    }

    public void setMatrixWidth(long matrixWidth) {
        this.validateValues(COLUMN_MATRIX_WIDTH, matrixWidth, false);
        this.matrixWidth = matrixWidth;
    }

    public long getMatrixHeight() {
        return this.matrixHeight;
    }

    public void setMatrixHeight(long matrixHeight) {
        this.validateValues(COLUMN_MATRIX_HEIGHT, matrixHeight, false);
        this.matrixHeight = matrixHeight;
    }

    public long getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(long tileWidth) {
        this.validateValues(COLUMN_TILE_WIDTH, tileWidth, false);
        this.tileWidth = tileWidth;
    }

    public long getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(long tileHeight) {
        this.validateValues(COLUMN_TILE_HEIGHT, tileHeight, false);
        this.tileHeight = tileHeight;
    }

    public double getPixelXSize() {
        return this.pixelXSize;
    }

    public void setPixelXSize(double pixelXSize) {
        this.validateValues(COLUMN_PIXEL_X_SIZE, pixelXSize);
        this.pixelXSize = pixelXSize;
    }

    public double getPixelYSize() {
        return this.pixelYSize;
    }

    public void setPixelYSize(double pixelYSize) {
        this.validateValues(COLUMN_PIXEL_Y_SIZE, pixelYSize);
        this.pixelYSize = pixelYSize;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private void validateValues(String column, long value, boolean allowZero) {
        if (value < 0L || value == 0L && !allowZero) {
            throw new GeoPackageException(column + " value must be greater than " + (allowZero ? "or equal to " : "") + "0: " + value);
        }
    }

    private void validateValues(String column, double value) {
        if (value <= 0.0) {
            throw new GeoPackageException(column + " value must be greater than 0: " + value);
        }
    }
}

