/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.style;

import mil.nga.geopackage.style.ColorUtils;

public class Color {
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 0.0f;
    private float opacity = 1.0f;

    public Color() {
    }

    public Color(String color) {
        this.setColor(color);
    }

    public Color(String color, float opacity) {
        this.setColor(color, opacity);
    }

    public Color(String color, int alpha) {
        this.setColor(color, alpha);
    }

    public Color(String red, String green, String blue) {
        this.setColor(red, green, blue);
    }

    public Color(String red, String green, String blue, String alpha) {
        this.setColor(red, green, blue, alpha);
    }

    public Color(String red, String green, String blue, float opacity) {
        this.setColor(red, green, blue, opacity);
    }

    public Color(int red, int green, int blue) {
        this.setColor(red, green, blue);
    }

    public Color(int red, int green, int blue, int alpha) {
        this.setColor(red, green, blue, alpha);
    }

    public Color(int red, int green, int blue, float opacity) {
        this.setColor(red, green, blue, opacity);
    }

    public Color(float red, float green, float blue) {
        this.setColor(red, green, blue);
    }

    public Color(float red, float green, float blue, float opacity) {
        this.setColor(red, green, blue, opacity);
    }

    public Color(float[] hsl) {
        if (hsl.length > 3) {
            this.setColorByHSL(hsl[0], hsl[1], hsl[2], hsl[3]);
        } else {
            this.setColorByHSL(hsl[0], hsl[1], hsl[2]);
        }
    }

    public Color(float[] hsl, float alpha) {
        this.setColorByHSL(hsl[0], hsl[1], hsl[2], alpha);
    }

    public Color(int color) {
        this.setColor(color);
    }

    public void setColor(String color) {
        this.setRed(ColorUtils.getRed(color));
        this.setGreen(ColorUtils.getGreen(color));
        this.setBlue(ColorUtils.getBlue(color));
        String alpha = ColorUtils.getAlpha(color);
        if (alpha != null) {
            this.setAlpha(alpha);
        }
    }

    public void setColor(String color, float opacity) {
        this.setColor(color);
        this.setOpacity(opacity);
    }

    public void setColor(String color, int alpha) {
        this.setColor(color);
        this.setAlpha(alpha);
    }

    public void setColor(String red, String green, String blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public void setColor(String red, String green, String blue, String alpha) {
        this.setColor(red, green, blue);
        this.setAlpha(alpha);
    }

    public void setColor(String red, String green, String blue, float opacity) {
        this.setColor(red, green, blue);
        this.setOpacity(opacity);
    }

    public void setColor(int red, int green, int blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.setColor(red, green, blue);
        this.setAlpha(alpha);
    }

    public void setColor(int red, int green, int blue, float opacity) {
        this.setColor(red, green, blue);
        this.setOpacity(opacity);
    }

    public void setColor(float red, float green, float blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public void setColor(float red, float green, float blue, float opacity) {
        this.setColor(red, green, blue);
        this.setOpacity(opacity);
    }

    public void setColorByHSL(float hue, float saturation, float lightness) {
        float[] arithmeticRGB = ColorUtils.toArithmeticRGB(hue, saturation, lightness);
        this.setRed(arithmeticRGB[0]);
        this.setGreen(arithmeticRGB[1]);
        this.setBlue(arithmeticRGB[2]);
    }

    public void setColorByHSL(float hue, float saturation, float lightness, float alpha) {
        this.setColorByHSL(hue, saturation, lightness);
        this.setAlpha(alpha);
    }

    public void setColor(int color) {
        this.setRed(ColorUtils.getRed(color));
        this.setGreen(ColorUtils.getGreen(color));
        this.setBlue(ColorUtils.getBlue(color));
        if (color > 0xFFFFFF || color < 0) {
            this.setAlpha(ColorUtils.getAlpha(color));
        }
    }

    public void setRed(String red) {
        this.setRed(ColorUtils.toArithmeticRGB(red));
    }

    public void setGreen(String green) {
        this.setGreen(ColorUtils.toArithmeticRGB(green));
    }

    public void setBlue(String blue) {
        this.setBlue(ColorUtils.toArithmeticRGB(blue));
    }

    public void setAlpha(String alpha) {
        this.setOpacity(ColorUtils.toArithmeticRGB(alpha));
    }

    public void setRed(int red) {
        this.setRed(ColorUtils.toHex(red));
    }

    public void setGreen(int green) {
        this.setGreen(ColorUtils.toHex(green));
    }

    public void setBlue(int blue) {
        this.setBlue(ColorUtils.toHex(blue));
    }

    public void setAlpha(int alpha) {
        this.setOpacity(ColorUtils.toArithmeticRGB(alpha));
    }

    public void setRed(float red) {
        ColorUtils.validateArithmeticRGB(red);
        this.red = red;
    }

    public void setGreen(float green) {
        ColorUtils.validateArithmeticRGB(green);
        this.green = green;
    }

    public void setBlue(float blue) {
        ColorUtils.validateArithmeticRGB(blue);
        this.blue = blue;
    }

    public void setOpacity(float opacity) {
        ColorUtils.validateArithmeticRGB(opacity);
        this.opacity = opacity;
    }

    public void setAlpha(float alpha) {
        this.setOpacity(alpha);
    }

    public boolean isOpaque() {
        return this.opacity == 1.0f;
    }

    public String getColorHex() {
        return ColorUtils.toColor(this.getRedHex(), this.getGreenHex(), this.getBlueHex());
    }

    public String getColorHexWithAlpha() {
        return ColorUtils.toColorWithAlpha(this.getRedHex(), this.getGreenHex(), this.getBlueHex(), this.getAlphaHex());
    }

    public String getColorHexShorthand() {
        return ColorUtils.toColorShorthand(this.getRedHex(), this.getGreenHex(), this.getBlueHex());
    }

    public String getColorHexShorthandWithAlpha() {
        return ColorUtils.toColorShorthandWithAlpha(this.getRedHex(), this.getGreenHex(), this.getBlueHex(), this.getAlphaHex());
    }

    public int getColor() {
        return ColorUtils.toColor(this.getRed(), this.getGreen(), this.getBlue());
    }

    public int getColorWithAlpha() {
        return ColorUtils.toColorWithAlpha(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public String getRedHex() {
        return ColorUtils.toHex(this.red);
    }

    public String getGreenHex() {
        return ColorUtils.toHex(this.green);
    }

    public String getBlueHex() {
        return ColorUtils.toHex(this.blue);
    }

    public String getAlphaHex() {
        return ColorUtils.toHex(this.opacity);
    }

    public String getRedHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getRedHex());
    }

    public String getGreenHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getGreenHex());
    }

    public String getBlueHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getBlueHex());
    }

    public String getAlphaHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getAlphaHex());
    }

    public int getRed() {
        return ColorUtils.toRGB(this.red);
    }

    public int getGreen() {
        return ColorUtils.toRGB(this.green);
    }

    public int getBlue() {
        return ColorUtils.toRGB(this.blue);
    }

    public int getAlpha() {
        return ColorUtils.toRGB(this.opacity);
    }

    public float getRedArithmetic() {
        return this.red;
    }

    public float getGreenArithmetic() {
        return this.green;
    }

    public float getBlueArithmetic() {
        return this.blue;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public float getAlphaArithmetic() {
        return this.getOpacity();
    }

    public float[] getHSL() {
        return ColorUtils.toHSL(this.red, this.green, this.blue);
    }

    public float getHue() {
        return this.getHSL()[0];
    }

    public float getSaturation() {
        return this.getHSL()[1];
    }

    public float getLightness() {
        return this.getHSL()[2];
    }
}

