/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.sf.GeometryType;

public class FeatureTable
extends UserTable<FeatureColumn> {
    private final int geometryIndex;

    public FeatureTable(GeometryColumns geometryColumns, List<FeatureColumn> columns) {
        this(geometryColumns.getTableName(), geometryColumns.getColumnName(), columns);
    }

    public FeatureTable(String tableName, List<FeatureColumn> columns) {
        this(tableName, null, columns);
    }

    public FeatureTable(String tableName, String geometryColumn, List<FeatureColumn> columns) {
        super(tableName, columns);
        Integer geometry = null;
        for (FeatureColumn column : columns) {
            boolean isGeometryColumn = false;
            if (geometryColumn != null) {
                isGeometryColumn = geometryColumn.equalsIgnoreCase(column.getName());
            } else if (column.isGeometry()) {
                isGeometryColumn = column.isGeometry();
            }
            if (!isGeometryColumn) continue;
            geometry = column.getIndex();
            break;
        }
        this.missingCheck(geometry, GeometryType.GEOMETRY.name());
        this.geometryIndex = geometry;
    }

    public FeatureTable(FeatureTable featureTable) {
        super(featureTable);
        this.geometryIndex = featureTable.geometryIndex;
    }

    public FeatureTable copy() {
        return new FeatureTable(this);
    }

    @Override
    public String getDataType() {
        return ContentsDataType.FEATURES.getName();
    }

    public int getGeometryColumnIndex() {
        return this.geometryIndex;
    }

    public FeatureColumn getGeometryColumn() {
        return (FeatureColumn)this.getColumn(this.geometryIndex);
    }

    @Override
    protected void validateContents(Contents contents) {
        ContentsDataType dataType = contents.getDataType();
        if (dataType == null || dataType != ContentsDataType.FEATURES) {
            throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + FeatureTable.class.getSimpleName() + " must have a data type of " + ContentsDataType.FEATURES.getName());
        }
    }
}

