/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.coverage.GriddedCoverage;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;

public class GriddedCoverageDao
extends BaseDaoImpl<GriddedCoverage, Long> {
    public GriddedCoverageDao(ConnectionSource connectionSource, Class<GriddedCoverage> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public GriddedCoverage query(TileMatrixSet tileMatrixSet) {
        return this.query(tileMatrixSet.getTableName());
    }

    public GriddedCoverage query(String tileMatrixSetName) {
        GriddedCoverage griddedCoverage = null;
        try {
            QueryBuilder qb = this.queryBuilder();
            qb.where().eq("tile_matrix_set_name", (Object)tileMatrixSetName);
            PreparedQuery query = qb.prepare();
            griddedCoverage = (GriddedCoverage)this.queryForFirst(query);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Gridded Coverage by Tile Matrix Set Name: " + tileMatrixSetName, e);
        }
        return griddedCoverage;
    }

    public int delete(TileMatrixSet tileMatrixSet) {
        return this.delete(tileMatrixSet.getTableName());
    }

    public int delete(String tableName) {
        DeleteBuilder db = this.deleteBuilder();
        int deleted = 0;
        try {
            db.where().eq("tile_matrix_set_name", (Object)tableName);
            PreparedDelete deleteQuery = db.prepare();
            deleted = this.delete(deleteQuery);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Gridded Coverage by Table Name: " + tableName, e);
        }
        return deleted;
    }
}

