/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.db.MappedColumn;
import mil.nga.geopackage.db.TableMapping;
import mil.nga.geopackage.db.table.ConstraintParser;
import mil.nga.geopackage.db.table.TableConstraints;
import mil.nga.geopackage.db.table.TableInfo;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.MetadataExtension;
import mil.nga.geopackage.extension.NGAExtensions;
import mil.nga.geopackage.extension.RTreeIndexCoreExtension;
import mil.nga.geopackage.extension.SchemaExtension;
import mil.nga.geopackage.extension.coverage.CoverageDataCore;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDao;
import mil.nga.geopackage.extension.coverage.GriddedTileDao;
import mil.nga.geopackage.extension.related.ExtendedRelation;
import mil.nga.geopackage.extension.related.ExtendedRelationsDao;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.schema.columns.DataColumnsDao;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.geopackage.user.custom.UserCustomTableReader;

public class GeoPackageExtensions {
    private static final Logger logger = Logger.getLogger(GeoPackageExtensions.class.getName());

    public static void deleteTableExtensions(GeoPackageCore geoPackage, String table) {
        NGAExtensions.deleteTableExtensions(geoPackage, table);
        GeoPackageExtensions.deleteRTreeSpatialIndex(geoPackage, table);
        GeoPackageExtensions.deleteRelatedTables(geoPackage, table);
        GeoPackageExtensions.deleteGriddedCoverage(geoPackage, table);
        GeoPackageExtensions.deleteSchema(geoPackage, table);
        GeoPackageExtensions.deleteMetadata(geoPackage, table);
        GeoPackageExtensions.delete(geoPackage, table);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage) {
        NGAExtensions.deleteExtensions(geoPackage);
        GeoPackageExtensions.deleteRTreeSpatialIndexExtension(geoPackage);
        GeoPackageExtensions.deleteRelatedTablesExtension(geoPackage);
        GeoPackageExtensions.deleteGriddedCoverageExtension(geoPackage);
        GeoPackageExtensions.deleteSchemaExtension(geoPackage);
        GeoPackageExtensions.deleteMetadataExtension(geoPackage);
        GeoPackageExtensions.deleteCrsWktExtension(geoPackage);
        GeoPackageExtensions.delete(geoPackage);
    }

    public static void copyTableExtensions(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            GeoPackageExtensions.copyRTreeSpatialIndex(geoPackage, table, newTable);
            GeoPackageExtensions.copyRelatedTables(geoPackage, table, newTable);
            GeoPackageExtensions.copyGriddedCoverage(geoPackage, table, newTable);
            GeoPackageExtensions.copySchema(geoPackage, table, newTable);
            GeoPackageExtensions.copyMetadata(geoPackage, table, newTable);
            NGAExtensions.copyTableExtensions(geoPackage, table, newTable);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to copy extensions for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private static void delete(GeoPackageCore geoPackage, String table) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table extensions. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    private static void delete(GeoPackageCore geoPackage) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                geoPackage.dropTable(extensionsDao.getTableName());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete all extensions. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteRTreeSpatialIndex(GeoPackageCore geoPackage, String table) {
        RTreeIndexCoreExtension rTreeIndexExtension = GeoPackageExtensions.getRTreeIndexExtension(geoPackage);
        if (rTreeIndexExtension.has(table)) {
            rTreeIndexExtension.delete(table);
        }
    }

    public static void deleteRTreeSpatialIndexExtension(GeoPackageCore geoPackage) {
        RTreeIndexCoreExtension rTreeIndexExtension = GeoPackageExtensions.getRTreeIndexExtension(geoPackage);
        if (rTreeIndexExtension.has()) {
            rTreeIndexExtension.deleteAll();
        }
    }

    public static void copyRTreeSpatialIndex(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            TableInfo tableInfo;
            GeometryColumnsDao geometryColumnsDao;
            GeometryColumns geometryColumns;
            RTreeIndexCoreExtension rTreeIndexExtension = GeoPackageExtensions.getRTreeIndexExtension(geoPackage);
            if (rTreeIndexExtension.has(table) && (geometryColumns = (geometryColumnsDao = geoPackage.getGeometryColumnsDao()).queryForTableName(newTable)) != null && (tableInfo = TableInfo.info(geoPackage.getDatabase(), newTable)) != null) {
                String pk = tableInfo.getPrimaryKey().getName();
                rTreeIndexExtension.create(newTable, geometryColumns.getColumnName(), pk);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create RTree for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private static RTreeIndexCoreExtension getRTreeIndexExtension(GeoPackageCore geoPackage) {
        return new RTreeIndexCoreExtension(geoPackage){

            @Override
            public void createMinYFunction() {
            }

            @Override
            public void createMinXFunction() {
            }

            @Override
            public void createMaxYFunction() {
            }

            @Override
            public void createMaxXFunction() {
            }

            @Override
            public void createIsEmptyFunction() {
            }
        };
    }

    public static void deleteRelatedTables(GeoPackageCore geoPackage, String table) {
        RelatedTablesCoreExtension relatedTablesExtension = GeoPackageExtensions.getRelatedTableExtension(geoPackage);
        if (relatedTablesExtension.has()) {
            relatedTablesExtension.removeRelationships(table);
        }
    }

    public static void deleteRelatedTablesExtension(GeoPackageCore geoPackage) {
        RelatedTablesCoreExtension relatedTablesExtension = GeoPackageExtensions.getRelatedTableExtension(geoPackage);
        if (relatedTablesExtension.has()) {
            relatedTablesExtension.removeExtension();
        }
    }

    public static void copyRelatedTables(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            RelatedTablesCoreExtension relatedTablesExtension = GeoPackageExtensions.getRelatedTableExtension(geoPackage);
            if (relatedTablesExtension.has()) {
                ExtendedRelationsDao extendedRelationsDao = relatedTablesExtension.getExtendedRelationsDao();
                ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
                List<ExtendedRelation> extendedRelations = extendedRelationsDao.getBaseTableRelations(table);
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    String mappingTableName = extendedRelation.getMappingTableName();
                    List<Extensions> extensions = extensionsDao.queryByExtension(RelatedTablesCoreExtension.EXTENSION_NAME, mappingTableName);
                    if (extensions.isEmpty()) continue;
                    String newMappingTableName = CoreSQLUtils.createName(geoPackage.getDatabase(), mappingTableName, table, newTable);
                    UserCustomTable userTable = UserCustomTableReader.readTable(geoPackage.getDatabase(), mappingTableName);
                    AlterTable.copyTable(geoPackage.getDatabase(), userTable, newMappingTableName);
                    Extensions extension = extensions.get(0);
                    extension.setTableName(newMappingTableName);
                    extensionsDao.create(extension);
                    TableMapping extendedRelationTableMapping = new TableMapping(geoPackage.getDatabase(), "gpkgext_relations");
                    extendedRelationTableMapping.removeColumn("id");
                    MappedColumn baseTableNameColumn = extendedRelationTableMapping.getColumn("base_table_name");
                    baseTableNameColumn.setConstantValue(newTable);
                    baseTableNameColumn.setWhereValue(table);
                    MappedColumn mappingTableNameColumn = extendedRelationTableMapping.getColumn("mapping_table_name");
                    mappingTableNameColumn.setConstantValue(newMappingTableName);
                    mappingTableNameColumn.setWhereValue(mappingTableName);
                    CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), extendedRelationTableMapping);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Related Tables for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private static RelatedTablesCoreExtension getRelatedTableExtension(GeoPackageCore geoPackage) {
        return new RelatedTablesCoreExtension(geoPackage){};
    }

    public static void deleteGriddedCoverage(GeoPackageCore geoPackage, String table) {
        if (geoPackage.isTableType(ContentsDataType.GRIDDED_COVERAGE, table)) {
            GriddedTileDao griddedTileDao = geoPackage.getGriddedTileDao();
            GriddedCoverageDao griddedCoverageDao = geoPackage.getGriddedCoverageDao();
            ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
            try {
                if (griddedTileDao.isTableExists()) {
                    griddedTileDao.delete(table);
                }
                if (griddedCoverageDao.isTableExists()) {
                    griddedCoverageDao.delete(table);
                }
                if (extensionsDao.isTableExists()) {
                    extensionsDao.deleteByExtension(CoverageDataCore.EXTENSION_NAME, table);
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
            }
        }
    }

    public static void deleteGriddedCoverageExtension(GeoPackageCore geoPackage) {
        List<String> coverageTables = geoPackage.getTables(ContentsDataType.GRIDDED_COVERAGE);
        for (String table : coverageTables) {
            geoPackage.deleteTable(table);
        }
        GriddedTileDao griddedTileDao = geoPackage.getGriddedTileDao();
        GriddedCoverageDao griddedCoverageDao = geoPackage.getGriddedCoverageDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (griddedTileDao.isTableExists()) {
                geoPackage.dropTable(griddedTileDao.getTableName());
            }
            if (griddedCoverageDao.isTableExists()) {
                geoPackage.dropTable(griddedCoverageDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(CoverageDataCore.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Gridded Coverage extension and tables. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void copyGriddedCoverage(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            List<Extensions> extensions;
            ExtensionsDao extensionsDao;
            if (geoPackage.isTableType(ContentsDataType.GRIDDED_COVERAGE, table) && (extensionsDao = geoPackage.getExtensionsDao()).isTableExists() && !(extensions = extensionsDao.queryByExtension(CoverageDataCore.EXTENSION_NAME, table)).isEmpty()) {
                GriddedTileDao griddedTileDao;
                Extensions extension = extensions.get(0);
                extension.setTableName(newTable);
                extensionsDao.create(extension);
                GriddedCoverageDao griddedCoverageDao = geoPackage.getGriddedCoverageDao();
                if (griddedCoverageDao.isTableExists()) {
                    CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), "gpkg_2d_gridded_coverage_ancillary", "tile_matrix_set_name", newTable, table, "id");
                }
                if ((griddedTileDao = geoPackage.getGriddedTileDao()).isTableExists()) {
                    CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), "gpkg_2d_gridded_tile_ancillary", "tpudt_name", newTable, table, "id");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Gridded Coverage for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public static void deleteSchema(GeoPackageCore geoPackage, String table) {
        DataColumnsDao dataColumnsDao = geoPackage.getDataColumnsDao();
        try {
            if (dataColumnsDao.isTableExists()) {
                dataColumnsDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Schema extension. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteSchemaExtension(GeoPackageCore geoPackage) {
        SchemaExtension schemaExtension = new SchemaExtension(geoPackage);
        if (schemaExtension.has()) {
            schemaExtension.removeExtension();
        }
    }

    public static void copySchema(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            if (geoPackage.isTable("gpkg_data_columns")) {
                UserCustomTable dataColumnsTable = UserCustomTableReader.readTable(geoPackage.getDatabase(), "gpkg_data_columns");
                UserCustomColumn nameColumn = (UserCustomColumn)dataColumnsTable.getColumn("name");
                if (nameColumn.hasConstraints()) {
                    nameColumn.clearConstraints();
                    if (dataColumnsTable.hasConstraints()) {
                        dataColumnsTable.clearConstraints();
                        String constraintSql = GeoPackageTableCreator.readSQLScript(GeoPackageTableCreator.DATA_COLUMNS).get(0);
                        TableConstraints constraints = ConstraintParser.getConstraints(constraintSql);
                        dataColumnsTable.addConstraints(constraints.getTableConstraints());
                    }
                    AlterTable.alterColumn(geoPackage.getDatabase(), dataColumnsTable, nameColumn);
                }
                CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), "gpkg_data_columns", "table_name", newTable, table);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Schema for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public static void deleteMetadata(GeoPackageCore geoPackage, String table) {
        MetadataReferenceDao metadataReferenceDao = geoPackage.getMetadataReferenceDao();
        try {
            if (metadataReferenceDao.isTableExists()) {
                metadataReferenceDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Metadata extension. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteMetadataExtension(GeoPackageCore geoPackage) {
        MetadataExtension metadataExtension = new MetadataExtension(geoPackage);
        if (metadataExtension.has()) {
            metadataExtension.removeExtension();
        }
    }

    public static void copyMetadata(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            if (geoPackage.isTable("gpkg_metadata_reference")) {
                CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), "gpkg_metadata_reference", "table_name", newTable, table);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Metadata for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public static void deleteCrsWktExtension(GeoPackageCore geoPackage) {
        CrsWktExtension crsWktExtension = new CrsWktExtension(geoPackage);
        if (crsWktExtension.has()) {
            crsWktExtension.removeExtension();
        }
    }
}

