/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.DateConverter;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.sf.GeometryType;

public class TableInfo {
    private static final Logger logger = Logger.getLogger(TableInfo.class.getName());
    public static final String CID = "cid";
    public static final int CID_INDEX = 0;
    public static final String NAME = "name";
    public static final int NAME_INDEX = 1;
    public static final String TYPE = "type";
    public static final int TYPE_INDEX = 2;
    public static final String NOT_NULL = "notnull";
    public static final int NOT_NULL_INDEX = 3;
    public static final String DFLT_VALUE = "dflt_value";
    public static final int DFLT_VALUE_INDEX = 4;
    public static final String PK = "pk";
    public static final int PK_INDEX = 5;
    public static final String DEFAULT_NULL = "NULL";
    private final String tableName;
    private final List<TableColumn> columns;
    private final Map<String, TableColumn> namesToColumns = new HashMap<String, TableColumn>();
    private final List<TableColumn> primaryKeys = new ArrayList<TableColumn>();

    private TableInfo(String tableName, List<TableColumn> columns) {
        this.tableName = tableName;
        this.columns = columns;
        for (TableColumn column : columns) {
            this.namesToColumns.put(column.getName(), column);
            if (!column.isPrimarykey()) continue;
            this.primaryKeys.add(column);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public int numColumns() {
        return this.columns.size();
    }

    public List<TableColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public TableColumn getColumn(int index) {
        if (index < 0 || index >= this.columns.size()) {
            throw new IndexOutOfBoundsException("Column index: " + index + ", not within range 0 to " + (this.columns.size() - 1));
        }
        return this.columns.get(index);
    }

    public boolean hasColumn(String name) {
        return this.getColumn(name) != null;
    }

    public TableColumn getColumn(String name) {
        return this.namesToColumns.get(name);
    }

    public boolean hasPrimaryKey() {
        return !this.primaryKeys.isEmpty();
    }

    public List<TableColumn> getPrimaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public TableColumn getPrimaryKey() {
        TableColumn pk = null;
        if (this.hasPrimaryKey()) {
            pk = this.primaryKeys.get(0);
        }
        return pk;
    }

    public static TableInfo info(GeoPackageCoreConnection db, String tableName) {
        String sql = "PRAGMA table_info(" + CoreSQLUtils.quoteWrap(tableName) + ")";
        List<List<Object>> results = db.queryResults(sql, null);
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        for (List<Object> column : results) {
            String maxString;
            int maxStart;
            int index = ((Number)column.get(0)).intValue();
            String name = (String)column.get(1);
            String type = (String)column.get(2);
            boolean notNull = ((Number)column.get(3)).intValue() == 1;
            String defaultValueString = (String)column.get(4);
            boolean primaryKey = ((Number)column.get(5)).intValue() == 1;
            Long max = null;
            if (type != null && type.endsWith(")") && (maxStart = type.indexOf("(")) > -1 && !(maxString = type.substring(maxStart + 1, type.length() - 1)).isEmpty()) {
                try {
                    max = Long.valueOf(maxString);
                    type = type.substring(0, maxStart);
                }
                catch (NumberFormatException e) {
                    logger.log(Level.WARNING, "Failed to parse type max from type: " + type, e);
                }
            }
            GeoPackageDataType dataType = TableInfo.getDataType(type);
            Object defaultValue = TableInfo.getDefaultValue(defaultValueString, dataType);
            TableColumn tableColumn = new TableColumn(index, name, type, dataType, max, notNull, defaultValueString, defaultValue, primaryKey);
            tableColumns.add(tableColumn);
        }
        TableInfo tableInfo = null;
        if (!tableColumns.isEmpty()) {
            tableInfo = new TableInfo(tableName, tableColumns);
        }
        return tableInfo;
    }

    public static GeoPackageDataType getDataType(String type) {
        GeoPackageDataType dataType = GeoPackageDataType.findName(type);
        if (dataType == null && GeometryType.findName((String)type) != null) {
            dataType = GeoPackageDataType.BLOB;
        }
        return dataType;
    }

    public static Object getDefaultValue(String defaultValue, String type) {
        return TableInfo.getDefaultValue(defaultValue, TableInfo.getDataType(type));
    }

    public static Object getDefaultValue(String defaultValue, GeoPackageDataType type) {
        Object value = defaultValue;
        if (defaultValue != null && type != null && !defaultValue.equalsIgnoreCase(DEFAULT_NULL)) {
            switch (type) {
                case TEXT: {
                    break;
                }
                case DATE: 
                case DATETIME: {
                    if (DateConverter.isFunction(defaultValue)) break;
                    DateConverter converter = DateConverter.converter(type);
                    try {
                        value = converter.dateValue(defaultValue);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Invalid " + (Object)((Object)type) + " format: " + defaultValue + ", String value used", e);
                    }
                    break;
                }
                case BOOLEAN: {
                    value = Integer.parseInt(defaultValue) == 0 ? Boolean.FALSE : Boolean.TRUE;
                    break;
                }
                case TINYINT: {
                    value = Byte.parseByte(defaultValue);
                    break;
                }
                case SMALLINT: {
                    value = Short.parseShort(defaultValue);
                    break;
                }
                case MEDIUMINT: {
                    value = Integer.parseInt(defaultValue);
                    break;
                }
                case INT: 
                case INTEGER: {
                    value = Long.parseLong(defaultValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(defaultValue));
                    break;
                }
                case DOUBLE: 
                case REAL: {
                    value = Double.parseDouble(defaultValue);
                    break;
                }
                case BLOB: {
                    value = defaultValue.getBytes();
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported Data Type " + (Object)((Object)type));
                }
            }
        }
        return value;
    }
}

