/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.wkt;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.crs.CRS;
import mil.nga.crs.CRSException;
import mil.nga.crs.CompoundCoordinateReferenceSystem;
import mil.nga.crs.CoordinateReferenceSystem;
import mil.nga.crs.bound.AbridgedCoordinateTransformation;
import mil.nga.crs.bound.BoundCoordinateReferenceSystem;
import mil.nga.crs.common.Axis;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.DatumEnsemble;
import mil.nga.crs.common.DatumEnsembleMember;
import mil.nga.crs.common.Dynamic;
import mil.nga.crs.common.Extent;
import mil.nga.crs.common.GeographicBoundingBox;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.ReferenceFrame;
import mil.nga.crs.common.ScopeExtentIdentifierRemark;
import mil.nga.crs.common.TemporalExtent;
import mil.nga.crs.common.Unit;
import mil.nga.crs.common.Usage;
import mil.nga.crs.common.VerticalExtent;
import mil.nga.crs.derived.DerivedCoordinateReferenceSystem;
import mil.nga.crs.derived.DerivingConversion;
import mil.nga.crs.engineering.EngineeringCoordinateReferenceSystem;
import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.GeoCoordinateReferenceSystem;
import mil.nga.crs.geo.GeoDatumEnsemble;
import mil.nga.crs.geo.GeoReferenceFrame;
import mil.nga.crs.geo.PrimeMeridian;
import mil.nga.crs.geo.TriaxialEllipsoid;
import mil.nga.crs.metadata.CoordinateMetadata;
import mil.nga.crs.operation.CommonOperation;
import mil.nga.crs.operation.ConcatenatedOperation;
import mil.nga.crs.operation.CoordinateOperation;
import mil.nga.crs.operation.OperationMethod;
import mil.nga.crs.operation.OperationParameter;
import mil.nga.crs.operation.PointMotionOperation;
import mil.nga.crs.parametric.ParametricCoordinateReferenceSystem;
import mil.nga.crs.projected.MapProjection;
import mil.nga.crs.projected.ProjectedCoordinateReferenceSystem;
import mil.nga.crs.temporal.TemporalCoordinateReferenceSystem;
import mil.nga.crs.temporal.TemporalDatum;
import mil.nga.crs.vertical.VerticalCoordinateReferenceSystem;
import mil.nga.crs.wkt.CRSKeyword;
import mil.nga.crs.wkt.WKTUtils;

public class CRSWriter
implements Closeable {
    private static final Logger logger = Logger.getLogger(CRSWriter.class.getName());
    private Writer writer;

    public static String write(CRS crs) throws IOException {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.writeCRS(crs);
            value = writer.toString();
        }
        return value;
    }

    public static String writePretty(CRS crs) throws IOException {
        return CRSWriter.writePretty(CRSWriter.write(crs));
    }

    public static String writePrettyTabIndent(CRS crs) throws IOException {
        return CRSWriter.writePrettyTabIndent(CRSWriter.write(crs));
    }

    public static String writePrettyNoIndent(CRS crs) throws IOException {
        return CRSWriter.writePrettyNoIndent(CRSWriter.write(crs));
    }

    public static String writePretty(CRS crs, String indent) throws IOException {
        return CRSWriter.writePretty(CRSWriter.write(crs), indent);
    }

    public static String writePretty(CRS crs, String newline, String indent) throws IOException {
        return CRSWriter.writePretty(CRSWriter.write(crs), newline, indent);
    }

    public static String writePretty(String wkt) throws IOException {
        return WKTUtils.pretty(wkt);
    }

    public static String writePrettyTabIndent(String wkt) throws IOException {
        return WKTUtils.prettyTabIndent(wkt);
    }

    public static String writePrettyNoIndent(String wkt) throws IOException {
        return WKTUtils.prettyNoIndent(wkt);
    }

    public static String writePretty(String wkt, String indent) throws IOException {
        return WKTUtils.pretty(wkt, indent);
    }

    public static String writePretty(String wkt, String newline, String indent) throws IOException {
        return WKTUtils.pretty(wkt, newline, indent);
    }

    public CRSWriter() {
        this(new StringWriter());
    }

    public CRSWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String toString() {
        return this.writer.toString();
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close writer", e);
        }
    }

    public void writeCRS(CRS crs) throws IOException {
        switch (crs.getType()) {
            case GEODETIC: 
            case GEOGRAPHIC: {
                this.writeGeo((GeoCoordinateReferenceSystem)crs);
                break;
            }
            case PROJECTED: {
                this.writeProjected((ProjectedCoordinateReferenceSystem)crs);
                break;
            }
            case VERTICAL: {
                this.writeVertical((VerticalCoordinateReferenceSystem)crs);
                break;
            }
            case ENGINEERING: {
                this.writeEngineering((EngineeringCoordinateReferenceSystem)crs);
                break;
            }
            case PARAMETRIC: {
                this.writeParametric((ParametricCoordinateReferenceSystem)crs);
                break;
            }
            case TEMPORAL: {
                this.writeTemporal((TemporalCoordinateReferenceSystem)crs);
                break;
            }
            case DERIVED: {
                this.writeDerived((DerivedCoordinateReferenceSystem)crs);
                break;
            }
            case COMPOUND: {
                this.writeCompound((CompoundCoordinateReferenceSystem)crs);
                break;
            }
            case COORDINATE_METADATA: {
                this.writeCoordinateMetadata((CoordinateMetadata)crs);
                break;
            }
            case COORDINATE_OPERATION: {
                this.writeCoordinateOperation((CoordinateOperation)crs);
                break;
            }
            case POINT_MOTION_OPERATION: {
                this.writePointMotionOperation((PointMotionOperation)crs);
                break;
            }
            case CONCATENATED_OPERATION: {
                this.writeConcatenatedOperation((ConcatenatedOperation)crs);
                break;
            }
            case BOUND: {
                this.writeBound((BoundCoordinateReferenceSystem)crs);
                break;
            }
            default: {
                throw new CRSException("Unsupported CRS type: " + crs.getType());
            }
        }
    }

    public void write(CRSKeyword keyword) throws IOException {
        this.writer.write(keyword.name());
    }

    public void writeLeftDelimiter() throws IOException {
        this.writer.write("[");
    }

    public void writeRightDelimiter() throws IOException {
        this.writer.write("]");
    }

    public void writeSeparator() throws IOException {
        this.writer.write(",");
    }

    public void writeQuotedText(String text) throws IOException {
        this.writer.write("\"");
        this.writer.write(text.replaceAll("\"", "\"\""));
        this.writer.write("\"");
    }

    public void write(Number number) throws IOException {
        this.writer.write(number.toString());
    }

    public void writeNumberOrQuotedText(String text) throws IOException {
        try {
            Double.parseDouble(text);
            this.writer.write(text);
        }
        catch (NumberFormatException e) {
            this.writeQuotedText(text);
        }
    }

    public void writeKeywordDelimitedQuotedText(CRSKeyword keyword, String text) throws IOException {
        this.write(keyword);
        this.writeLeftDelimiter();
        this.writeQuotedText(text);
        this.writeRightDelimiter();
    }

    public void writeGeo(GeoCoordinateReferenceSystem crs) throws IOException {
        CRSKeyword keyword = null;
        switch (crs.getType()) {
            case GEODETIC: {
                keyword = CRSKeyword.GEODCRS;
                break;
            }
            case GEOGRAPHIC: {
                keyword = CRSKeyword.GEOGCRS;
                break;
            }
            default: {
                throw new CRSException("Invalid Geodetic or Geographic Coordinate Reference System Type: " + crs.getType());
            }
        }
        this.write(keyword);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        if (crs.hasDynamic()) {
            this.writeSeparator();
            this.write(crs.getDynamic());
        }
        this.writeSeparator();
        if (crs.hasDynamic() || crs.hasReferenceFrame()) {
            this.write(crs.getReferenceFrame());
        } else {
            this.write(crs.getDatumEnsemble());
        }
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeProjected(ProjectedCoordinateReferenceSystem crs) throws IOException {
        this.write(CRSKeyword.PROJCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        CRSKeyword baseKeyword = null;
        switch (crs.getBaseType()) {
            case GEODETIC: {
                baseKeyword = CRSKeyword.BASEGEODCRS;
                break;
            }
            case GEOGRAPHIC: {
                baseKeyword = CRSKeyword.BASEGEOGCRS;
                break;
            }
            default: {
                throw new CRSException("Invalid Geodetic or Geographic Base Coordinate Reference System Type: " + crs.getBaseType());
            }
        }
        this.writeSeparator();
        this.write(baseKeyword);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getBaseName());
        if (crs.hasDynamic()) {
            this.writeSeparator();
            this.write(crs.getDynamic());
        }
        this.writeSeparator();
        if (crs.hasDynamic() || crs.hasReferenceFrame()) {
            this.write(crs.getReferenceFrame());
        } else {
            this.write(crs.getDatumEnsemble());
        }
        if (crs.hasUnit()) {
            this.writeSeparator();
            this.write(crs.getUnit());
        }
        if (crs.hasBaseIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(crs.getBaseIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(crs.getMapProjection());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeVertical(VerticalCoordinateReferenceSystem crs) throws IOException {
        this.write(CRSKeyword.VERTCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        if (crs.hasDynamic()) {
            this.writeSeparator();
            this.write(crs.getDynamic());
        }
        this.writeSeparator();
        if (crs.hasDynamic() || crs.hasReferenceFrame()) {
            this.write(crs.getReferenceFrame());
        } else {
            this.write(crs.getDatumEnsemble());
        }
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        if (crs.hasGeoidModelName()) {
            this.writeSeparator();
            this.write(CRSKeyword.GEOIDMODEL);
            this.writeLeftDelimiter();
            this.writeQuotedText(crs.getGeoidModelName());
            if (crs.hasGeoidModelIdentifier()) {
                this.writeSeparator();
                this.write(crs.getGeoidModelIdentifier());
            }
            this.writeRightDelimiter();
        }
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeEngineering(EngineeringCoordinateReferenceSystem crs) throws IOException {
        this.write(CRSKeyword.ENGCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(crs.getDatum());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeParametric(ParametricCoordinateReferenceSystem crs) throws IOException {
        this.write(CRSKeyword.PARAMETRICCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(crs.getDatum());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeTemporal(TemporalCoordinateReferenceSystem crs) throws IOException {
        this.write(CRSKeyword.TIMECRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(crs.getDatum());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeDerived(DerivedCoordinateReferenceSystem crs) throws IOException {
        switch (crs.getBaseType()) {
            case GEODETIC: 
            case GEOGRAPHIC: {
                this.writeDerivedGeoCRS(crs);
                break;
            }
            case PROJECTED: {
                this.writeDerivedProjectedCRS(crs);
                break;
            }
            case VERTICAL: {
                this.writeDerivedVerticalCRS(crs);
                break;
            }
            case ENGINEERING: {
                this.writeDerivedEngineeringCRS(crs);
                break;
            }
            case PARAMETRIC: {
                this.writeDerivedParametricCRS(crs);
                break;
            }
            case TEMPORAL: {
                this.writeDerivedTemporalCRS(crs);
                break;
            }
            default: {
                throw new CRSException("Unsupported derived base CRS type: " + crs.getBaseType());
            }
        }
    }

    public void writeDerivedGeoCRS(DerivedCoordinateReferenceSystem crs) throws IOException {
        CRSKeyword keyword = null;
        CRSKeyword baseKeyword = null;
        switch (crs.getBaseType()) {
            case GEODETIC: {
                keyword = CRSKeyword.GEODCRS;
                baseKeyword = CRSKeyword.BASEGEODCRS;
                break;
            }
            case GEOGRAPHIC: {
                keyword = CRSKeyword.GEOGCRS;
                baseKeyword = CRSKeyword.BASEGEOGCRS;
                break;
            }
            default: {
                throw new CRSException("Invalid Derived Geodetic or Geographic Coordinate Reference System Type: " + crs.getBaseType());
            }
        }
        GeoCoordinateReferenceSystem baseCrs = (GeoCoordinateReferenceSystem)crs.getBase();
        this.write(keyword);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(baseKeyword);
        this.writeLeftDelimiter();
        this.writeQuotedText(baseCrs.getName());
        if (baseCrs.hasDynamic()) {
            this.writeSeparator();
            this.write(baseCrs.getDynamic());
        }
        this.writeSeparator();
        if (baseCrs.hasDynamic() || baseCrs.hasReferenceFrame()) {
            this.write(baseCrs.getReferenceFrame());
        } else {
            this.write(baseCrs.getDatumEnsemble());
        }
        if (baseCrs.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(baseCrs.getIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(crs.getConversion());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeDerivedProjectedCRS(DerivedCoordinateReferenceSystem crs) throws IOException {
        ProjectedCoordinateReferenceSystem projectedCrs = (ProjectedCoordinateReferenceSystem)crs.getBase();
        this.write(CRSKeyword.DERIVEDPROJCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(CRSKeyword.BASEPROJCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(projectedCrs.getName());
        CRSKeyword keyword = null;
        switch (projectedCrs.getBaseType()) {
            case GEODETIC: {
                keyword = CRSKeyword.BASEGEODCRS;
                break;
            }
            case GEOGRAPHIC: {
                keyword = CRSKeyword.BASEGEOGCRS;
                break;
            }
            default: {
                throw new CRSException("Invalid Derived Projected Geodetic or Geographic Coordinate Reference System Type: " + projectedCrs.getBaseType());
            }
        }
        this.writeSeparator();
        this.write(keyword);
        this.writeLeftDelimiter();
        this.writeQuotedText(projectedCrs.getBaseName());
        if (projectedCrs.hasDynamic()) {
            this.writeSeparator();
            this.write(projectedCrs.getDynamic());
        }
        this.writeSeparator();
        if (projectedCrs.hasDynamic() || projectedCrs.hasReferenceFrame()) {
            this.write(projectedCrs.getReferenceFrame());
        } else {
            this.write(projectedCrs.getDatumEnsemble());
        }
        if (projectedCrs.hasBaseIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(projectedCrs.getBaseIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(projectedCrs.getMapProjection());
        if (projectedCrs.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(projectedCrs.getIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(crs.getConversion());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeDerivedVerticalCRS(DerivedCoordinateReferenceSystem crs) throws IOException {
        VerticalCoordinateReferenceSystem baseCrs = (VerticalCoordinateReferenceSystem)crs.getBase();
        this.write(CRSKeyword.VERTCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(CRSKeyword.BASEVERTCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(baseCrs.getName());
        if (baseCrs.hasDynamic()) {
            this.writeSeparator();
            this.write(baseCrs.getDynamic());
        }
        this.writeSeparator();
        if (baseCrs.hasDynamic() || baseCrs.hasReferenceFrame()) {
            this.write(baseCrs.getReferenceFrame());
        } else {
            this.write(baseCrs.getDatumEnsemble());
        }
        if (baseCrs.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(baseCrs.getIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(crs.getConversion());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeDerivedEngineeringCRS(DerivedCoordinateReferenceSystem crs) throws IOException {
        EngineeringCoordinateReferenceSystem baseCrs = (EngineeringCoordinateReferenceSystem)crs.getBase();
        this.write(CRSKeyword.ENGCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(CRSKeyword.BASEENGCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(baseCrs.getName());
        this.writeSeparator();
        this.write(baseCrs.getDatum());
        if (baseCrs.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(baseCrs.getIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(crs.getConversion());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeDerivedParametricCRS(DerivedCoordinateReferenceSystem crs) throws IOException {
        ParametricCoordinateReferenceSystem baseCrs = (ParametricCoordinateReferenceSystem)crs.getBase();
        this.write(CRSKeyword.PARAMETRICCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(CRSKeyword.BASEPARAMCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(baseCrs.getName());
        this.writeSeparator();
        this.write(baseCrs.getDatum());
        if (baseCrs.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(baseCrs.getIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(crs.getConversion());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeDerivedTemporalCRS(DerivedCoordinateReferenceSystem crs) throws IOException {
        TemporalCoordinateReferenceSystem baseCrs = (TemporalCoordinateReferenceSystem)crs.getBase();
        this.write(CRSKeyword.TIMECRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        this.writeSeparator();
        this.write(CRSKeyword.BASETIMECRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(baseCrs.getName());
        this.writeSeparator();
        this.write(baseCrs.getDatum());
        if (baseCrs.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(baseCrs.getIdentifiers());
        }
        this.writeRightDelimiter();
        this.writeSeparator();
        this.write(crs.getConversion());
        this.writeSeparator();
        this.write(crs.getCoordinateSystem());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeCompound(CompoundCoordinateReferenceSystem crs) throws IOException {
        this.write(CRSKeyword.COMPOUNDCRS);
        this.writeLeftDelimiter();
        this.writeQuotedText(crs.getName());
        for (CRS cRS : crs.getCoordinateReferenceSystems()) {
            this.writeSeparator();
            this.writeCRS(cRS);
        }
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeCoordinateMetadata(CoordinateMetadata metadata) throws IOException {
        this.write(CRSKeyword.COORDINATEMETADATA);
        this.writeLeftDelimiter();
        this.writeCRS(metadata.getCoordinateReferenceSystem());
        if (metadata.hasEpoch()) {
            this.writeSeparator();
            this.write(CRSKeyword.EPOCH);
            this.writeLeftDelimiter();
            this.writer.write(metadata.getEpochText());
            this.writeRightDelimiter();
        }
        this.writeRightDelimiter();
    }

    public void writeCoordinateOperation(CoordinateOperation operation) throws IOException {
        this.write(CRSKeyword.COORDINATEOPERATION);
        this.writeLeftDelimiter();
        this.writeQuotedText(operation.getName());
        if (operation.hasVersion()) {
            this.writeSeparator();
            this.writeVersion(operation.getVersion());
        }
        this.writeSeparator();
        this.writeSource(operation.getSource());
        this.writeSeparator();
        this.writeTarget(operation.getTarget());
        this.writeSeparator();
        OperationMethod method = operation.getMethod();
        this.write(method);
        if (method.hasParameters()) {
            this.writeSeparator();
            this.writeParameters(method.getParameters());
        }
        if (operation.hasInterpolation()) {
            this.writeSeparator();
            this.writeInterpolation(operation.getInterpolation());
        }
        if (operation.hasAccuracy()) {
            this.writeSeparator();
            this.writeAccuracy(operation.getAccuracyText());
        }
        this.writeScopeExtentIdentifierRemark(operation);
        this.writeRightDelimiter();
    }

    public void writePointMotionOperation(PointMotionOperation operation) throws IOException {
        this.write(CRSKeyword.POINTMOTIONOPERATION);
        this.writeLeftDelimiter();
        this.writeQuotedText(operation.getName());
        if (operation.hasVersion()) {
            this.writeSeparator();
            this.writeVersion(operation.getVersion());
        }
        this.writeSeparator();
        this.writeSource(operation.getSource());
        this.writeSeparator();
        OperationMethod method = operation.getMethod();
        this.write(method);
        if (method.hasParameters()) {
            this.writeSeparator();
            this.writeParameters(method.getParameters());
        }
        if (operation.hasAccuracy()) {
            this.writeSeparator();
            this.writeAccuracy(operation.getAccuracy());
        }
        this.writeScopeExtentIdentifierRemark(operation);
        this.writeRightDelimiter();
    }

    public void writeConcatenatedOperation(ConcatenatedOperation operation) throws IOException {
        this.write(CRSKeyword.CONCATENATEDOPERATION);
        this.writeLeftDelimiter();
        this.writeQuotedText(operation.getName());
        if (operation.hasVersion()) {
            this.writeSeparator();
            this.writeVersion(operation.getVersion());
        }
        this.writeSeparator();
        this.writeSource(operation.getSource());
        this.writeSeparator();
        this.writeTarget(operation.getTarget());
        for (CommonOperation concatenable : operation.getOperations()) {
            this.writeSeparator();
            this.write(CRSKeyword.STEP);
            this.writeLeftDelimiter();
            switch (concatenable.getOperationType()) {
                case COORDINATE: {
                    this.writeCoordinateOperation((CoordinateOperation)concatenable);
                    break;
                }
                case POINT_MOTION: {
                    this.writePointMotionOperation((PointMotionOperation)concatenable);
                    break;
                }
                case MAP_PROJECTION: {
                    this.write((MapProjection)concatenable);
                    break;
                }
                case DERIVING_CONVERSION: {
                    this.write((DerivingConversion)concatenable);
                    break;
                }
                default: {
                    throw new CRSException("Unsupported concatenable operation type: " + concatenable.getOperationType());
                }
            }
            this.writeRightDelimiter();
        }
        if (operation.hasAccuracy()) {
            this.writeSeparator();
            this.writeAccuracy(operation.getAccuracy());
        }
        this.writeScopeExtentIdentifierRemark(operation);
        this.writeRightDelimiter();
    }

    public void writeBound(BoundCoordinateReferenceSystem crs) throws IOException {
        this.write(CRSKeyword.BOUNDCRS);
        this.writeLeftDelimiter();
        this.writeSource(crs.getSource());
        this.writeSeparator();
        this.writeTarget(crs.getTarget());
        this.writeSeparator();
        this.write(crs.getTransformation());
        this.writeScopeExtentIdentifierRemark(crs);
        this.writeRightDelimiter();
    }

    public void writeScopeExtentIdentifierRemark(ScopeExtentIdentifierRemark object) throws IOException {
        if (object.hasUsages()) {
            this.writeSeparator();
            this.writeUsages(object.getUsages());
        }
        if (object.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(object.getIdentifiers());
        }
        if (object.hasRemark()) {
            this.writeSeparator();
            this.writeRemark(object.getRemark());
        }
    }

    public void write(ReferenceFrame referenceFrame) throws IOException {
        GeoReferenceFrame geodeticReferenceFrame = null;
        if (referenceFrame instanceof GeoReferenceFrame) {
            geodeticReferenceFrame = (GeoReferenceFrame)referenceFrame;
        }
        switch (referenceFrame.getType()) {
            case GEODETIC: 
            case GEOGRAPHIC: {
                this.write(CRSKeyword.DATUM);
                break;
            }
            case VERTICAL: {
                this.write(CRSKeyword.VDATUM);
                break;
            }
            case ENGINEERING: {
                this.write(CRSKeyword.EDATUM);
                break;
            }
            case PARAMETRIC: {
                this.write(CRSKeyword.PDATUM);
                break;
            }
            default: {
                throw new CRSException("Unexpected Reference Frame Coordinate Reference System Type: " + referenceFrame.getType());
            }
        }
        this.writeLeftDelimiter();
        this.writeQuotedText(referenceFrame.getName());
        if (geodeticReferenceFrame != null) {
            this.writeSeparator();
            this.write(geodeticReferenceFrame.getEllipsoid());
        }
        if (referenceFrame.hasAnchor()) {
            this.writeSeparator();
            this.writeKeywordDelimitedQuotedText(CRSKeyword.ANCHOR, referenceFrame.getAnchor());
        }
        if (referenceFrame.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(referenceFrame.getIdentifiers());
        }
        this.writeRightDelimiter();
        if (geodeticReferenceFrame != null && geodeticReferenceFrame.hasPrimeMeridian()) {
            this.writeSeparator();
            this.write(geodeticReferenceFrame.getPrimeMeridian());
        }
    }

    public void write(DatumEnsemble datumEnsemble) throws IOException {
        GeoDatumEnsemble geodeticDatumEnsemble = null;
        if (datumEnsemble instanceof GeoDatumEnsemble) {
            geodeticDatumEnsemble = (GeoDatumEnsemble)datumEnsemble;
        }
        this.write(CRSKeyword.ENSEMBLE);
        this.writeLeftDelimiter();
        this.writeQuotedText(datumEnsemble.getName());
        for (DatumEnsembleMember member : datumEnsemble.getMembers()) {
            this.writeSeparator();
            this.write(member);
        }
        if (geodeticDatumEnsemble != null) {
            this.writeSeparator();
            this.write(geodeticDatumEnsemble.getEllipsoid());
        }
        this.writeSeparator();
        this.write(CRSKeyword.ENSEMBLEACCURACY);
        this.writeLeftDelimiter();
        this.writer.write(datumEnsemble.getAccuracyText());
        this.writeRightDelimiter();
        if (datumEnsemble.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(datumEnsemble.getIdentifiers());
        }
        this.writeRightDelimiter();
        if (geodeticDatumEnsemble != null && geodeticDatumEnsemble.hasPrimeMeridian()) {
            this.writeSeparator();
            this.write(geodeticDatumEnsemble.getPrimeMeridian());
        }
    }

    public void write(DatumEnsembleMember datumEnsembleMember) throws IOException {
        this.write(CRSKeyword.MEMBER);
        this.writeLeftDelimiter();
        this.writeQuotedText(datumEnsembleMember.getName());
        if (datumEnsembleMember.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(datumEnsembleMember.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void write(Dynamic dynamic) throws IOException {
        this.write(CRSKeyword.DYNAMIC);
        this.writeLeftDelimiter();
        this.write(CRSKeyword.FRAMEEPOCH);
        this.writeLeftDelimiter();
        this.writer.write(dynamic.getReferenceEpochText());
        this.writeRightDelimiter();
        if (dynamic.hasDeformationModelName()) {
            this.writeSeparator();
            this.write(CRSKeyword.MODEL);
            this.writeLeftDelimiter();
            this.writeQuotedText(dynamic.getDeformationModelName());
            if (dynamic.hasIdentifiers()) {
                this.writeSeparator();
                this.writeIdentifiers(dynamic.getIdentifiers());
            }
            this.writeRightDelimiter();
        }
        this.writeRightDelimiter();
    }

    public void write(PrimeMeridian primeMeridian) throws IOException {
        this.write(CRSKeyword.PRIMEM);
        this.writeLeftDelimiter();
        this.writeQuotedText(primeMeridian.getName());
        this.writeSeparator();
        this.writer.write(primeMeridian.getLongitudeText());
        if (primeMeridian.hasLongitudeUnit()) {
            this.writeSeparator();
            this.write(primeMeridian.getLongitudeUnit());
        }
        if (primeMeridian.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(primeMeridian.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void write(Ellipsoid ellipsoid) throws IOException {
        TriaxialEllipsoid triaxial = null;
        if (ellipsoid instanceof TriaxialEllipsoid) {
            triaxial = (TriaxialEllipsoid)ellipsoid;
            this.write(CRSKeyword.TRIAXIAL);
        } else {
            this.write(CRSKeyword.ELLIPSOID);
        }
        this.writeLeftDelimiter();
        this.writeQuotedText(ellipsoid.getName());
        this.writeSeparator();
        this.writer.write(ellipsoid.getSemiMajorAxisText());
        if (triaxial != null) {
            this.writeSeparator();
            this.writer.write(triaxial.getSemiMedianAxisText());
            this.writeSeparator();
            this.writer.write(triaxial.getSemiMinorAxisText());
        } else {
            this.writeSeparator();
            this.writer.write(ellipsoid.getInverseFlatteningText());
        }
        if (ellipsoid.hasUnit()) {
            this.writeSeparator();
            this.write(ellipsoid.getUnit());
        }
        if (ellipsoid.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(ellipsoid.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void write(Unit unit) throws IOException {
        this.writer.write(unit.getType().name());
        this.writeLeftDelimiter();
        this.writeQuotedText(unit.getName());
        if (unit.hasConversionFactor()) {
            this.writeSeparator();
            this.writer.write(unit.getConversionFactorText());
        }
        if (unit.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(unit.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void writeIdentifiers(List<Identifier> identifiers) throws IOException {
        for (int i = 0; i < identifiers.size(); ++i) {
            if (i > 0) {
                this.writeSeparator();
            }
            this.write(identifiers.get(i));
        }
    }

    public void write(Identifier identifier) throws IOException {
        this.write(CRSKeyword.ID);
        this.writeLeftDelimiter();
        this.writeQuotedText(identifier.getName());
        this.writeSeparator();
        this.writeNumberOrQuotedText(identifier.getUniqueIdentifier());
        if (identifier.hasVersion()) {
            this.writeSeparator();
            this.writeNumberOrQuotedText(identifier.getVersion());
        }
        if (identifier.hasCitation()) {
            this.writeSeparator();
            this.writeKeywordDelimitedQuotedText(CRSKeyword.CITATION, identifier.getCitation());
        }
        if (identifier.hasUri()) {
            this.writeSeparator();
            this.writeKeywordDelimitedQuotedText(CRSKeyword.URI, identifier.getUri());
        }
        this.writeRightDelimiter();
    }

    public void write(CoordinateSystem coordinateSystem) throws IOException {
        this.write(CRSKeyword.CS);
        this.writeLeftDelimiter();
        this.writer.write(coordinateSystem.getType().getName());
        this.writeSeparator();
        this.write(coordinateSystem.getDimension());
        if (coordinateSystem.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(coordinateSystem.getIdentifiers());
        }
        this.writeRightDelimiter();
        for (Axis axis : coordinateSystem.getAxes()) {
            this.writeSeparator();
            this.write(axis);
        }
        if (coordinateSystem.hasUnit()) {
            this.writeSeparator();
            this.write(coordinateSystem.getUnit());
        }
    }

    public void write(Axis axis) throws IOException {
        this.write(CRSKeyword.AXIS);
        this.writeLeftDelimiter();
        StringBuilder nameAbbrev = new StringBuilder();
        if (axis.hasName()) {
            nameAbbrev.append(axis.getName());
        }
        if (axis.hasAbbreviation()) {
            if (nameAbbrev.length() > 0) {
                nameAbbrev.append(" ");
            }
            nameAbbrev.append("(");
            nameAbbrev.append(axis.getAbbreviation());
            nameAbbrev.append(")");
        }
        this.writeQuotedText(nameAbbrev.toString());
        this.writeSeparator();
        this.writer.write(axis.getDirection().getName());
        switch (axis.getDirection()) {
            case NORTH: 
            case SOUTH: {
                if (!axis.hasMeridian()) break;
                this.writeSeparator();
                this.write(CRSKeyword.MERIDIAN);
                this.writeLeftDelimiter();
                this.writer.write(axis.getMeridianText());
                this.writeSeparator();
                this.write(axis.getMeridianUnit());
                this.writeRightDelimiter();
                break;
            }
            case CLOCKWISE: 
            case COUNTER_CLOCKWISE: {
                this.writeSeparator();
                this.write(CRSKeyword.BEARING);
                this.writeLeftDelimiter();
                this.writer.write(axis.getBearingText());
                this.writeRightDelimiter();
                break;
            }
        }
        if (axis.hasOrder()) {
            this.writeSeparator();
            this.write(CRSKeyword.ORDER);
            this.writeLeftDelimiter();
            this.write(axis.getOrder());
            this.writeRightDelimiter();
        }
        if (axis.hasUnit()) {
            this.writeSeparator();
            this.write(axis.getUnit());
        }
        if (axis.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(axis.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void writeRemark(String remark) throws IOException {
        this.writeKeywordDelimitedQuotedText(CRSKeyword.REMARK, remark);
    }

    public void writeUsages(List<Usage> usages) throws IOException {
        for (int i = 0; i < usages.size(); ++i) {
            if (i > 0) {
                this.writeSeparator();
            }
            this.write(usages.get(i));
        }
    }

    public void write(Usage usage) throws IOException {
        this.write(CRSKeyword.USAGE);
        this.writeLeftDelimiter();
        this.writeScope(usage.getScope());
        this.write(usage.getExtent());
        this.writeRightDelimiter();
    }

    public void writeScope(String scope) throws IOException {
        this.writeKeywordDelimitedQuotedText(CRSKeyword.SCOPE, scope);
    }

    public void write(Extent extent) throws IOException {
        if (extent.hasAreaDescription()) {
            this.writeSeparator();
            this.writeAreaDescription(extent.getAreaDescription());
        }
        if (extent.hasGeographicBoundingBox()) {
            this.writeSeparator();
            this.write(extent.getGeographicBoundingBox());
        }
        if (extent.hasVerticalExtent()) {
            this.writeSeparator();
            this.write(extent.getVerticalExtent());
        }
        if (extent.hasTemporalExtent()) {
            this.writeSeparator();
            this.write(extent.getTemporalExtent());
        }
    }

    public void writeAreaDescription(String areaDescription) throws IOException {
        this.writeKeywordDelimitedQuotedText(CRSKeyword.AREA, areaDescription);
    }

    public void write(GeographicBoundingBox geographicBoundingBox) throws IOException {
        this.write(CRSKeyword.BBOX);
        this.writeLeftDelimiter();
        this.writer.write(geographicBoundingBox.getLowerLeftLatitudeText());
        this.writeSeparator();
        this.writer.write(geographicBoundingBox.getLowerLeftLongitudeText());
        this.writeSeparator();
        this.writer.write(geographicBoundingBox.getUpperRightLatitudeText());
        this.writeSeparator();
        this.writer.write(geographicBoundingBox.getUpperRightLongitudeText());
        this.writeRightDelimiter();
    }

    public void write(VerticalExtent verticalExtent) throws IOException {
        this.write(CRSKeyword.VERTICALEXTENT);
        this.writeLeftDelimiter();
        this.writer.write(verticalExtent.getMinimumHeightText());
        this.writeSeparator();
        this.writer.write(verticalExtent.getMaximumHeightText());
        if (verticalExtent.hasUnit()) {
            this.writeSeparator();
            this.write(verticalExtent.getUnit());
        }
        this.writeRightDelimiter();
    }

    public void write(TemporalExtent temporalExtent) throws IOException {
        this.write(CRSKeyword.TIMEEXTENT);
        this.writeLeftDelimiter();
        if (temporalExtent.hasStartDateTime()) {
            this.writer.write(temporalExtent.getStartDateTime().toString());
        } else {
            this.writeQuotedText(temporalExtent.getStart());
        }
        this.writeSeparator();
        if (temporalExtent.hasEndDateTime()) {
            this.writer.write(temporalExtent.getEndDateTime().toString());
        } else {
            this.writeQuotedText(temporalExtent.getEnd());
        }
        this.writeRightDelimiter();
    }

    public void write(MapProjection mapProjection) throws IOException {
        this.write(CRSKeyword.CONVERSION);
        this.writeLeftDelimiter();
        this.writeQuotedText(mapProjection.getName());
        this.writeSeparator();
        OperationMethod method = mapProjection.getMethod();
        this.write(method);
        if (method.hasParameters()) {
            this.writeSeparator();
            this.writeParameters(method.getParameters());
        }
        if (mapProjection.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(mapProjection.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void write(OperationMethod method) throws IOException {
        this.write(CRSKeyword.METHOD);
        this.writeLeftDelimiter();
        this.writeQuotedText(method.getName());
        if (method.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(method.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void write(OperationParameter parameter) throws IOException {
        if (parameter.isFile()) {
            this.write(CRSKeyword.PARAMETERFILE);
        } else {
            this.write(CRSKeyword.PARAMETER);
        }
        this.writeLeftDelimiter();
        this.writeQuotedText(parameter.getName());
        this.writeSeparator();
        if (parameter.isFile()) {
            this.writeQuotedText(parameter.getFileName());
        } else {
            this.writer.write(parameter.getValueText());
            if (parameter.hasUnit()) {
                this.writeSeparator();
                this.write(parameter.getUnit());
            }
        }
        if (parameter.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(parameter.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void write(TemporalDatum temporalDatum) throws IOException {
        this.write(CRSKeyword.TDATUM);
        this.writeLeftDelimiter();
        this.writeQuotedText(temporalDatum.getName());
        if (temporalDatum.hasCalendar()) {
            this.writeSeparator();
            this.writeKeywordDelimitedQuotedText(CRSKeyword.CALENDAR, temporalDatum.getCalendar());
        }
        if (temporalDatum.hasOrigin() || temporalDatum.hasOriginDateTime()) {
            this.writeSeparator();
            this.write(CRSKeyword.TIMEORIGIN);
            this.writeLeftDelimiter();
            if (temporalDatum.hasOriginDateTime()) {
                this.writer.write(temporalDatum.getOriginDateTime().toString());
            } else {
                this.writeQuotedText(temporalDatum.getOrigin());
            }
            this.writeRightDelimiter();
        }
        if (temporalDatum.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(temporalDatum.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void write(DerivingConversion derivingConversion) throws IOException {
        this.write(CRSKeyword.DERIVINGCONVERSION);
        this.writeLeftDelimiter();
        this.writeQuotedText(derivingConversion.getName());
        this.writeSeparator();
        OperationMethod method = derivingConversion.getMethod();
        this.write(method);
        if (method.hasParameters()) {
            this.writeSeparator();
            this.writeParameters(method.getParameters());
        }
        if (derivingConversion.hasIdentifiers()) {
            this.writeSeparator();
            this.writeIdentifiers(derivingConversion.getIdentifiers());
        }
        this.writeRightDelimiter();
    }

    public void writeParameters(List<OperationParameter> parameters) throws IOException {
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                this.writeSeparator();
            }
            this.write(parameters.get(i));
        }
    }

    public void writeVersion(String version) throws IOException {
        this.write(CRSKeyword.VERSION);
        this.writeLeftDelimiter();
        this.writeQuotedText(version);
        this.writeRightDelimiter();
    }

    public void writeSource(CoordinateReferenceSystem crs) throws IOException {
        this.writeCoordinateReferenceSystem(CRSKeyword.SOURCECRS, crs);
    }

    public void writeTarget(CoordinateReferenceSystem crs) throws IOException {
        this.writeCoordinateReferenceSystem(CRSKeyword.TARGETCRS, crs);
    }

    public void writeInterpolation(CoordinateReferenceSystem crs) throws IOException {
        this.writeCoordinateReferenceSystem(CRSKeyword.INTERPOLATIONCRS, crs);
    }

    public void writeCoordinateReferenceSystem(CRSKeyword keyword, CoordinateReferenceSystem crs) throws IOException {
        this.write(keyword);
        this.writeLeftDelimiter();
        this.writeCRS(crs);
        this.writeRightDelimiter();
    }

    public void writeAccuracy(double accuracy) throws IOException {
        this.write(CRSKeyword.OPERATIONACCURACY);
        this.writeLeftDelimiter();
        this.write(accuracy);
        this.writeRightDelimiter();
    }

    public void writeAccuracy(String accuracy) throws IOException {
        this.write(CRSKeyword.OPERATIONACCURACY);
        this.writeLeftDelimiter();
        this.writer.write(accuracy);
        this.writeRightDelimiter();
    }

    public void write(AbridgedCoordinateTransformation transformation) throws IOException {
        this.write(CRSKeyword.ABRIDGEDTRANSFORMATION);
        this.writeLeftDelimiter();
        this.writeQuotedText(transformation.getName());
        if (transformation.hasVersion()) {
            this.writeSeparator();
            this.writeVersion(transformation.getVersion());
        }
        this.writeSeparator();
        OperationMethod method = transformation.getMethod();
        this.write(method);
        if (method.hasParameters()) {
            this.writeSeparator();
            this.writeParameters(method.getParameters());
        }
        this.writeScopeExtentIdentifierRemark(transformation);
        this.writeRightDelimiter();
    }
}

