/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import mil.nga.crs.CRSType;
import mil.nga.crs.SimpleCoordinateReferenceSystem;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.Dynamic;
import mil.nga.crs.geo.GeoDatum;
import mil.nga.crs.geo.GeoDatumEnsemble;
import mil.nga.crs.geo.GeoReferenceFrame;

public class GeoCoordinateReferenceSystem
extends SimpleCoordinateReferenceSystem {
    private GeoReferenceFrame referenceFrame = null;
    private GeoDatumEnsemble datumEnsemble = null;
    private Dynamic dynamic = null;

    public GeoCoordinateReferenceSystem() {
    }

    public GeoCoordinateReferenceSystem(CRSType type) {
        super(type);
    }

    public GeoCoordinateReferenceSystem(String name, CRSType type, GeoReferenceFrame referenceFrame, CoordinateSystem coordinateSystem) {
        super(name, type, coordinateSystem);
        this.setReferenceFrame(referenceFrame);
    }

    public GeoCoordinateReferenceSystem(String name, CRSType type, GeoDatumEnsemble datumEnsemble, CoordinateSystem coordinateSystem) {
        super(name, type, coordinateSystem);
        this.setDatumEnsemble(datumEnsemble);
    }

    public GeoCoordinateReferenceSystem(String name, CRSType type, Dynamic dynamic, GeoReferenceFrame referenceFrame, CoordinateSystem coordinateSystem) {
        super(name, type, coordinateSystem);
        this.setDynamic(dynamic);
        this.setReferenceFrame(referenceFrame);
    }

    public GeoReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean hasReferenceFrame() {
        return this.getReferenceFrame() != null;
    }

    public void setReferenceFrame(GeoReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public GeoDatumEnsemble getDatumEnsemble() {
        return this.datumEnsemble;
    }

    public boolean hasDatumEnsemble() {
        return this.getDatumEnsemble() != null;
    }

    public void setDatumEnsemble(GeoDatumEnsemble datumEnsemble) {
        this.datumEnsemble = datumEnsemble;
    }

    public Dynamic getDynamic() {
        return this.dynamic;
    }

    public boolean hasDynamic() {
        return this.getDynamic() != null;
    }

    public void setDynamic(Dynamic dynamic) {
        this.dynamic = dynamic;
    }

    public GeoDatum getGeoDatum() {
        GeoDatum datum = null;
        if (this.hasReferenceFrame()) {
            datum = this.getReferenceFrame();
        } else if (this.hasDatumEnsemble()) {
            datum = this.getDatumEnsemble();
        }
        return datum;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dynamic == null ? 0 : this.dynamic.hashCode());
        result = 31 * result + (this.datumEnsemble == null ? 0 : this.datumEnsemble.hashCode());
        result = 31 * result + (this.referenceFrame == null ? 0 : this.referenceFrame.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoCoordinateReferenceSystem other = (GeoCoordinateReferenceSystem)obj;
        if (this.dynamic == null ? other.dynamic != null : !this.dynamic.equals(other.dynamic)) {
            return false;
        }
        if (this.datumEnsemble == null ? other.datumEnsemble != null : !this.datumEnsemble.equals(other.datumEnsemble)) {
            return false;
        }
        return !(this.referenceFrame == null ? other.referenceFrame != null : !this.referenceFrame.equals(other.referenceFrame));
    }
}

