/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.xkcoding.http.util.UrlUtil;
import java.util.List;
import me.zhyd.oauth.cache.AuthDefaultStateCache;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.log.Log;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthChecker;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;
import me.zhyd.oauth.utils.UuidUtils;

public abstract class AuthDefaultRequest
implements AuthRequest {
    protected AuthConfig config;
    protected AuthSource source;
    protected AuthStateCache authStateCache;

    public AuthDefaultRequest(AuthConfig config, AuthSource source) {
        this(config, source, AuthDefaultStateCache.INSTANCE);
    }

    public AuthDefaultRequest(AuthConfig config, AuthSource source, AuthStateCache authStateCache) {
        this.config = config;
        this.source = source;
        this.authStateCache = authStateCache;
        if (!AuthChecker.isSupportedAuth(config, source)) {
            throw new AuthException(AuthResponseStatus.PARAMETER_INCOMPLETE, source);
        }
        AuthChecker.checkConfig(config, source);
    }

    protected abstract AuthToken getAccessToken(AuthCallback var1);

    protected abstract AuthUser getUserInfo(AuthToken var1);

    @Override
    public AuthResponse login(AuthCallback authCallback) {
        try {
            this.checkCode(authCallback);
            if (!this.config.isIgnoreCheckState()) {
                AuthChecker.checkState(authCallback.getState(), this.source, this.authStateCache);
            }
            AuthToken authToken = this.getAccessToken(authCallback);
            AuthUser user = this.getUserInfo(authToken);
            return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            Log.error("Failed to login with oauth authorization.", e);
            return this.responseError(e);
        }
    }

    protected void checkCode(AuthCallback authCallback) {
        AuthChecker.checkCode(this.source, authCallback);
    }

    AuthResponse responseError(Exception e) {
        int errorCode = AuthResponseStatus.FAILURE.getCode();
        String errorMsg = e.getMessage();
        if (e instanceof AuthException) {
            AuthException authException = (AuthException)e;
            errorCode = authException.getErrorCode();
            if (StringUtils.isNotEmpty(authException.getErrorMsg())) {
                errorMsg = authException.getErrorMsg();
            }
        }
        return AuthResponse.builder().code(errorCode).msg(errorMsg).build();
    }

    @Override
    @Deprecated
    public String authorize() {
        return this.authorize(null);
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    protected String refreshTokenUrl(String refreshToken) {
        return UrlBuilder.fromBaseUrl(this.source.refresh()).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    protected String revokeUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.revoke()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    protected String getRealState(String state) {
        if (StringUtils.isEmpty(state)) {
            state = UuidUtils.getUUID();
        }
        this.authStateCache.cache(state, state);
        return state;
    }

    protected String doPostAuthorizationCode(String code) {
        return new HttpUtils(this.config.getHttpConfig()).post(this.accessTokenUrl(code)).getBody();
    }

    protected String doGetAuthorizationCode(String code) {
        return new HttpUtils(this.config.getHttpConfig()).get(this.accessTokenUrl(code)).getBody();
    }

    @Deprecated
    protected String doPostUserInfo(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken)).getBody();
    }

    protected String doGetUserInfo(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).get(this.userInfoUrl(authToken)).getBody();
    }

    @Deprecated
    protected String doPostRevoke(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).post(this.revokeUrl(authToken)).getBody();
    }

    protected String doGetRevoke(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).get(this.revokeUrl(authToken)).getBody();
    }

    protected String getScopes(String separator, boolean encode, List<String> defaultScopes) {
        List<String> scopes = this.config.getScopes();
        if (null == scopes || scopes.isEmpty()) {
            if (null == defaultScopes || defaultScopes.isEmpty()) {
                return "";
            }
            scopes = defaultScopes;
        }
        if (null == separator) {
            separator = " ";
        }
        String scopeStr = String.join((CharSequence)separator, scopes);
        return encode ? UrlUtil.urlEncode((String)scopeStr) : scopeStr;
    }
}

