/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialratingbar;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import me.zhanghai.android.materialratingbar.BaseDrawable;

class TileDrawable
extends BaseDrawable {
    private Drawable mDrawable;
    private int mTileCount = -1;

    public TileDrawable(Drawable drawable2) {
        this.mDrawable = drawable2;
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public int getTileCount() {
        return this.mTileCount;
    }

    public void setTileCount(int tileCount) {
        this.mTileCount = tileCount;
        this.invalidateSelf();
    }

    @NonNull
    public Drawable mutate() {
        this.mDrawable = this.mDrawable.mutate();
        return this;
    }

    @Override
    protected void onDraw(Canvas canvas, int width, int height) {
        this.mDrawable.setAlpha(this.mAlpha);
        ColorFilter colorFilter = this.getColorFilterForDrawing();
        if (colorFilter != null) {
            this.mDrawable.setColorFilter(colorFilter);
        }
        int tileHeight = this.mDrawable.getIntrinsicHeight();
        float scale = (float)height / (float)tileHeight;
        canvas.scale(scale, scale);
        float scaledWidth = (float)width / scale;
        if (this.mTileCount < 0) {
            int tileWidth = this.mDrawable.getIntrinsicWidth();
            int x = 0;
            while ((float)x < scaledWidth) {
                this.mDrawable.setBounds(x, 0, x + tileWidth, tileHeight);
                this.mDrawable.draw(canvas);
                x += tileWidth;
            }
        } else {
            float tileWidth = scaledWidth / (float)this.mTileCount;
            for (int i = 0; i < this.mTileCount; ++i) {
                int drawableWidth = this.mDrawable.getIntrinsicWidth();
                float tileCenter = tileWidth * ((float)i + 0.5f);
                float drawableWidthHalf = (float)drawableWidth / 2.0f;
                this.mDrawable.setBounds(Math.round(tileCenter - drawableWidthHalf), 0, Math.round(tileCenter + drawableWidthHalf), tileHeight);
                this.mDrawable.draw(canvas);
            }
        }
    }
}

