/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialratingbar;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import me.zhanghai.android.materialratingbar.TintableDrawable;

class ClipDrawableCompat
extends ClipDrawable
implements TintableDrawable {
    private static final String TAG = ClipDrawableCompat.class.getSimpleName();
    private Drawable mDrawable;
    private DummyConstantState mConstantState = new DummyConstantState();

    public ClipDrawableCompat(Drawable drawable, int gravity, int orientation) {
        super(drawable, gravity, orientation);
        this.mDrawable = drawable;
    }

    @Nullable
    public Drawable getDrawable() {
        return this.mDrawable;
    }

    @Override
    public void setTint(int tintColor) {
        if (this.mDrawable instanceof TintableDrawable) {
            ((TintableDrawable)this.mDrawable).setTint(tintColor);
        } else {
            Log.w((String)TAG, (String)"Drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
            super.setTint(tintColor);
        }
    }

    @Override
    public void setTintList(ColorStateList tint) {
        if (this.mDrawable instanceof TintableDrawable) {
            ((TintableDrawable)this.mDrawable).setTintList(tint);
        } else {
            Log.w((String)TAG, (String)"Drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
            super.setTintList(tint);
        }
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        if (this.mDrawable instanceof TintableDrawable) {
            ((TintableDrawable)this.mDrawable).setTintMode(tintMode);
        } else {
            Log.w((String)TAG, (String)"Drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
            super.setTintMode(tintMode);
        }
    }

    public Drawable.ConstantState getConstantState() {
        return this.mConstantState;
    }

    private class DummyConstantState
    extends Drawable.ConstantState {
        private DummyConstantState() {
        }

        public int getChangingConfigurations() {
            return 0;
        }

        @NonNull
        public Drawable newDrawable() {
            return ClipDrawableCompat.this;
        }
    }
}

