/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check.web.ext;

import android.webkit.MimeTypeMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Files {
    public static MultipartBody filesToMultipartBody(List<File> files) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        for (File file : files) {
            String mime = Files.getMimeType(file);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)mime), (File)file);
            builder.addFormDataPart("file", file.getName(), requestBody);
        }
        builder.setType(MultipartBody.FORM);
        MultipartBody multipartBody = builder.build();
        return multipartBody;
    }

    public static List<MultipartBody.Part> filesToMultipartBodyParts(List<File> files) {
        ArrayList<MultipartBody.Part> parts = new ArrayList<MultipartBody.Part>(files.size());
        for (File file : files) {
            parts.add(Files.fileToMultipartBodyPart(file));
        }
        return parts;
    }

    public static MultipartBody.Part fileToMultipartBodyPart(File file) {
        String mime = Files.getMimeType(file);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)mime), (File)file);
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestBody);
        return part;
    }

    private static String getSuffix(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        String fileName = file.getName();
        if ("".equals(fileName) || fileName.endsWith(".")) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index + 1).toLowerCase(Locale.US);
        }
        return null;
    }

    public static String getMimeType(File file) {
        String suffix = Files.getSuffix(file);
        if (suffix == null) {
            return "file/*";
        }
        String type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(suffix);
        if (type != null || !type.isEmpty()) {
            return type;
        }
        return "file/*";
    }
}

