/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check.web;

import com.codvision.base.wrapper.WrapperEntity;
import com.codvision.check.CheckConst;
import com.codvision.check.api.CommonApi;
import com.codvision.check.web.DataType;
import com.codvision.check.web.ext.Files;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import me.xujichang.util.retrofit.RetrofitManager;
import me.xujichang.util.simple.SilentResourceObserver;
import me.xujichang.util.tool.StringTool;

public class SingleFileUpload {
    private String baseUrl;
    private File uploadFile;
    private CallBackFunction function;

    public SingleFileUpload withFile(String data) {
        this.uploadFile = new File(data);
        return this;
    }

    public SingleFileUpload withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public SingleFileUpload withFunction(CallBackFunction function) {
        this.function = function;
        return this;
    }

    public void upload(CallBackFunction function) {
        this.function = function;
        this.upload();
    }

    public void upload() {
        if (!this.uploadFile.exists()) {
            this.function.onCallBack(DataType.createRespData(501, "\u6587\u4ef6\u4e0d\u5b58\u5728", this.uploadFile.getName()));
            return;
        }
        this.uploadFile(this.uploadFile);
    }

    private void uploadFile(File file) {
        SilentResourceObserver<WrapperEntity<String>> observer = new SilentResourceObserver<WrapperEntity<String>>(null){

            public void onNext(WrapperEntity<String> entity) {
                if (entity.getCode() == 200) {
                    SingleFileUpload.this.function.onCallBack(DataType.createRespData(200, "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f", entity.getData()));
                } else {
                    SingleFileUpload.this.function.onCallBack(DataType.createRespData(entity.getCode(), 600, entity.getMessage(), SingleFileUpload.this.uploadFile.getName()));
                }
            }

            public void onError(Throwable e) {
                SingleFileUpload.this.function.onCallBack(DataType.createRespData(700, StringTool.getErrorMsg((Throwable)e), SingleFileUpload.this.uploadFile.getName()));
            }
        };
        ((CommonApi)RetrofitManager.getOurInstance().createReq(CommonApi.class)).uploadSingleFile(CheckConst.PHOTO_UPLOAD_PATH, Files.fileToMultipartBodyPart(file)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)observer);
    }

    public SingleFileUpload withFile(File file) {
        this.uploadFile = file;
        return this;
    }
}

