/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check.web;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.ActivityOptionsCompat;
import com.codvision.base.utils.file.Files;
import com.codvision.check.R;
import com.codvision.check.web.DataType;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.king.zxing.CaptureActivity;
import com.king.zxing.util.CodeUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.ResourceObserver;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import me.xujichang.util.tool.StringTool;

public class QRForWeb {
    private static final int TYPE_CREATE = 2;
    private static final int TYPE_IDENTIFY = 1;
    private static final String KEY_TITLE = "key_title";
    private static QRForWeb instance;
    private String data;
    private WeakReference<Activity> weakReference;
    private CallBackFunction function;
    private String resultPath;
    private String resultStr;
    private File storeDir;

    public static QRForWeb withContext(Activity context) {
        QRForWeb.instance().weakReference = new WeakReference<Activity>(context);
        return instance;
    }

    private static QRForWeb instance() {
        instance = Holder.instance;
        return instance;
    }

    public QRForWeb withFunction(CallBackFunction function) {
        QRForWeb.instance().function = function;
        return instance;
    }

    public QRForWeb withData(String data) {
        QRForWeb.instance().data = data;
        return instance;
    }

    public void execute() {
        Context context = (Context)this.weakReference.get();
        if (null == context) {
            return;
        }
        this.storeDir = context.getFilesDir();
        if (Strings.isNullOrEmpty((String)this.data)) {
            throw new RuntimeException("QrForWeb needs QrData parse from Web ,But There is Null\uff01");
        }
        QrData qrData = (QrData)new Gson().fromJson(this.data, QrData.class);
        if (qrData.type == 2) {
            this.doCreate(qrData.str);
        } else {
            this.doIdentify();
        }
    }

    private void doIdentify() {
        Activity context = (Activity)this.weakReference.get();
        if (null == context) {
            return;
        }
        ActivityOptionsCompat optionsCompat = ActivityOptionsCompat.makeCustomAnimation((Context)context, (int)R.anim.in, (int)R.anim.out);
        Intent intent = new Intent((Context)context, CaptureActivity.class);
        intent.putExtra(KEY_TITLE, "\u3002\u3002\u3002");
        ActivityCompat.startActivityForResult((Activity)context, (Intent)intent, (int)10005, (Bundle)optionsCompat.toBundle());
    }

    private void doCreate(final String str) {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(ObservableEmitter<String> e) throws Exception {
                Context context = (Context)QRForWeb.this.weakReference.get();
                if (null == context) {
                    return;
                }
                Bitmap bitmap = CodeUtils.createQRCode((String)str, (int)600);
                File file = Files.createImageFile((Context)context, (String)"qrImage");
                if (null == file || !file.exists()) {
                    e.onError((Throwable)new RuntimeException("\u4e8c\u7ef4\u7801\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
                } else {
                    FileOutputStream outputStream = new FileOutputStream(file);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                    e.onNext((Object)file.getAbsolutePath());
                }
                e.onComplete();
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new ResourceObserver<String>(){

            public void onNext(String s) {
                QRForWeb.this.resultPath = s;
            }

            public void onError(Throwable e) {
                QRForWeb.onResultError(StringTool.getErrorMsg((Throwable)e));
            }

            public void onComplete() {
                if (Strings.isNullOrEmpty((String)QRForWeb.this.resultPath)) {
                    QRForWeb.onResultError("\u4e8c\u7ef4\u7801\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                } else {
                    QRForWeb.onResult(QRForWeb.this.resultPath);
                }
            }
        });
    }

    public static boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10005) {
            if (resultCode == -1) {
                if (data != null) {
                    String result = data.getStringExtra("SCAN_RESULT");
                    QRForWeb.onResult(result);
                } else {
                    QRForWeb.onResultError("\u89e3\u6790\u6570\u636e\u4e3a\u7a7a\uff01");
                }
            } else {
                QRForWeb.onResultError("\u89e3\u6790\u5931\u8d25\uff01");
            }
            return true;
        }
        return false;
    }

    private static void onResultError(String msg) {
        QRForWeb.instance.function.onCallBack(DataType.createErrorRespData(500, msg));
    }

    private static void onResult(String result) {
        QRForWeb.instance.function.onCallBack(DataType.createRespData(200, "success", result));
    }

    private QRForWeb() {
    }

    public static final class QrData {
        private int type;
        private String str;

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }
    }

    private static final class Holder {
        static QRForWeb instance = new QRForWeb();

        private Holder() {
        }
    }
}

