/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check.web;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.View;
import com.afollestad.materialdialogs.MaterialDialog;
import com.codvision.base.utils.file.Files;
import com.codvision.check.web.DataType;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.google.gson.Gson;
import id.zelory.compressor.Compressor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PictureForWeb {
    private static final int ALBUM_REQUEST_CODE = 31;
    private static final int CAMERA_REQUEST_CODE = 32;
    private static PictureForWeb instance;
    private CallBackFunction sFunction;
    private int option;
    private Context mContext;
    private File storeDir;
    private static boolean justCamera;
    private File cachedPhotoFile;

    public static PictureForWeb getInstance() {
        if (null == instance) {
            instance = ClassHolder.instance;
        }
        justCamera = false;
        return instance;
    }

    private PictureForWeb() {
    }

    public PictureForWeb withOptions(String data) {
        DataType.ReqData optionBean = (DataType.ReqData)new Gson().fromJson(data, DataType.ReqData.class);
        if (null != optionBean) {
            this.option = optionBean.getOption();
        }
        return instance;
    }

    public PictureForWeb withContext(Context context) {
        this.mContext = context;
        return instance;
    }

    public void execute() {
        if (null == this.mContext) {
            throw new RuntimeException("the Context is null");
        }
        this.storeDir = this.mContext.getFilesDir();
        final Activity activity = (Activity)this.mContext;
        if (justCamera) {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            this.cachedPhotoFile = Files.createImageFile((Context)activity, (String)"tmpImg");
            intent.putExtra("output", (Parcelable)Files.getUriFromFile((Context)activity, (File)this.cachedPhotoFile));
            activity.startActivityForResult(intent, 32);
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add("\u76f8\u673a");
        items.add("\u76f8\u518c");
        new MaterialDialog.Builder(this.mContext).title((CharSequence)"\u56fe\u7247\u6765\u6e90").content((CharSequence)"\u8bf7\u9009\u62e9\u62cd\u7167\u6216\u8005\u4ece\u76f8\u518c\u4e2d\u83b7\u53d6").items(items).autoDismiss(true).itemsCallback(new MaterialDialog.ListCallback(){

            public void onSelection(MaterialDialog dialog, View itemView, int position, CharSequence text) {
                if (position == 1) {
                    Intent intent = new Intent("android.intent.action.PICK", null);
                    intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
                    intent.setAction("android.intent.action.GET_CONTENT");
                    activity.startActivityForResult(intent, 31);
                } else {
                    Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                    PictureForWeb.this.cachedPhotoFile = Files.createImageFile((Context)activity, (String)"tmpImg");
                    intent.putExtra("output", (Parcelable)Files.getUriFromFile((Context)activity, (File)PictureForWeb.this.cachedPhotoFile));
                    activity.startActivityForResult(intent, 32);
                }
            }
        }).show();
    }

    public PictureForWeb withFunction(CallBackFunction function) {
        this.sFunction = function;
        return instance;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 31 || requestCode == 32) {
            if (resultCode != -1) {
                return true;
            }
            File srcFile = null;
            String path = null;
            if (requestCode % 2 == 0) {
                srcFile = this.cachedPhotoFile;
            } else {
                Uri uri = data.getData();
                if (null != uri) {
                    path = Files.getRealFilePath((Context)this.mContext, (Uri)uri);
                    srcFile = new File(path);
                }
            }
            if (null == srcFile) {
                this.sFunction.onCallBack(DataType.createErrorRespData(500, "\u83b7\u53d6\u56fe\u7247\u8def\u5f84,\u5931\u8d25"));
            } else if (Files.getFileSizeFormatM((File)srcFile) > 1.0) {
                File destFile = null;
                try {
                    destFile = new Compressor(this.mContext).setDestinationDirectoryPath(this.storeDir.getAbsolutePath()).compressToFile(srcFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (null == destFile) {
                    this.sFunction.onCallBack(DataType.createErrorRespData(500, "\u83b7\u53d6\u76f8\u518c\u8def\u5f84,\u5931\u8d25"));
                } else {
                    path = destFile.getAbsolutePath();
                    this.sFunction.onCallBack(DataType.createRespData(200, "\u6210\u529f\u83b7\u53d6\u76f8\u518c\u8def\u5f84", path));
                }
            } else {
                path = srcFile.getAbsolutePath();
                this.sFunction.onCallBack(DataType.createRespData(200, "\u6210\u529f\u83b7\u53d6\u76f8\u518c\u8def\u5f84", path));
            }
            return true;
        }
        return false;
    }

    private File createPictureFile() {
        return new File(this.storeDir, "picture_" + System.currentTimeMillis() + ".jpg");
    }

    public PictureForWeb justCamera(boolean just) {
        justCamera = just;
        return instance;
    }

    static {
        justCamera = false;
    }

    private static class ClassHolder {
        public static PictureForWeb instance = new PictureForWeb();

        private ClassHolder() {
        }
    }
}

