/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check.web;

import com.codvision.check.web.DataType;
import com.codvision.check.web.SingleFileUpload;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FilesUploadForWeb {
    public static final String DATA_FILES = "files";
    private CallBackFunction nativeCallback;
    private Result result;

    public void uploadFilesNew(String data, CallBackFunction function) {
        this.uploadFilesNew(data, function, true);
    }

    public void uploadFilesNew(String data, CallBackFunction function, boolean isNew) {
        ArrayList<File> files = FilesUploadForWeb.parseFiles(data);
        if (files.size() == 0) {
            function.onCallBack(DataType.createErrorRespData(700, "\u672a\u89e3\u6790\u51fa\u9700\u8981\u4e0a\u4f20\u7684\u6587\u4ef6"));
            return;
        }
        if (files.size() == 1 && isNew) {
            new SingleFileUpload().withFile(files.get(0)).upload(function);
        } else {
            final CallBackFunction filesFunction = function;
            this.result = new Result(files.size());
            this.nativeCallback = new CallBackFunction(){

                public void onCallBack(String data) {
                    DataType.RespData<String> respData = DataType.parseRespData(data, String.class);
                    if (respData.getCode() == 200) {
                        FilesUploadForWeb.this.result.increaseSuccessNum();
                        FilesUploadForWeb.this.result.getSuccessUrl().add(respData.getData());
                    } else {
                        FilesUploadForWeb.this.result.increaseFailNum();
                        FilesUploadForWeb.this.result.getFailData().add(respData.getData());
                    }
                    if (FilesUploadForWeb.this.result.isOK()) {
                        String msg = "\u5168\u90e8\u6587\u4ef6\u4e0a\u4f20\u6210\u529f";
                        int status = 200;
                        if (FilesUploadForWeb.this.result.hasFailData()) {
                            status = 204;
                            msg = String.format(Locale.CHINA, "%d\u4e2a\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c%d\u4e2a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", FilesUploadForWeb.this.result.getSuccessNum(), FilesUploadForWeb.this.result.getFailNum());
                        }
                        filesFunction.onCallBack(DataType.createRespData(status, msg, FilesUploadForWeb.this.result));
                    }
                }
            };
            for (File file : files) {
                new SingleFileUpload().withFile(file).upload(this.nativeCallback);
            }
        }
    }

    private static ArrayList<File> parseFiles(String data) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            JSONObject object = new JSONObject(data);
            JSONArray array = object.getJSONArray(DATA_FILES);
            for (int i = 0; i < array.length(); ++i) {
                String url;
                File file;
                if ("null" == array.get(i) || !(file = new File(url = (String)array.get(i))).exists()) continue;
                files.add(file);
            }
            array.length();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return files;
    }

    public void uploadFiles(String data, CallBackFunction function) {
        this.uploadFilesNew(data, function, false);
    }

    public static class Result {
        private int count;
        private int successNum;
        private int failNum;
        private ArrayList<String> successUrl = new ArrayList();
        private ArrayList<String> failData = new ArrayList();

        public Result(int count) {
            this.count = count;
        }

        public ArrayList<String> getSuccessUrl() {
            return this.successUrl;
        }

        public void setSuccessUrl(ArrayList<String> successUrl) {
            this.successUrl = successUrl;
        }

        public ArrayList<String> getFailData() {
            return this.failData;
        }

        public void setFailData(ArrayList<String> failData) {
            this.failData = failData;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getSuccessNum() {
            return this.successNum;
        }

        public void setSuccessNum(int successNum) {
            this.successNum = successNum;
        }

        public int getFailNum() {
            return this.failNum;
        }

        public void setFailNum(int failNum) {
            this.failNum = failNum;
        }

        public void increaseFailNum() {
            ++this.failNum;
        }

        public void increaseSuccessNum() {
            ++this.successNum;
        }

        public boolean isOK() {
            return this.failNum + this.successNum == this.count;
        }

        public boolean hasFailData() {
            return this.failNum != 0;
        }
    }
}

