/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check.web;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsResult;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.TextView;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.bumptech.glide.Glide;
import com.codvision.check.R;
import com.codvision.check.web.DataType;
import com.codvision.check.web.FilesUploadForWeb;
import com.codvision.check.web.InformationHandler;
import com.codvision.check.web.LocationForWeb;
import com.codvision.check.web.NavForWeb;
import com.codvision.check.web.PictureForWeb;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.google.common.base.Strings;
import me.xujichang.hybirdbase.R;
import me.xujichang.hybirdbase.module.web.HyBirdWebViewActivity;
import me.xujichang.hybirdbase.module.web.interfaces.IWebJsCallBack;
import me.xujichang.util.tool.LogTool;
import org.json.JSONObject;

public class DefaultWebViewActivity
extends HyBirdWebViewActivity {
    private boolean isRightIconActionCallback = false;
    private MaterialDialog alertDialog = null;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getActionbarTitle().setVisibility(4);
        String url = this.getIntent().getStringExtra("web_url");
        this.loadUrl(url);
    }

    protected void initWebSetting(WebSettings settings) {
        settings.supportMultipleWindows();
        settings.setDomStorageEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setLoadWithOverviewMode(true);
        settings.setBuiltInZoomControls(true);
        settings.setDisplayZoomControls(false);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setDatabaseEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setSupportZoom(true);
    }

    protected void initExtHandler(IWebJsCallBack callBack) {
        new InformationHandler(this.getWebView()).addJsCallBack((IWebJsCallBack)this);
    }

    protected void initActionBar() {
        this.showBackArrow();
        this.setRightImg(R.drawable.ic_refresh);
    }

    protected void setActionBarTitle(String title) {
        TextView actionbarTitle = this.getActionbarTitle();
        if (TextUtils.isEmpty((CharSequence)title)) {
            actionbarTitle.setVisibility(4);
        } else {
            actionbarTitle.setVisibility(0);
            actionbarTitle.setText((CharSequence)title);
            actionbarTitle.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onError(WebView view, int errorCode, String description, String failingUrl) {
        LogTool.d((String)("onError:" + errorCode + "  " + description + "   " + failingUrl));
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.isRightIconActionCallback = false;
        this.setRightImg(R.drawable.ic_refresh);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        LogTool.d((String)("onPageFinished:" + url));
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        if (this.getLifecycle().getCurrentState() != Lifecycle.State.RESUMED) {
            LogTool.d((String)("onJsAlert:" + message + "  " + url));
            return true;
        }
        return super.onJsAlert(view, url, message, result);
    }

    public void onPageReceiveTitle(WebView view, String title) {
        super.onPageReceiveTitle(view, title);
    }

    public void onJsCallBack(String type, String data, CallBackFunction function) {
        LogTool.d((String)("---------type:" + type + "    data:" + data));
        switch (type) {
            case "location": {
                LocationForWeb.getInstance(function).withContext((Context)this).withOptions(data);
                break;
            }
            case "camera": {
                PictureForWeb.getInstance().justCamera(true).withFunction(function).withOptions(data).withContext((Context)this).execute();
                break;
            }
            case "picture": {
                PictureForWeb.getInstance().withFunction(function).withOptions(data).withContext((Context)this).execute();
                break;
            }
            case "userid": {
                String unionid = "";
                String response = null;
                response = TextUtils.isEmpty((CharSequence)unionid) ? DataType.createErrorRespData(205, "\u672a\u83b7\u53d6\u5230UserID") : DataType.createRespData(200, "\u6210\u529f\u83b7\u53d6UserID", unionid);
                function.onCallBack(response);
                break;
            }
            case "upload": {
                new FilesUploadForWeb().uploadFiles(data, function);
                break;
            }
            case "upload_new": {
                new FilesUploadForWeb().uploadFilesNew(data, function);
                break;
            }
            case "setRightIcon": {
                if (null == data) break;
                try {
                    JSONObject object = new JSONObject(data);
                    String url = object.getString("url");
                    if (Strings.isNullOrEmpty((String)url)) break;
                    this.getActionbarRightImg().setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    Glide.with((FragmentActivity)this).load(url).into(this.getActionbarRightImg());
                    this.isRightIconActionCallback = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case "openLink": {
                if (null == data) break;
                if (data.startsWith("http")) {
                    Uri uri = Uri.parse((String)data);
                    Intent intent = new Intent();
                    intent.setClass((Context)this, DefaultWebViewActivity.class);
                    intent.putExtra("web_url", uri.toString());
                    this.startActivity(intent);
                    break;
                }
                Uri uri = Uri.parse((String)data);
                Intent intent = new Intent();
                intent.setData(uri);
                this.startActivity(intent);
                break;
            }
            case "nav": {
                if (null == data) break;
                double lng = 0.0;
                double lat = 0.0;
                String name = "\u76ee\u7684\u5730";
                try {
                    JSONObject object = new JSONObject(data);
                    name = object.getString("name");
                    if (Strings.isNullOrEmpty((String)name)) {
                        name = "\u76ee\u7684\u5730";
                    }
                    lng = object.getDouble("lng");
                    lat = object.getDouble("lat");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (0.0 == lng || 0.0 == lat) break;
                NavForWeb.getInstance().withFunction(function).withDestination(name, lng, lat).withContext((Context)this).execute();
                break;
            }
            default: {
                super.onJsCallBack(type, data, function);
            }
        }
    }

    protected void onLeftAreaClick() {
        this.doExit();
    }

    protected void onRightAreaClick() {
        if (this.isRightIconActionCallback) {
            this.getWebView().callHandler("onRightIconClick", null, null);
        } else {
            this.getWebView().reload();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean catched = false;
        catched = PictureForWeb.getInstance().onActivityResult(requestCode, resultCode, data);
        if (!catched) {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void onDestroy() {
        BridgeWebView webView = this.getWebView();
        if (webView != null) {
            ViewGroup viewGroup = (ViewGroup)webView.getParent();
            if (viewGroup != null) {
                viewGroup.removeView((View)webView);
            }
            webView.clearHistory();
            webView.clearCache(true);
            webView.destroy();
        }
        super.onDestroy();
        LogTool.d((String)"onDestroy()");
    }

    protected long getActivityExitDuration() {
        return 1000L;
    }

    protected void doExit() {
        this.showWarningDialog("\u9000\u51fa\u6b64\u9875\u9762\u7684\u6570\u636e\u5c06\u4e0d\u4f1a\u4fdd\u7559\uff0c\u786e\u8ba4\u9000\u51fa\uff1f", new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                if (which == DialogAction.POSITIVE) {
                    DefaultWebViewActivity.this.finish();
                }
                dialog.dismiss();
            }
        });
    }

    protected void doHistory() {
        BridgeWebView webView = this.getWebView();
        if (webView.canGoBack()) {
            webView.goBack();
        } else {
            this.doExit();
        }
    }
}

