/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check.services;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.codvision.base.utils.third.thirdparty.DeviceUtils;
import com.codvision.base.utils.third.thirdparty.LocationUtils;
import com.codvision.base.wrapper.WrapperEntity;
import com.codvision.check.CheckConst;
import com.codvision.check.CheckInit;
import com.codvision.check.api.CommonApi;
import com.codvision.check.bean.LocationUpload;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.util.Date;
import me.xujichang.util.retrofit.RetrofitManager;
import me.xujichang.util.simple.SilentResourceObserver;
import me.xujichang.util.tool.LogTool;

public class UploadLocationService
extends Service {
    private static final String CHANNEL_ID = "101";
    private static final CharSequence CHANNEL_NAME = "we";
    private int wzsbqssj = 0;
    private int wzsbjzsj = 240000;
    private int wzsbjg = 30000;
    private int yxdwjl = 200;
    private boolean uploadEnabled = true;
    private Location lastUploadLocation;
    private long lastUploadTime = 0L;

    public int onStartCommand(Intent intent, int flags, int startId) {
        LogTool.d((String)"====== onStartCommand ======");
        NotificationChannel channel = null;
        if (Build.VERSION.SDK_INT >= 26) {
            channel = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, 4);
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            manager.createNotificationChannel(channel);
            Notification notification = new Notification.Builder(this.getApplicationContext(), CHANNEL_ID).build();
            this.startForeground(1, notification);
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void onCreate() {
        super.onCreate();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (UploadLocationService.this.uploadEnabled) {
                    try {
                        Thread.sleep(UploadLocationService.this.wzsbjg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Date date = new Date(System.currentTimeMillis());
                    int n = date.getHours() * 10000 + date.getMinutes() * 100 + date.getSeconds();
                    if (n < UploadLocationService.this.wzsbqssj || n > UploadLocationService.this.wzsbjzsj) {
                        LogTool.d((String)"not in work time");
                        continue;
                    }
                    Location location = CheckInit.location;
                    if (null != location) {
                        if (null != UploadLocationService.this.lastUploadLocation) {
                            if (LocationUtils.isBetterLocation((Location)location, (Location)UploadLocationService.this.lastUploadLocation, (int)UploadLocationService.this.yxdwjl)) {
                                LogTool.d((String)"Got Better Location");
                                float distance = location.distanceTo(UploadLocationService.this.lastUploadLocation);
                                if (10.0f > distance) {
                                    LogTool.d((String)("\u8ddd\u79bb\u4e0d\u523010\u7c73\uff1a" + distance));
                                    if (System.currentTimeMillis() - UploadLocationService.this.lastUploadTime < 300000L) continue;
                                }
                                UploadLocationService.this.upload(location);
                                continue;
                            }
                            if (System.currentTimeMillis() - UploadLocationService.this.lastUploadTime < 300000L) continue;
                            UploadLocationService.this.upload(UploadLocationService.this.lastUploadLocation);
                            continue;
                        }
                        UploadLocationService.this.upload(location);
                        continue;
                    }
                    LogTool.d((String)"currentBestLocation is null");
                }
            }
        }).start();
    }

    public void onDestroy() {
        this.uploadEnabled = false;
        if (Build.VERSION.SDK_INT >= 26) {
            this.stopForeground(true);
        }
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void upload(final Location location) {
        LogTool.d((String)("\u4e0a\u4f20\u4f4d\u7f6e:" + location));
        SilentResourceObserver<WrapperEntity> observer = new SilentResourceObserver<WrapperEntity>(null){

            public void onNext(WrapperEntity wrapper) {
                if (wrapper.getCode() == 200) {
                    UploadLocationService.this.lastUploadLocation = location;
                    UploadLocationService.this.lastUploadTime = System.currentTimeMillis();
                }
            }
        };
        LocationUpload locationUpload = new LocationUpload();
        locationUpload.setKey(DeviceUtils.getAndroidID());
        locationUpload.setLat(location.getLatitude());
        locationUpload.setLng(location.getLongitude());
        locationUpload.setType("8000010");
        ((CommonApi)RetrofitManager.getOurInstance().createReq(CommonApi.class)).uploadGps(CheckConst.LOCATION_UPLOAD_PATH, locationUpload).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)observer);
    }
}

