/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.check;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.codvision.check.handler.CheckHandler;
import com.codvision.check.web.DataType;
import com.codvision.check.web.DefaultWebViewActivity;
import com.codvision.check.web.QRForWeb;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.google.common.base.Strings;
import me.xujichang.hybirdbase.module.web.interfaces.IWebJsCallBack;

public class WebContainerActivity
extends DefaultWebViewActivity {
    private String token;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Intent intent = this.getIntent();
        this.token = intent.getStringExtra("token");
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtHandler(IWebJsCallBack callBack) {
        super.initExtHandler(callBack);
        new CheckHandler(this.getWebView(), (IWebJsCallBack)this);
    }

    @Override
    public void onJsCallBack(String type, String data, CallBackFunction function) {
        switch (type) {
            case "back": {
                this.doHistory();
                break;
            }
            case "exit": {
                this.doExit();
                break;
            }
            case "token": {
                if (Strings.isNullOrEmpty((String)this.token)) {
                    function.onCallBack(DataType.createRespData(500, "token \u4fe1\u606f\u4e3a\u7a7a", ""));
                    break;
                }
                function.onCallBack(DataType.createRespData(200, "\u4f4d\u7f6e\u4fe1\u606f\u83b7\u53d6\u6210\u529f", this.token));
                break;
            }
            case "qr": {
                QRForWeb.withContext((Activity)this).withFunction(function).withData(data).execute();
                break;
            }
            default: {
                super.onJsCallBack(type, data, function);
            }
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean catched = false;
        catched = QRForWeb.onActivityResult(requestCode, resultCode, data);
        if (!catched) {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }
}

