/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.codvision.base.utils.third.thirdparty.Utils;

public final class ToastUtils {
    private static Toast sToast;
    private static int gravity;
    private static int xOffset;
    private static int yOffset;
    @SuppressLint(value={"StaticFieldLeak"})
    private static View customView;
    private static Handler sHandler;

    private ToastUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        ToastUtils.gravity = gravity;
        ToastUtils.xOffset = xOffset;
        ToastUtils.yOffset = yOffset;
    }

    public static void setView(@LayoutRes int layoutId) {
        LayoutInflater inflate = (LayoutInflater)Utils.getContext().getSystemService("layout_inflater");
        customView = inflate.inflate(layoutId, null);
    }

    public static void setView(View view) {
        customView = view;
    }

    public static View getView() {
        if (customView != null) {
            return customView;
        }
        if (sToast != null) {
            return sToast.getView();
        }
        return null;
    }

    public static void showShortSafe(final CharSequence text) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(text, 0);
            }
        });
    }

    public static void showShortSafe(final @StringRes int resId) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(resId, 0);
            }
        });
    }

    public static void showShortSafe(final @StringRes int resId, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(resId, 0, args);
            }
        });
    }

    public static void showShortSafe(final String format, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(format, 0, args);
            }
        });
    }

    public static void showLongSafe(final CharSequence text) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(text, 1);
            }
        });
    }

    public static void showLongSafe(final @StringRes int resId) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(resId, 1);
            }
        });
    }

    public static void showLongSafe(final @StringRes int resId, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(resId, 1, args);
            }
        });
    }

    public static void showLongSafe(final String format, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.show(format, 1, args);
            }
        });
    }

    public static void showShort(CharSequence text) {
        ToastUtils.show(text, 0);
    }

    public static void showShort(@StringRes int resId) {
        ToastUtils.show(resId, 0);
    }

    public static void showShort(@StringRes int resId, Object ... args) {
        ToastUtils.show(resId, 0, args);
    }

    public static void showShort(String format, Object ... args) {
        ToastUtils.show(format, 0, args);
    }

    public static void showLong(CharSequence text) {
        ToastUtils.show(text, 1);
    }

    public static void showLong(@StringRes int resId) {
        ToastUtils.show(resId, 1);
    }

    public static void showLong(@StringRes int resId, Object ... args) {
        ToastUtils.show(resId, 1, args);
    }

    public static void showLong(String format, Object ... args) {
        ToastUtils.show(format, 1, args);
    }

    private static void show(@StringRes int resId, int duration) {
        ToastUtils.show(Utils.getContext().getResources().getText(resId).toString(), duration);
    }

    private static void show(@StringRes int resId, int duration, Object ... args) {
        ToastUtils.show(String.format(Utils.getContext().getResources().getString(resId), args), duration);
    }

    private static void show(String format, int duration, Object ... args) {
        ToastUtils.show(String.format(format, args), duration);
    }

    private static void show(CharSequence text, int duration) {
        ToastUtils.cancel();
        if (customView != null) {
            sToast = new Toast(Utils.getContext());
            sToast.setView(customView);
            sToast.setDuration(duration);
        } else {
            sToast = Toast.makeText((Context)Utils.getContext(), (CharSequence)text, (int)duration);
        }
        sToast.setGravity(gravity, xOffset, yOffset);
        sToast.show();
    }

    public static void cancel() {
        if (sToast != null) {
            sToast.cancel();
            sToast = null;
        }
    }

    static {
        gravity = 81;
        xOffset = 0;
        yOffset = (int)((double)(64.0f * Utils.getContext().getResources().getDisplayMetrics().density) + 0.5);
        sHandler = new Handler(Looper.getMainLooper());
    }
}

