/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class TimeUtils {
    private static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static final String[] CHINESE_ZODIAC = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final String[] ZODIAC = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};
    private static final int[] ZODIAC_FLAGS = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 24, 23, 22};

    private TimeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String millis2String(long millis) {
        return TimeUtils.millis2String(millis, DEFAULT_FORMAT);
    }

    public static String millis2String(long millis, DateFormat format) {
        return format.format(new Date(millis));
    }

    public static long string2Millis(String time) {
        return TimeUtils.string2Millis(time, DEFAULT_FORMAT);
    }

    public static long string2Millis(String time, DateFormat format) {
        try {
            return format.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static Date string2Date(String time) {
        return TimeUtils.string2Date(time, DEFAULT_FORMAT);
    }

    public static Date string2Date(String time, DateFormat format) {
        try {
            return format.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String date2String(Date date) {
        return TimeUtils.date2String(date, DEFAULT_FORMAT);
    }

    public static String date2String(Date date, DateFormat format) {
        return format.format(date);
    }

    public static long date2Millis(Date date) {
        return date.getTime();
    }

    public static Date millis2Date(long millis) {
        return new Date(millis);
    }

    public static long getTimeSpan(String time0, String time1, int unit) {
        return TimeUtils.getTimeSpan(time0, time1, DEFAULT_FORMAT, unit);
    }

    public static long getTimeSpan(String time0, String time1, DateFormat format, int unit) {
        return TimeUtils.millis2TimeSpan(Math.abs(TimeUtils.string2Millis(time0, format) - TimeUtils.string2Millis(time1, format)), unit);
    }

    public static long getTimeSpan(Date date0, Date date1, int unit) {
        return TimeUtils.millis2TimeSpan(Math.abs(TimeUtils.date2Millis(date0) - TimeUtils.date2Millis(date1)), unit);
    }

    public static long getTimeSpan(long millis0, long millis1, int unit) {
        return TimeUtils.millis2TimeSpan(Math.abs(millis0 - millis1), unit);
    }

    public static String getFitTimeSpan(String time0, String time1, int precision) {
        return TimeUtils.millis2FitTimeSpan(Math.abs(TimeUtils.string2Millis(time0, DEFAULT_FORMAT) - TimeUtils.string2Millis(time1, DEFAULT_FORMAT)), precision);
    }

    public static String getFitTimeSpan(String time0, String time1, DateFormat format, int precision) {
        return TimeUtils.millis2FitTimeSpan(Math.abs(TimeUtils.string2Millis(time0, format) - TimeUtils.string2Millis(time1, format)), precision);
    }

    public static String getFitTimeSpan(Date date0, Date date1, int precision) {
        return TimeUtils.millis2FitTimeSpan(Math.abs(TimeUtils.date2Millis(date0) - TimeUtils.date2Millis(date1)), precision);
    }

    public static String getFitTimeSpan(long millis0, long millis1, int precision) {
        return TimeUtils.millis2FitTimeSpan(Math.abs(millis0 - millis1), precision);
    }

    public static long getNowMills() {
        return System.currentTimeMillis();
    }

    public static String getNowString() {
        return TimeUtils.millis2String(System.currentTimeMillis(), DEFAULT_FORMAT);
    }

    public static String getNowString(DateFormat format) {
        return TimeUtils.millis2String(System.currentTimeMillis(), format);
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static long getTimeSpanByNow(String time, int unit) {
        return TimeUtils.getTimeSpan(TimeUtils.getNowString(), time, DEFAULT_FORMAT, unit);
    }

    public static long getTimeSpanByNow(String time, DateFormat format, int unit) {
        return TimeUtils.getTimeSpan(TimeUtils.getNowString(format), time, format, unit);
    }

    public static long getTimeSpanByNow(Date date, int unit) {
        return TimeUtils.getTimeSpan(new Date(), date, unit);
    }

    public static long getTimeSpanByNow(long millis, int unit) {
        return TimeUtils.getTimeSpan(System.currentTimeMillis(), millis, unit);
    }

    public static String getFitTimeSpanByNow(String time, int precision) {
        return TimeUtils.getFitTimeSpan(TimeUtils.getNowString(), time, DEFAULT_FORMAT, precision);
    }

    public static String getFitTimeSpanByNow(String time, DateFormat format, int precision) {
        return TimeUtils.getFitTimeSpan(TimeUtils.getNowString(format), time, format, precision);
    }

    public static String getFitTimeSpanByNow(Date date, int precision) {
        return TimeUtils.getFitTimeSpan(TimeUtils.getNowDate(), date, precision);
    }

    public static String getFitTimeSpanByNow(long millis, int precision) {
        return TimeUtils.getFitTimeSpan(System.currentTimeMillis(), millis, precision);
    }

    public static String getFriendlyTimeSpanByNow(String time) {
        return TimeUtils.getFriendlyTimeSpanByNow(time, DEFAULT_FORMAT);
    }

    public static String getFriendlyTimeSpanByNow(String time, DateFormat format) {
        return TimeUtils.getFriendlyTimeSpanByNow(TimeUtils.string2Millis(time, format));
    }

    public static String getFriendlyTimeSpanByNow(Date date) {
        return TimeUtils.getFriendlyTimeSpanByNow(date.getTime());
    }

    public static String getFriendlyTimeSpanByNow(long millis) {
        long now = System.currentTimeMillis();
        long span = now - millis;
        if (span < 0L) {
            return String.format("%tc", millis);
        }
        if (span < 1000L) {
            return "\u521a\u521a";
        }
        if (span < 60000L) {
            return String.format(Locale.getDefault(), "%d\u79d2\u524d", span / 1000L);
        }
        if (span < 3600000L) {
            return String.format(Locale.getDefault(), "%d\u5206\u949f\u524d", span / 60000L);
        }
        long wee = now / 86400000L * 86400000L - 28800000L;
        if (millis >= wee) {
            return String.format("\u4eca\u5929%tR", millis);
        }
        if (millis >= wee - 86400000L) {
            return String.format("\u6628\u5929%tR", millis);
        }
        return String.format("%tF", millis);
    }

    public static long getMillis(long millis, long timeSpan, int unit) {
        return millis + TimeUtils.timeSpan2Millis(timeSpan, unit);
    }

    public static long getMillis(String time, long timeSpan, int unit) {
        return TimeUtils.getMillis(time, DEFAULT_FORMAT, timeSpan, unit);
    }

    public static long getMillis(String time, DateFormat format, long timeSpan, int unit) {
        return TimeUtils.string2Millis(time, format) + TimeUtils.timeSpan2Millis(timeSpan, unit);
    }

    public static long getMillis(Date date, long timeSpan, int unit) {
        return TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(timeSpan, unit);
    }

    public static String getString(long millis, long timeSpan, int unit) {
        return TimeUtils.getString(millis, DEFAULT_FORMAT, timeSpan, unit);
    }

    public static String getString(long millis, DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2String(millis + TimeUtils.timeSpan2Millis(timeSpan, unit), format);
    }

    public static String getString(String time, long timeSpan, int unit) {
        return TimeUtils.getString(time, DEFAULT_FORMAT, timeSpan, unit);
    }

    public static String getString(String time, DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2String(TimeUtils.string2Millis(time, format) + TimeUtils.timeSpan2Millis(timeSpan, unit), format);
    }

    public static String getString(Date date, long timeSpan, int unit) {
        return TimeUtils.getString(date, DEFAULT_FORMAT, timeSpan, unit);
    }

    public static String getString(Date date, DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2String(TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(timeSpan, unit), format);
    }

    public static Date getDate(long millis, long timeSpan, int unit) {
        return TimeUtils.millis2Date(millis + TimeUtils.timeSpan2Millis(timeSpan, unit));
    }

    public static Date getDate(String time, long timeSpan, int unit) {
        return TimeUtils.getDate(time, DEFAULT_FORMAT, timeSpan, unit);
    }

    public static Date getDate(String time, DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2Date(TimeUtils.string2Millis(time, format) + TimeUtils.timeSpan2Millis(timeSpan, unit));
    }

    public static Date getDate(Date date, long timeSpan, int unit) {
        return TimeUtils.millis2Date(TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(timeSpan, unit));
    }

    public static long getMillisByNow(long timeSpan, int unit) {
        return TimeUtils.getMillis(TimeUtils.getNowMills(), timeSpan, unit);
    }

    public static String getStringByNow(long timeSpan, int unit) {
        return TimeUtils.getStringByNow(timeSpan, DEFAULT_FORMAT, unit);
    }

    public static String getStringByNow(long timeSpan, DateFormat format, int unit) {
        return TimeUtils.getString(TimeUtils.getNowMills(), format, timeSpan, unit);
    }

    public static Date getDateByNow(long timeSpan, int unit) {
        return TimeUtils.getDate(TimeUtils.getNowMills(), timeSpan, unit);
    }

    public static boolean isToday(String time) {
        return TimeUtils.isToday(TimeUtils.string2Millis(time, DEFAULT_FORMAT));
    }

    public static boolean isToday(String time, DateFormat format) {
        return TimeUtils.isToday(TimeUtils.string2Millis(time, format));
    }

    public static boolean isToday(Date date) {
        return TimeUtils.isToday(date.getTime());
    }

    public static boolean isToday(long millis) {
        long wee = System.currentTimeMillis() / 86400000L * 86400000L - 28800000L;
        return millis >= wee && millis < wee + 86400000L;
    }

    public static boolean isLeapYear(String time) {
        return TimeUtils.isLeapYear(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static boolean isLeapYear(String time, DateFormat format) {
        return TimeUtils.isLeapYear(TimeUtils.string2Date(time, format));
    }

    public static boolean isLeapYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        return TimeUtils.isLeapYear(year);
    }

    public static boolean isLeapYear(long millis) {
        return TimeUtils.isLeapYear(TimeUtils.millis2Date(millis));
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static String getChineseWeek(String time) {
        return TimeUtils.getChineseWeek(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static String getChineseWeek(String time, DateFormat format) {
        return TimeUtils.getChineseWeek(TimeUtils.string2Date(time, format));
    }

    public static String getChineseWeek(Date date) {
        return new SimpleDateFormat("E", Locale.CHINA).format(date);
    }

    public static String getChineseWeek(long millis) {
        return TimeUtils.getChineseWeek(new Date(millis));
    }

    public static String getUSWeek(String time) {
        return TimeUtils.getUSWeek(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static String getUSWeek(String time, DateFormat format) {
        return TimeUtils.getUSWeek(TimeUtils.string2Date(time, format));
    }

    public static String getUSWeek(Date date) {
        return new SimpleDateFormat("EEEE", Locale.US).format(date);
    }

    public static String getUSWeek(long millis) {
        return TimeUtils.getUSWeek(new Date(millis));
    }

    public static int getWeekIndex(String time) {
        return TimeUtils.getWeekIndex(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static int getWeekIndex(String time, DateFormat format) {
        return TimeUtils.getWeekIndex(TimeUtils.string2Date(time, format));
    }

    public static int getWeekIndex(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getWeekIndex(long millis) {
        return TimeUtils.getWeekIndex(TimeUtils.millis2Date(millis));
    }

    public static int getWeekOfMonth(String time) {
        return TimeUtils.getWeekOfMonth(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static int getWeekOfMonth(String time, DateFormat format) {
        return TimeUtils.getWeekOfMonth(TimeUtils.string2Date(time, format));
    }

    public static int getWeekOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(4);
    }

    public static int getWeekOfMonth(long millis) {
        return TimeUtils.getWeekOfMonth(TimeUtils.millis2Date(millis));
    }

    public static int getWeekOfYear(String time) {
        return TimeUtils.getWeekOfYear(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static int getWeekOfYear(String time, DateFormat format) {
        return TimeUtils.getWeekOfYear(TimeUtils.string2Date(time, format));
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public static int getWeekOfYear(long millis) {
        return TimeUtils.getWeekOfYear(TimeUtils.millis2Date(millis));
    }

    public static String getChineseZodiac(String time) {
        return TimeUtils.getChineseZodiac(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static String getChineseZodiac(String time, DateFormat format) {
        return TimeUtils.getChineseZodiac(TimeUtils.string2Date(time, format));
    }

    public static String getChineseZodiac(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return CHINESE_ZODIAC[cal.get(1) % 12];
    }

    public static String getChineseZodiac(long millis) {
        return TimeUtils.getChineseZodiac(TimeUtils.millis2Date(millis));
    }

    public static String getChineseZodiac(int year) {
        return CHINESE_ZODIAC[year % 12];
    }

    public static String getZodiac(String time) {
        return TimeUtils.getZodiac(TimeUtils.string2Date(time, DEFAULT_FORMAT));
    }

    public static String getZodiac(String time, DateFormat format) {
        return TimeUtils.getZodiac(TimeUtils.string2Date(time, format));
    }

    public static String getZodiac(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return TimeUtils.getZodiac(month, day);
    }

    public static String getZodiac(long millis) {
        return TimeUtils.getZodiac(TimeUtils.millis2Date(millis));
    }

    public static String getZodiac(int month, int day) {
        return ZODIAC[day >= ZODIAC_FLAGS[month - 1] ? month - 1 : (month + 10) % 12];
    }

    private static long timeSpan2Millis(long timeSpan, int unit) {
        return timeSpan * (long)unit;
    }

    private static long millis2TimeSpan(long millis, int unit) {
        return millis / (long)unit;
    }

    private static String millis2FitTimeSpan(long millis, int precision) {
        if (millis < 0L || precision <= 0) {
            return null;
        }
        precision = Math.min(precision, 5);
        String[] units = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
        if (millis == 0L) {
            return 0 + units[precision - 1];
        }
        StringBuilder sb = new StringBuilder();
        int[] unitLen = new int[]{86400000, 3600000, 60000, 1000, 1};
        for (int i = 0; i < precision; ++i) {
            if (millis < (long)unitLen[i]) continue;
            long mode = millis / (long)unitLen[i];
            millis -= mode * (long)unitLen[i];
            sb.append(mode).append(units[i]);
        }
        return sb.toString();
    }
}

