/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public final class SpannableStringUtils {
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_TOP = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private SpannableStringUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    static abstract class CustomDynamicDrawableSpan
    extends ReplacementSpan {
        static final int ALIGN_BOTTOM = 0;
        static final int ALIGN_BASELINE = 1;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;
        private WeakReference<Drawable> mDrawableRef;

        CustomDynamicDrawableSpan() {
            this.mVerticalAlignment = 0;
        }

        CustomDynamicDrawableSpan(int verticalAlignment) {
            this.mVerticalAlignment = verticalAlignment;
        }

        public abstract Drawable getDrawable();

        public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            int fontHeight = (int)(paint.getFontMetrics().descent - paint.getFontMetrics().ascent);
            if (fm != null && rect.height() > fontHeight) {
                if (this.mVerticalAlignment == 3) {
                    fm.descent += rect.height() - fontHeight;
                } else if (this.mVerticalAlignment == 2) {
                    fm.ascent -= (rect.height() - fontHeight) / 2;
                    fm.descent += (rect.height() - fontHeight) / 2;
                } else {
                    fm.ascent = this.mVerticalAlignment == 1 ? (fm.ascent -= rect.height() - fontHeight + fm.descent) : (fm.ascent -= rect.height() - fontHeight);
                }
            }
            return rect.right;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            canvas.save();
            float fontHeight = paint.getFontMetrics().descent - paint.getFontMetrics().ascent;
            int transY = bottom - rect.bottom;
            if ((float)rect.height() < fontHeight) {
                if (this.mVerticalAlignment == 1) {
                    transY -= paint.getFontMetricsInt().descent;
                } else if (this.mVerticalAlignment == 2) {
                    transY = (int)((float)transY - (fontHeight - (float)rect.height()) / 2.0f);
                } else if (this.mVerticalAlignment == 3) {
                    transY = (int)((float)transY - (fontHeight - (float)rect.height()));
                }
            } else if (this.mVerticalAlignment == 1) {
                transY -= paint.getFontMetricsInt().descent;
            }
            canvas.translate(x, (float)transY);
            d.draw(canvas);
            canvas.restore();
        }

        private Drawable getCachedDrawable() {
            WeakReference<Drawable> wr = this.mDrawableRef;
            Drawable d = null;
            if (wr != null) {
                d = (Drawable)wr.get();
            }
            if (d == null) {
                d = this.getDrawable();
                this.mDrawableRef = new WeakReference<Drawable>(d);
            }
            return this.getDrawable();
        }
    }

    static class CustomImageSpan
    extends CustomDynamicDrawableSpan {
        private Drawable mDrawable;
        private Uri mContentUri;
        private int mResourceId;
        private Context mContext;

        CustomImageSpan(Context context, Bitmap b, int verticalAlignment) {
            super(verticalAlignment);
            this.mContext = context;
            this.mDrawable = context != null ? new BitmapDrawable(context.getResources(), b) : new BitmapDrawable(b);
            int width = this.mDrawable.getIntrinsicWidth();
            int height = this.mDrawable.getIntrinsicHeight();
            this.mDrawable.setBounds(0, 0, width > 0 ? width : 0, height > 0 ? height : 0);
        }

        CustomImageSpan(Drawable d, int verticalAlignment) {
            super(verticalAlignment);
            this.mDrawable = d;
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        CustomImageSpan(Context context, Uri uri, int verticalAlignment) {
            super(verticalAlignment);
            this.mContext = context;
            this.mContentUri = uri;
        }

        CustomImageSpan(Context context, @DrawableRes int resourceId, int verticalAlignment) {
            super(verticalAlignment);
            this.mContext = context;
            this.mResourceId = resourceId;
        }

        @Override
        public Drawable getDrawable() {
            Drawable drawable = null;
            if (this.mDrawable != null) {
                drawable = this.mDrawable;
            } else if (this.mContentUri != null) {
                Bitmap bitmap = null;
                try {
                    InputStream is = this.mContext.getContentResolver().openInputStream(this.mContentUri);
                    bitmap = BitmapFactory.decodeStream((InputStream)is);
                    drawable = new BitmapDrawable(this.mContext.getResources(), bitmap);
                    drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    Log.e((String)"sms", (String)("Failed to loaded content " + this.mContentUri), (Throwable)e);
                }
            } else {
                try {
                    drawable = ContextCompat.getDrawable((Context)this.mContext, (int)this.mResourceId);
                    drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                }
                catch (Exception e) {
                    Log.e((String)"sms", (String)("Unable to find resource: " + this.mResourceId));
                }
            }
            return drawable;
        }
    }

    @SuppressLint(value={"ParcelCreator"})
    static class CustomTypefaceSpan
    extends TypefaceSpan {
        private final Typeface newType;

        private CustomTypefaceSpan(Typeface type) {
            super("");
            this.newType = type;
        }

        public void updateDrawState(TextPaint textPaint) {
            CustomTypefaceSpan.apply((Paint)textPaint, this.newType);
        }

        public void updateMeasureState(TextPaint paint) {
            CustomTypefaceSpan.apply((Paint)paint, this.newType);
        }

        private static void apply(Paint paint, Typeface tf) {
            Typeface old = paint.getTypeface();
            int oldStyle = old == null ? 0 : old.getStyle();
            int fake = oldStyle & ~tf.getStyle();
            if ((fake & 1) != 0) {
                paint.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                paint.setTextSkewX(-0.25f);
            }
            paint.setTypeface(tf);
        }
    }

    static class CustomBulletSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int radius;
        private final int gapWidth;
        private static Path sBulletPath = null;

        private CustomBulletSpan(int color, int radius, int gapWidth) {
            this.color = color;
            this.radius = radius;
            this.gapWidth = gapWidth;
        }

        public int getLeadingMargin(boolean first) {
            return 2 * this.radius + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
            if (((Spanned)text).getSpanStart((Object)this) == start) {
                Paint.Style style = p.getStyle();
                int oldColor = 0;
                oldColor = p.getColor();
                p.setColor(this.color);
                p.setStyle(Paint.Style.FILL);
                if (c.isHardwareAccelerated()) {
                    if (sBulletPath == null) {
                        sBulletPath = new Path();
                        sBulletPath.addCircle(0.0f, 0.0f, (float)this.radius, Path.Direction.CW);
                    }
                    c.save();
                    c.translate((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f);
                    c.drawPath(sBulletPath, p);
                    c.restore();
                } else {
                    c.drawCircle((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f, (float)this.radius, p);
                }
                p.setColor(oldColor);
                p.setStyle(style);
            }
        }
    }

    static class CustomQuoteSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int stripeWidth;
        private final int gapWidth;

        private CustomQuoteSpan(@ColorInt int color, int stripeWidth, int gapWidth) {
            this.color = color;
            this.stripeWidth = stripeWidth;
            this.gapWidth = gapWidth;
        }

        public int getLeadingMargin(boolean first) {
            return this.stripeWidth + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
            Paint.Style style = p.getStyle();
            int color = p.getColor();
            p.setStyle(Paint.Style.FILL);
            p.setColor(this.color);
            c.drawRect((float)x, (float)top, (float)(x + dir * this.stripeWidth), (float)bottom, p);
            p.setStyle(style);
            p.setColor(color);
        }
    }

    static class MarginSpan
    extends ReplacementSpan {
        private final int margin;

        private MarginSpan(int margin) {
            this.margin = margin;
        }

        public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
            text = " ";
            return this.margin;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        }
    }

    public static class Builder {
        private int defaultValue = 0x12000000;
        private CharSequence text;
        private int flag = 33;
        @ColorInt
        private int foregroundColor = this.defaultValue;
        @ColorInt
        private int backgroundColor = this.defaultValue;
        @ColorInt
        private int quoteColor = this.defaultValue;
        private int stripeWidth;
        private int quoteGapWidth;
        private boolean isLeadingMargin;
        private int first;
        private int rest;
        private int margin = -1;
        private boolean isBullet;
        private int bulletColor;
        private int bulletRadius;
        private int bulletGapWidth;
        private int fontSize = -1;
        private boolean fontSizeIsDp;
        private float proportion = -1.0f;
        private float xProportion = -1.0f;
        private boolean isStrikethrough;
        private boolean isUnderline;
        private boolean isSuperscript;
        private boolean isSubscript;
        private boolean isBold;
        private boolean isItalic;
        private boolean isBoldItalic;
        private String fontFamily;
        private Typeface typeface;
        private Layout.Alignment alignment;
        private boolean imageIsBitmap;
        private Bitmap bitmap;
        private boolean imageIsDrawable;
        private Drawable drawable;
        private boolean imageIsUri;
        private Uri uri;
        private boolean imageIsResourceId;
        @DrawableRes
        private int resourceId;
        int align = 0;
        private ClickableSpan clickSpan;
        private String url;
        private boolean isBlur;
        private float blurRadius;
        private BlurMaskFilter.Blur style;
        private SpannableStringBuilder mBuilder = new SpannableStringBuilder();

        public Builder setFlag(int flag) {
            this.flag = flag;
            return this;
        }

        public Builder setForegroundColor(@ColorInt int color) {
            this.foregroundColor = color;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        public Builder setQuoteColor(@ColorInt int color) {
            this.quoteColor = color;
            this.stripeWidth = 2;
            this.quoteGapWidth = 2;
            return this;
        }

        public Builder setQuoteColor(@ColorInt int color, int stripeWidth, int quoteGapWidth) {
            this.quoteColor = color;
            this.stripeWidth = stripeWidth;
            this.quoteGapWidth = quoteGapWidth;
            return this;
        }

        public Builder setLeadingMargin(int first, int rest) {
            this.first = first;
            this.rest = rest;
            this.isLeadingMargin = true;
            return this;
        }

        public Builder setMargin(int margin) {
            this.margin = margin;
            this.text = " " + this.text;
            return this;
        }

        public Builder setBullet(@ColorInt int gapWidth) {
            this.bulletColor = 0;
            this.bulletRadius = 3;
            this.bulletGapWidth = gapWidth;
            this.isBullet = true;
            return this;
        }

        public Builder setBullet(@ColorInt int color, int radius, int gapWidth) {
            this.bulletColor = color;
            this.bulletRadius = radius;
            this.bulletGapWidth = gapWidth;
            this.isBullet = true;
            return this;
        }

        public Builder setFontSize(int size) {
            this.fontSize = size;
            this.fontSizeIsDp = false;
            return this;
        }

        public Builder setFontSize(int size, boolean isDp) {
            this.fontSize = size;
            this.fontSizeIsDp = isDp;
            return this;
        }

        public Builder setFontProportion(float proportion) {
            this.proportion = proportion;
            return this;
        }

        public Builder setFontXProportion(float proportion) {
            this.xProportion = proportion;
            return this;
        }

        public Builder setStrikethrough() {
            this.isStrikethrough = true;
            return this;
        }

        public Builder setUnderline() {
            this.isUnderline = true;
            return this;
        }

        public Builder setSuperscript() {
            this.isSuperscript = true;
            return this;
        }

        public Builder setSubscript() {
            this.isSubscript = true;
            return this;
        }

        public Builder setBold() {
            this.isBold = true;
            return this;
        }

        public Builder setItalic() {
            this.isItalic = true;
            return this;
        }

        public Builder setBoldItalic() {
            this.isBoldItalic = true;
            return this;
        }

        public Builder setFontFamily(@NonNull String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        public Builder setTypeface(@NonNull Typeface typeface) {
            this.typeface = typeface;
            return this;
        }

        public Builder setAlign(@NonNull Layout.Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder setBitmap(@NonNull Bitmap bitmap) {
            return this.setBitmap(bitmap, this.align);
        }

        public Builder setBitmap(@NonNull Bitmap bitmap, int align) {
            this.bitmap = bitmap;
            this.align = align;
            this.text = " " + this.text;
            this.imageIsBitmap = true;
            return this;
        }

        public Builder setDrawable(@NonNull Drawable drawable) {
            return this.setDrawable(drawable, this.align);
        }

        public Builder setDrawable(@NonNull Drawable drawable, int align) {
            this.drawable = drawable;
            this.align = align;
            this.text = " " + this.text;
            this.imageIsDrawable = true;
            return this;
        }

        public Builder setUri(@NonNull Uri uri) {
            this.setUri(uri, 0);
            return this;
        }

        public Builder setUri(@NonNull Uri uri, int align) {
            this.uri = uri;
            this.align = align;
            this.text = " " + this.text;
            this.imageIsUri = true;
            return this;
        }

        public Builder setResourceId(@DrawableRes int resourceId) {
            return this.setResourceId(resourceId, this.align);
        }

        public Builder setResourceId(@DrawableRes int resourceId, int align) {
            this.resourceId = resourceId;
            this.align = align;
            this.text = " " + this.text;
            this.imageIsResourceId = true;
            return this;
        }

        public Builder setClickSpan(@NonNull ClickableSpan clickSpan) {
            this.clickSpan = clickSpan;
            return this;
        }

        public Builder setUrl(@NonNull String url) {
            this.url = url;
            return this;
        }

        public Builder setBlur(float radius, BlurMaskFilter.Blur style) {
            this.blurRadius = radius;
            this.style = style;
            this.isBlur = true;
            return this;
        }

        public Builder appendLine(@NonNull CharSequence text) {
            return this.append(text + LINE_SEPARATOR);
        }

        public Builder append(@NonNull CharSequence text) {
            this.setSpan();
            this.text = text;
            return this;
        }

        public SpannableStringBuilder create() {
            this.setSpan();
            return this.mBuilder;
        }

        private void setSpan() {
            if (this.text == null || this.text.length() == 0) {
                return;
            }
            int start = this.mBuilder.length();
            this.mBuilder.append(this.text);
            int end = this.mBuilder.length();
            if (this.backgroundColor != this.defaultValue) {
                this.mBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), start, end, this.flag);
                this.backgroundColor = this.defaultValue;
            }
            if (this.foregroundColor != this.defaultValue) {
                this.mBuilder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), start, end, this.flag);
                this.foregroundColor = this.defaultValue;
            }
            if (this.isLeadingMargin) {
                this.mBuilder.setSpan((Object)new LeadingMarginSpan.Standard(this.first, this.rest), start, end, this.flag);
                this.isLeadingMargin = false;
            }
            if (this.margin != -1) {
                this.mBuilder.setSpan((Object)new MarginSpan(this.margin), start, end, this.flag);
                this.margin = -1;
            }
            if (this.quoteColor != this.defaultValue) {
                this.mBuilder.setSpan((Object)new CustomQuoteSpan(this.quoteColor, this.stripeWidth, this.quoteGapWidth), start, end, this.flag);
                this.quoteColor = this.defaultValue;
            }
            if (this.isBullet) {
                this.mBuilder.setSpan((Object)new CustomBulletSpan(this.bulletColor, this.bulletRadius, this.bulletGapWidth), start, end, this.flag);
                this.isBullet = false;
            }
            if (this.fontSize != -1) {
                this.mBuilder.setSpan((Object)new AbsoluteSizeSpan(this.fontSize, this.fontSizeIsDp), start, end, this.flag);
                this.fontSize = -1;
                this.fontSizeIsDp = false;
            }
            if (this.proportion != -1.0f) {
                this.mBuilder.setSpan((Object)new RelativeSizeSpan(this.proportion), start, end, this.flag);
                this.proportion = -1.0f;
            }
            if (this.xProportion != -1.0f) {
                this.mBuilder.setSpan((Object)new ScaleXSpan(this.xProportion), start, end, this.flag);
                this.xProportion = -1.0f;
            }
            if (this.isStrikethrough) {
                this.mBuilder.setSpan((Object)new StrikethroughSpan(), start, end, this.flag);
                this.isStrikethrough = false;
            }
            if (this.isUnderline) {
                this.mBuilder.setSpan((Object)new UnderlineSpan(), start, end, this.flag);
                this.isUnderline = false;
            }
            if (this.isSuperscript) {
                this.mBuilder.setSpan((Object)new SuperscriptSpan(), start, end, this.flag);
                this.isSuperscript = false;
            }
            if (this.isSubscript) {
                this.mBuilder.setSpan((Object)new SubscriptSpan(), start, end, this.flag);
                this.isSubscript = false;
            }
            if (this.isBold) {
                this.mBuilder.setSpan((Object)new StyleSpan(1), start, end, this.flag);
                this.isBold = false;
            }
            if (this.isItalic) {
                this.mBuilder.setSpan((Object)new StyleSpan(2), start, end, this.flag);
                this.isItalic = false;
            }
            if (this.isBoldItalic) {
                this.mBuilder.setSpan((Object)new StyleSpan(3), start, end, this.flag);
                this.isBoldItalic = false;
            }
            if (this.fontFamily != null) {
                this.mBuilder.setSpan((Object)new TypefaceSpan(this.fontFamily), start, end, this.flag);
                this.fontFamily = null;
            }
            if (this.typeface != null) {
                this.mBuilder.setSpan((Object)new CustomTypefaceSpan(this.typeface), start, end, this.flag);
                this.typeface = null;
            }
            if (this.alignment != null) {
                this.mBuilder.setSpan((Object)new AlignmentSpan.Standard(this.alignment), start, end, this.flag);
                this.alignment = null;
            }
            if (this.imageIsBitmap || this.imageIsDrawable || this.imageIsUri || this.imageIsResourceId) {
                if (this.imageIsBitmap) {
                    this.mBuilder.setSpan((Object)new CustomImageSpan(Utils.getContext(), this.bitmap, this.align), start, end, this.flag);
                    this.bitmap = null;
                    this.imageIsBitmap = false;
                } else if (this.imageIsDrawable) {
                    this.mBuilder.setSpan((Object)new CustomImageSpan(this.drawable, this.align), start, end, this.flag);
                    this.drawable = null;
                    this.imageIsDrawable = false;
                } else if (this.imageIsUri) {
                    this.mBuilder.setSpan((Object)new CustomImageSpan(Utils.getContext(), this.uri, this.align), start, end, this.flag);
                    this.uri = null;
                    this.imageIsUri = false;
                } else {
                    this.mBuilder.setSpan((Object)new CustomImageSpan(Utils.getContext(), this.resourceId, this.align), start, end, this.flag);
                    this.resourceId = 0;
                    this.imageIsResourceId = false;
                }
            }
            if (this.clickSpan != null) {
                this.mBuilder.setSpan((Object)this.clickSpan, start, end, this.flag);
                this.clickSpan = null;
            }
            if (this.url != null) {
                this.mBuilder.setSpan((Object)new URLSpan(this.url), start, end, this.flag);
                this.url = null;
            }
            if (this.isBlur) {
                this.mBuilder.setSpan((Object)new MaskFilterSpan((MaskFilter)new BlurMaskFilter(this.blurRadius, this.style)), start, end, this.flag);
                this.isBlur = false;
            }
            this.flag = 33;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Align {
    }
}

