/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.design.widget.Snackbar;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.lang.ref.WeakReference;

public final class SnackbarUtils {
    private static WeakReference<Snackbar> snackbarWeakReference;

    private SnackbarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void showShort(View parent, CharSequence text, @ColorInt int textColor, @ColorInt int bgColor) {
        SnackbarUtils.show(parent, text, -1, textColor, bgColor, null, -1, null);
    }

    public static void showShort(View parent, CharSequence text, @ColorInt int textColor, @ColorInt int bgColor, CharSequence actionText, @ColorInt int actionTextColor, View.OnClickListener listener) {
        SnackbarUtils.show(parent, text, -1, textColor, bgColor, actionText, actionTextColor, listener);
    }

    public static void showLong(View parent, CharSequence text, @ColorInt int textColor, @ColorInt int bgColor) {
        SnackbarUtils.show(parent, text, 0, textColor, bgColor, null, -1, null);
    }

    public static void showLong(View parent, CharSequence text, @ColorInt int textColor, @ColorInt int bgColor, CharSequence actionText, @ColorInt int actionTextColor, View.OnClickListener listener) {
        SnackbarUtils.show(parent, text, 0, textColor, bgColor, actionText, actionTextColor, listener);
    }

    public static void showIndefinite(View parent, CharSequence text, @ColorInt int textColor, @ColorInt int bgColor) {
        SnackbarUtils.show(parent, text, -2, textColor, bgColor, null, -1, null);
    }

    public static void showIndefinite(View parent, CharSequence text, @ColorInt int textColor, @ColorInt int bgColor, CharSequence actionText, @ColorInt int actionTextColor, View.OnClickListener listener) {
        SnackbarUtils.show(parent, text, -2, textColor, bgColor, actionText, actionTextColor, listener);
    }

    private static void show(View parent, CharSequence text, int duration, @ColorInt int textColor, @ColorInt int bgColor, CharSequence actionText, @ColorInt int actionTextColor, View.OnClickListener listener) {
        SpannableString spannableString = new SpannableString(text);
        ForegroundColorSpan colorSpan = new ForegroundColorSpan(textColor);
        spannableString.setSpan((Object)colorSpan, 0, spannableString.length(), 33);
        snackbarWeakReference = new WeakReference<Snackbar>(Snackbar.make((View)parent, (CharSequence)spannableString, (int)duration));
        Snackbar snackbar = (Snackbar)snackbarWeakReference.get();
        View view = snackbar.getView();
        view.setBackgroundColor(bgColor);
        if (actionText != null && actionText.length() > 0 && listener != null) {
            snackbar.setActionTextColor(actionTextColor);
            snackbar.setAction(actionText, listener);
        }
        snackbar.show();
    }

    public static void addView(@LayoutRes int layoutId, int index) {
        Snackbar snackbar = (Snackbar)snackbarWeakReference.get();
        if (snackbar != null) {
            View view = snackbar.getView();
            Snackbar.SnackbarLayout layout = (Snackbar.SnackbarLayout)view;
            View child = LayoutInflater.from((Context)view.getContext()).inflate(layoutId, null);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.gravity = 16;
            layout.addView(child, index, (ViewGroup.LayoutParams)params);
        }
    }

    public static void addView(View child, int index, ViewGroup.LayoutParams params) {
        Snackbar snackbar = (Snackbar)snackbarWeakReference.get();
        if (snackbar != null) {
            View view = snackbar.getView();
            Snackbar.SnackbarLayout layout = (Snackbar.SnackbarLayout)view;
            layout.addView(child, index, params);
        }
    }

    public static void dismiss() {
        if (snackbarWeakReference != null && snackbarWeakReference.get() != null) {
            ((Snackbar)snackbarWeakReference.get()).dismiss();
            snackbarWeakReference = null;
        }
    }
}

