/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.codvision.base.utils.third.thirdparty.Utils;

public final class SizeUtils {
    private SizeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int dp2px(float dpValue) {
        float scale = Utils.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(float pxValue) {
        float scale = Utils.getContext().getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(float spValue) {
        float fontScale = Utils.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(float pxValue) {
        float fontScale = Utils.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static float applyDimension(int unit, float value, DisplayMetrics metrics) {
        switch (unit) {
            case 1: {
                return value * metrics.density;
            }
            case 2: {
                return value * metrics.scaledDensity;
            }
            case 3: {
                return value * metrics.xdpi * 0.013888889f;
            }
            case 4: {
                return value * metrics.xdpi;
            }
            case 5: {
                return value * metrics.xdpi * 0.03937008f;
            }
            case 0: {
                return value;
            }
        }
        return 0.0f;
    }

    public static void forceGetViewSize(final View view, final onGetSizeListener listener) {
        view.post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.onGetSize(view);
                }
            }
        });
    }

    public static int[] measureView(View view) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            lp = new ViewGroup.LayoutParams(-1, -2);
        }
        int widthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)lp.width);
        int lpHeight = lp.height;
        int heightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(widthSpec, heightSpec);
        return new int[]{view.getMeasuredWidth(), view.getMeasuredHeight()};
    }

    public static int getMeasuredWidth(View view) {
        return SizeUtils.measureView(view)[0];
    }

    public static int getMeasuredHeight(View view) {
        return SizeUtils.measureView(view)[1];
    }

    public static interface onGetSizeListener {
        public void onGetSize(View var1);
    }
}

