/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.app.ActivityManager;
import android.content.Intent;
import android.content.ServiceConnection;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ServiceUtils {
    private ServiceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Set getAllRunningService() {
        ActivityManager activityManager = (ActivityManager)Utils.getContext().getSystemService("activity");
        List info = activityManager.getRunningServices(Integer.MAX_VALUE);
        HashSet<String> names = new HashSet<String>();
        if (info == null || info.size() == 0) {
            return null;
        }
        for (ActivityManager.RunningServiceInfo aInfo : info) {
            names.add(aInfo.service.getClassName());
        }
        return names;
    }

    public static void startService(String className) {
        try {
            ServiceUtils.startService(Class.forName(className));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startService(Class<?> cls) {
        Intent intent = new Intent(Utils.getContext(), cls);
        Utils.getContext().startService(intent);
    }

    public static boolean stopService(String className) {
        try {
            return ServiceUtils.stopService(Class.forName(className));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean stopService(Class<?> cls) {
        Intent intent = new Intent(Utils.getContext(), cls);
        return Utils.getContext().stopService(intent);
    }

    public static void bindService(String className, ServiceConnection conn, int flags) {
        try {
            ServiceUtils.bindService(Class.forName(className), conn, flags);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void bindService(Class<?> cls, ServiceConnection conn, int flags) {
        Intent intent = new Intent(Utils.getContext(), cls);
        Utils.getContext().bindService(intent, conn, flags);
    }

    public static void unbindService(ServiceConnection conn) {
        Utils.getContext().unbindService(conn);
    }

    public static boolean isServiceRunning(String className) {
        ActivityManager activityManager = (ActivityManager)Utils.getContext().getSystemService("activity");
        List info = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningServiceInfo aInfo : info) {
            if (!className.equals(aInfo.service.getClassName())) continue;
            return true;
        }
        return false;
    }
}

