/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import com.codvision.base.utils.third.thirdparty.BarUtils;
import com.codvision.base.utils.third.thirdparty.Utils;

public final class ScreenUtils {
    private ScreenUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getScreenWidth() {
        WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int getScreenHeight() {
        WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static void setLandscape(Activity activity) {
        activity.setRequestedOrientation(0);
    }

    public static void setPortrait(Activity activity) {
        activity.setRequestedOrientation(1);
    }

    public static boolean isLandscape() {
        return Utils.getContext().getResources().getConfiguration().orientation == 2;
    }

    public static boolean isPortrait() {
        return Utils.getContext().getResources().getConfiguration().orientation == 1;
    }

    public static int getScreenRotation(Activity activity) {
        switch (activity.getWindowManager().getDefaultDisplay().getRotation()) {
            default: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: 
        }
        return 270;
    }

    public static Bitmap captureWithStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)dm.widthPixels, (int)dm.heightPixels);
        view.destroyDrawingCache();
        return ret;
    }

    public static Bitmap captureWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        int statusBarHeight = BarUtils.getStatusBarHeight((Context)activity);
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)dm.widthPixels, (int)(dm.heightPixels - statusBarHeight));
        view.destroyDrawingCache();
        return ret;
    }

    public static boolean isScreenLock() {
        KeyguardManager km = (KeyguardManager)Utils.getContext().getSystemService("keyguard");
        return km.inKeyguardRestrictedInputMode();
    }

    public static void setSleepDuration(int duration) {
        Settings.System.putInt((ContentResolver)Utils.getContext().getContentResolver(), (String)"screen_off_timeout", (int)duration);
    }

    public static int getSleepDuration() {
        try {
            return Settings.System.getInt((ContentResolver)Utils.getContext().getContentResolver(), (String)"screen_off_timeout");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            return -123;
        }
    }
}

