/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import com.codvision.base.utils.third.thirdparty.LogUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ProcessUtils {
    private ProcessUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getForegroundProcessName() {
        ActivityManager manager = (ActivityManager)Utils.getContext().getSystemService("activity");
        List pInfo = manager.getRunningAppProcesses();
        if (pInfo != null && pInfo.size() != 0) {
            for (ActivityManager.RunningAppProcessInfo aInfo : pInfo) {
                if (aInfo.importance != 100) continue;
                return aInfo.processName;
            }
        }
        if (Build.VERSION.SDK_INT > 21) {
            PackageManager packageManager = Utils.getContext().getPackageManager();
            Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            List list = packageManager.queryIntentActivities(intent, 65536);
            System.out.println(list);
            if (list.size() > 0) {
                try {
                    long endTime;
                    long beginTime;
                    ApplicationInfo info = packageManager.getApplicationInfo(Utils.getContext().getPackageName(), 0);
                    AppOpsManager aom = (AppOpsManager)Utils.getContext().getSystemService("appops");
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        Utils.getContext().startActivity(intent);
                    }
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        LogUtils.d("getForegroundApp", "\u6ca1\u6709\u6253\u5f00\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
                        return null;
                    }
                    UsageStatsManager usageStatsManager = (UsageStatsManager)Utils.getContext().getSystemService("usagestats");
                    List usageStatses = usageStatsManager.queryUsageStats(4, beginTime = (endTime = System.currentTimeMillis()) - 604800000L, endTime);
                    if (usageStatses == null || usageStatses.isEmpty()) {
                        return null;
                    }
                    UsageStats recentStats = null;
                    for (UsageStats usageStats : usageStatses) {
                        if (recentStats != null && usageStats.getLastTimeUsed() <= recentStats.getLastTimeUsed()) continue;
                        recentStats = usageStats;
                    }
                    return recentStats == null ? null : recentStats.getPackageName();
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                LogUtils.d("getForegroundApp", "\u65e0\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
            }
        }
        return null;
    }

    public static Set<String> getAllBackgroundProcesses() {
        ActivityManager am = (ActivityManager)Utils.getContext().getSystemService("activity");
        List info = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            Collections.addAll(set, aInfo.pkgList);
        }
        return set;
    }

    public static Set<String> killAllBackgroundProcesses() {
        ActivityManager am = (ActivityManager)Utils.getContext().getSystemService("activity");
        List info = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            for (String pkg : aInfo.pkgList) {
                am.killBackgroundProcesses(pkg);
                set.add(pkg);
            }
        }
        info = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            for (String pkg : aInfo.pkgList) {
                set.remove(pkg);
            }
        }
        return set;
    }

    public static boolean killBackgroundProcesses(@NonNull String packageName) {
        ActivityManager am = (ActivityManager)Utils.getContext().getSystemService("activity");
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (!Arrays.asList(aInfo.pkgList).contains(packageName)) continue;
            am.killBackgroundProcesses(packageName);
        }
        info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (!Arrays.asList(aInfo.pkgList).contains(packageName)) continue;
            return false;
        }
        return true;
    }
}

