/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.SystemClock;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Xml;
import com.codvision.base.utils.third.thirdparty.IntentUtils;
import com.codvision.base.utils.third.thirdparty.StringUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public final class PhoneUtils {
    private PhoneUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        return tm != null && tm.getPhoneType() != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getIMEI() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        return tm != null ? tm.getDeviceId() : null;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getIMSI() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        return tm != null ? tm.getSubscriberId() : null;
    }

    public static int getPhoneType() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        return tm != null ? tm.getPhoneType() : -1;
    }

    public static boolean isSimCardReady() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        return tm != null && tm.getSimState() == 5;
    }

    public static String getSimOperatorName() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        return tm != null ? tm.getSimOperatorName() : null;
    }

    public static String getSimOperatorByMnc() {
        String operator;
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        String string = operator = tm != null ? tm.getSimOperator() : null;
        if (operator == null) {
            return null;
        }
        switch (operator) {
            case "46000": 
            case "46002": 
            case "46007": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return operator;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getPhoneStatus() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        String str = "";
        str = str + "DeviceId(IMEI) = " + tm.getDeviceId() + "\n";
        str = str + "DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n";
        str = str + "Line1Number = " + tm.getLine1Number() + "\n";
        str = str + "NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n";
        str = str + "NetworkOperator = " + tm.getNetworkOperator() + "\n";
        str = str + "NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n";
        str = str + "NetworkType = " + tm.getNetworkType() + "\n";
        str = str + "PhoneType = " + tm.getPhoneType() + "\n";
        str = str + "SimCountryIso = " + tm.getSimCountryIso() + "\n";
        str = str + "SimOperator = " + tm.getSimOperator() + "\n";
        str = str + "SimOperatorName = " + tm.getSimOperatorName() + "\n";
        str = str + "SimSerialNumber = " + tm.getSimSerialNumber() + "\n";
        str = str + "SimState = " + tm.getSimState() + "\n";
        str = str + "SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n";
        str = str + "VoiceMailNumber = " + tm.getVoiceMailNumber() + "\n";
        return str;
    }

    public static void dial(String phoneNumber) {
        Utils.getContext().startActivity(IntentUtils.getDialIntent(phoneNumber));
    }

    public static void call(String phoneNumber) {
        Utils.getContext().startActivity(IntentUtils.getCallIntent(phoneNumber));
    }

    public static void sendSms(String phoneNumber, String content) {
        Utils.getContext().startActivity(IntentUtils.getSendSmsIntent(phoneNumber, content));
    }

    public static void sendSmsSilent(String phoneNumber, String content) {
        if (StringUtils.isEmpty(content)) {
            return;
        }
        PendingIntent sentIntent = PendingIntent.getBroadcast((Context)Utils.getContext(), (int)0, (Intent)new Intent(), (int)0);
        SmsManager smsManager = SmsManager.getDefault();
        if (content.length() >= 70) {
            ArrayList ms = smsManager.divideMessage(content);
            for (String str : ms) {
                smsManager.sendTextMessage(phoneNumber, null, str, sentIntent, null);
            }
        } else {
            smsManager.sendTextMessage(phoneNumber, null, content, sentIntent, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HashMap<String, String>> getAllContactInfo() {
        SystemClock.sleep((long)3000L);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        ContentResolver resolver = Utils.getContext().getContentResolver();
        Uri raw_uri = Uri.parse((String)"content://com.android.contacts/raw_contacts");
        Uri date_uri = Uri.parse((String)"content://com.android.contacts/data");
        try (Cursor cursor = resolver.query(raw_uri, new String[]{"contact_id"}, null, null, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String contact_id = cursor.getString(0);
                    if (StringUtils.isEmpty(contact_id)) continue;
                    Cursor c = resolver.query(date_uri, new String[]{"data1", "mimetype"}, "raw_contact_id=?", new String[]{contact_id}, null);
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (c != null) {
                        while (c.moveToNext()) {
                            String data1 = c.getString(0);
                            String mimetype = c.getString(1);
                            if (mimetype.equals("vnd.android.cursor.item/phone_v2")) {
                                map.put("phone", data1);
                                continue;
                            }
                            if (!mimetype.equals("vnd.android.cursor.item/name")) continue;
                            map.put("name", data1);
                        }
                    }
                    list.add(map);
                    if (c == null) continue;
                    c.close();
                }
            }
        }
        return list;
    }

    public static void getContactNum() {
        Log.d((String)"tips", (String)"U should copy the following code.");
    }

    public static void getAllSMS() {
        ContentResolver resolver = Utils.getContext().getContentResolver();
        Uri uri = Uri.parse((String)"content://sms");
        Cursor cursor = resolver.query(uri, new String[]{"address", "date", "type", "body"}, null, null, null);
        int count = cursor.getCount();
        XmlSerializer xmlSerializer = Xml.newSerializer();
        try {
            xmlSerializer.setOutput((OutputStream)new FileOutputStream(new File("/mnt/sdcard/backupsms.xml")), "utf-8");
            xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
            xmlSerializer.startTag(null, "smss");
            while (cursor.moveToNext()) {
                SystemClock.sleep((long)1000L);
                xmlSerializer.startTag(null, "sms");
                xmlSerializer.startTag(null, "address");
                String address = cursor.getString(0);
                xmlSerializer.text(address);
                xmlSerializer.endTag(null, "address");
                xmlSerializer.startTag(null, "date");
                String date = cursor.getString(1);
                xmlSerializer.text(date);
                xmlSerializer.endTag(null, "date");
                xmlSerializer.startTag(null, "type");
                String type = cursor.getString(2);
                xmlSerializer.text(type);
                xmlSerializer.endTag(null, "type");
                xmlSerializer.startTag(null, "body");
                String body = cursor.getString(3);
                xmlSerializer.text(body);
                xmlSerializer.endTag(null, "body");
                xmlSerializer.endTag(null, "sms");
                System.out.println("address:" + address + "   date:" + date + "  type:" + type + "  body:" + body);
            }
            xmlSerializer.endTag(null, "smss");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

