/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import java.util.ArrayList;

public final class PermissionUtils {
    private static int mRequestCode = -1;
    private static OnPermissionListener mOnPermissionListener;

    @TargetApi(value=23)
    public static void requestPermissions(Context context, int requestCode, String[] permissions, OnPermissionListener listener) {
        PermissionUtils.requestPermissions(context, requestCode, permissions, listener, null);
    }

    @TargetApi(value=23)
    public static void requestPermissions(Context context, int requestCode, String[] permissions, OnPermissionListener listener, RationaleHandler handler) {
        if (context instanceof Activity) {
            mRequestCode = requestCode;
            mOnPermissionListener = listener;
            String[] deniedPermissions = PermissionUtils.getDeniedPermissions(context, permissions);
            if (deniedPermissions.length > 0) {
                boolean rationale = PermissionUtils.shouldShowRequestPermissionRationale(context, deniedPermissions);
                if (rationale && handler != null) {
                    handler.showRationale(context, requestCode, deniedPermissions);
                } else {
                    ((Activity)context).requestPermissions(deniedPermissions, requestCode);
                }
            } else if (mOnPermissionListener != null) {
                mOnPermissionListener.onPermissionGranted();
            }
        } else {
            throw new RuntimeException("Context must be an Activity");
        }
    }

    public static void onRequestPermissionsResult(Activity context, int requestCode, String[] permissions, int[] grantResults) {
        if (mRequestCode != -1 && requestCode == mRequestCode && mOnPermissionListener != null) {
            String[] deniedPermissions = PermissionUtils.getDeniedPermissions((Context)context, permissions);
            if (deniedPermissions.length > 0) {
                mOnPermissionListener.onPermissionDenied(deniedPermissions);
            } else {
                mOnPermissionListener.onPermissionGranted();
            }
        }
    }

    private static String[] getDeniedPermissions(Context context, String[] permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission) != -1) continue;
            deniedPermissions.add(permission);
        }
        return deniedPermissions.toArray(new String[deniedPermissions.size()]);
    }

    public static boolean hasAlwaysDeniedPermission(Context context, String ... deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (PermissionUtils.shouldShowRequestPermissionRationale(context, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldShowRequestPermissionRationale(Context context, String ... deniedPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        for (String permission : deniedPermissions) {
            boolean rationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)permission);
            if (!rationale) continue;
            return true;
        }
        return false;
    }

    public static abstract class RationaleHandler {
        private Context context;
        private int requestCode;
        private String[] permissions;

        protected abstract void showRationale();

        void showRationale(Context context, int requestCode, String[] permissions) {
            this.context = context;
            this.requestCode = requestCode;
            this.permissions = permissions;
            this.showRationale();
        }

        @TargetApi(value=23)
        public void requestPermissionsAgain() {
            ((Activity)this.context).requestPermissions(this.permissions, this.requestCode);
        }
    }

    public static interface OnPermissionListener {
        public void onPermissionGranted();

        public void onPermissionDenied(String[] var1);
    }
}

