/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.codvision.base.utils.third.thirdparty.LogUtils;
import com.codvision.base.utils.third.thirdparty.ShellUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class NetworkUtils {
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;

    private NetworkUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void openWirelessSettings() {
        if (Build.VERSION.SDK_INT > 10) {
            Utils.getContext().startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
        } else {
            Utils.getContext().startActivity(new Intent("android.settings.SETTINGS").setFlags(0x10000000));
        }
    }

    private static NetworkInfo getActiveNetworkInfo() {
        return ((ConnectivityManager)Utils.getContext().getSystemService("connectivity")).getActiveNetworkInfo();
    }

    public static boolean isConnected() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public static boolean isAvailableByPing() {
        boolean ret;
        ShellUtils.CommandResult result = ShellUtils.execCmd("ping -c 1 -w 1 223.5.5.5", false);
        boolean bl = ret = result.result == 0;
        if (result.errorMsg != null) {
            LogUtils.d("isAvailableByPing errorMsg", result.errorMsg);
        }
        if (result.successMsg != null) {
            LogUtils.d("isAvailableByPing successMsg", result.successMsg);
        }
        return ret;
    }

    public static boolean getDataEnabled() {
        try {
            TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
            Method getMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("getDataEnabled", new Class[0]);
            if (null != getMobileDataEnabledMethod) {
                return (Boolean)getMobileDataEnabledMethod.invoke((Object)tm, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void setDataEnabled(boolean enabled) {
        try {
            TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
            Method setMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
            if (null != setMobileDataEnabledMethod) {
                setMobileDataEnabledMethod.invoke((Object)tm, enabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean is4G() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    public static boolean getWifiEnabled() {
        WifiManager wifiManager = (WifiManager)Utils.getContext().getSystemService("wifi");
        return wifiManager.isWifiEnabled();
    }

    public static void setWifiEnabled(boolean enabled) {
        WifiManager wifiManager = (WifiManager)Utils.getContext().getSystemService("wifi");
        if (enabled) {
            if (!wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(true);
            }
        } else if (wifiManager.isWifiEnabled()) {
            wifiManager.setWifiEnabled(false);
        }
    }

    public static boolean isWifiConnected() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getContext().getSystemService("connectivity");
        return cm != null && cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().getType() == 1;
    }

    public static boolean isWifiAvailable() {
        return NetworkUtils.getWifiEnabled() && NetworkUtils.isAvailableByPing();
    }

    public static String getNetworkOperatorName() {
        TelephonyManager tm = (TelephonyManager)Utils.getContext().getSystemService("phone");
        return tm != null ? tm.getNetworkOperatorName() : null;
    }

    public static NetworkType getNetworkType() {
        NetworkType netType = NetworkType.NETWORK_NO;
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                netType = NetworkType.NETWORK_WIFI;
            } else if (info.getType() == 0) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        netType = NetworkType.NETWORK_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        netType = NetworkType.NETWORK_3G;
                        break;
                    }
                    case 13: 
                    case 18: {
                        netType = NetworkType.NETWORK_4G;
                        break;
                    }
                    default: {
                        String subtypeName = info.getSubtypeName();
                        if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                            netType = NetworkType.NETWORK_3G;
                            break;
                        }
                        netType = NetworkType.NETWORK_UNKNOWN;
                        break;
                    }
                }
            } else {
                netType = NetworkType.NETWORK_UNKNOWN;
            }
        }
        return netType;
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    boolean isIPv4;
                    InetAddress inetAddress = addresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String hostAddress = inetAddress.getHostAddress();
                    boolean bl = isIPv4 = hostAddress.indexOf(58) < 0;
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return hostAddress;
                    }
                    if (isIPv4) continue;
                    int index = hostAddress.indexOf(37);
                    return index < 0 ? hostAddress.toUpperCase() : hostAddress.substring(0, index).toUpperCase();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getDomainAddress(final String domain) {
        try {
            ExecutorService exec = Executors.newCachedThreadPool();
            Future<String> fs = exec.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try {
                        InetAddress inetAddress = InetAddress.getByName(domain);
                        return inetAddress.getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            return fs.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum NetworkType {
        NETWORK_WIFI,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

