/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.os.Environment;
import android.util.Log;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class LogUtils {
    public static final int V = 2;
    public static final int D = 3;
    public static final int I = 4;
    public static final int W = 5;
    public static final int E = 6;
    public static final int A = 7;
    private static final char[] T = new char[]{'V', 'D', 'I', 'W', 'E', 'A'};
    private static final int FILE = 16;
    private static final int JSON = 32;
    private static final int XML = 48;
    private static ExecutorService executor;
    private static String defaultDir;
    private static String dir;
    private static boolean sLogSwitch;
    private static boolean sLog2ConsoleSwitch;
    private static String sGlobalTag;
    private static boolean sTagIsSpace;
    private static boolean sLogHeadSwitch;
    private static boolean sLog2FileSwitch;
    private static boolean sLogBorderSwitch;
    private static int sConsoleFilter;
    private static int sFileFilter;
    private static final String FILE_SEP;
    private static final String LINE_SEP;
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String LEFT_BORDER = "\u2551 ";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final int MAX_LEN = 4000;
    private static final Format FORMAT;
    private static final String NULL_TIPS = "Log with null object.";
    private static final String NULL = "null";
    private static final String ARGS = "args";

    private LogUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void v(Object contents) {
        LogUtils.log(2, sGlobalTag, contents);
    }

    public static void v(String tag, Object ... contents) {
        LogUtils.log(2, tag, contents);
    }

    public static void d(Object contents) {
        LogUtils.log(3, sGlobalTag, contents);
    }

    public static void d(String tag, Object ... contents) {
        LogUtils.log(3, tag, contents);
    }

    public static void i(Object contents) {
        LogUtils.log(4, sGlobalTag, contents);
    }

    public static void i(String tag, Object ... contents) {
        LogUtils.log(4, tag, contents);
    }

    public static void w(Object contents) {
        LogUtils.log(5, sGlobalTag, contents);
    }

    public static void w(String tag, Object ... contents) {
        LogUtils.log(5, tag, contents);
    }

    public static void e(Object contents) {
        LogUtils.log(6, sGlobalTag, contents);
    }

    public static void e(String tag, Object ... contents) {
        LogUtils.log(6, tag, contents);
    }

    public static void a(Object contents) {
        LogUtils.log(7, sGlobalTag, contents);
    }

    public static void a(String tag, Object ... contents) {
        LogUtils.log(7, tag, contents);
    }

    public static void file(Object contents) {
        LogUtils.log(19, sGlobalTag, contents);
    }

    public static void file(int type, Object contents) {
        LogUtils.log(0x10 | type, sGlobalTag, contents);
    }

    public static void file(String tag, Object contents) {
        LogUtils.log(19, tag, contents);
    }

    public static void file(int type, String tag, Object contents) {
        LogUtils.log(0x10 | type, tag, contents);
    }

    public static void json(String contents) {
        LogUtils.log(35, sGlobalTag, contents);
    }

    public static void json(int type, String contents) {
        LogUtils.log(0x20 | type, sGlobalTag, contents);
    }

    public static void json(String tag, String contents) {
        LogUtils.log(35, tag, contents);
    }

    public static void json(int type, String tag, String contents) {
        LogUtils.log(0x20 | type, tag, contents);
    }

    public static void xml(String contents) {
        LogUtils.log(51, sGlobalTag, contents);
    }

    public static void xml(int type, String contents) {
        LogUtils.log(0x30 | type, sGlobalTag, contents);
    }

    public static void xml(String tag, String contents) {
        LogUtils.log(51, tag, contents);
    }

    public static void xml(int type, String tag, String contents) {
        LogUtils.log(0x30 | type, tag, contents);
    }

    private static void log(int type, String tag, Object ... contents) {
        if (!sLogSwitch || !sLog2ConsoleSwitch && !sLog2FileSwitch) {
            return;
        }
        int type_low = type & 0xF;
        int type_high = type & 0xF0;
        if (type_low < sConsoleFilter && type_low < sFileFilter) {
            return;
        }
        String[] tagAndHead = LogUtils.processTagAndHead(tag);
        String body = LogUtils.processBody(type_high, contents);
        if (sLog2ConsoleSwitch && type_low >= sConsoleFilter) {
            LogUtils.print2Console(type_low, tagAndHead[0], tagAndHead[1] + body);
        }
        if ((sLog2FileSwitch || type_high == 16) && type_low >= sFileFilter) {
            LogUtils.print2File(type_low, tagAndHead[0], tagAndHead[2] + body);
        }
    }

    private static String[] processTagAndHead(String tag) {
        if (!sTagIsSpace && !sLogHeadSwitch) {
            tag = sGlobalTag;
        } else {
            StackTraceElement targetElement = Thread.currentThread().getStackTrace()[5];
            String className = targetElement.getClassName();
            String[] classNameInfo = className.split("\\.");
            if (classNameInfo.length > 0) {
                className = classNameInfo[classNameInfo.length - 1];
            }
            if (className.contains("$")) {
                className = className.split("\\$")[0];
            }
            if (sTagIsSpace) {
                String string = tag = LogUtils.isSpace(tag) ? className : tag;
            }
            if (sLogHeadSwitch) {
                String head = new Formatter().format("%s, %s(%s.java:%d)", Thread.currentThread().getName(), targetElement.getMethodName(), className, targetElement.getLineNumber()).toString();
                return new String[]{tag, head + LINE_SEP, " [" + head + "]: "};
            }
        }
        return new String[]{tag, "", ": "};
    }

    private static String processBody(int type, Object ... contents) {
        String body = NULL_TIPS;
        if (contents != null) {
            if (contents.length == 1) {
                Object object = contents[0];
                String string = body = object == null ? NULL : object.toString();
                if (type == 32) {
                    body = LogUtils.formatJson(body);
                } else if (type == 48) {
                    body = LogUtils.formatXml(body);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                int len = contents.length;
                for (int i = 0; i < len; ++i) {
                    Object content = contents[i];
                    sb.append(ARGS).append("[").append(i).append("]").append(" = ").append(content == null ? NULL : content.toString()).append(LINE_SEP);
                }
                body = sb.toString();
            }
        }
        return body;
    }

    private static String formatJson(String json) {
        try {
            if (json.startsWith("{")) {
                json = new JSONObject(json).toString(4);
            } else if (json.startsWith("[")) {
                json = new JSONArray(json).toString(4);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    private static String formatXml(String xml) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(xmlInput, xmlOutput);
            xml = xmlOutput.getWriter().toString().replaceFirst(">", ">" + LINE_SEP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    private static void print2Console(int type, String tag, String msg) {
        int len;
        int countOfSub;
        if (sLogBorderSwitch) {
            LogUtils.print(type, tag, TOP_BORDER);
            msg = LogUtils.addLeftBorder(msg);
        }
        if ((countOfSub = (len = msg.length()) / 4000) > 0) {
            String sub;
            LogUtils.print(type, tag, msg.substring(0, 4000));
            int index = 4000;
            for (int i = 1; i < countOfSub; ++i) {
                sub = msg.substring(index, index + 4000);
                LogUtils.print(type, tag, sLogBorderSwitch ? LEFT_BORDER + sub : sub);
                index += 4000;
            }
            sub = msg.substring(index, len);
            LogUtils.print(type, tag, sLogBorderSwitch ? LEFT_BORDER + sub : sub);
        } else {
            LogUtils.print(type, tag, msg);
        }
        if (sLogBorderSwitch) {
            LogUtils.print(type, tag, BOTTOM_BORDER);
        }
    }

    private static void print(int type, String tag, String msg) {
        Log.println((int)type, (String)tag, (String)msg);
    }

    private static String addLeftBorder(String msg) {
        String[] lines;
        if (!sLogBorderSwitch) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = msg.split(LINE_SEP)) {
            sb.append(LEFT_BORDER).append(line).append(LINE_SEP);
        }
        return sb.toString();
    }

    private static void print2File(int type, final String tag, String msg) {
        Date now = new Date(System.currentTimeMillis());
        String format = FORMAT.format(now);
        String date = format.substring(0, 5);
        String time = format.substring(6);
        final String fullPath = (dir == null ? defaultDir : dir) + date + ".txt";
        if (!LogUtils.createOrExistsFile(fullPath)) {
            Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(time).append(T[type - 2]).append("/").append(tag).append(msg).append(LINE_SEP);
        final String content = sb.toString();
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(fullPath, true));
                    bw.write(content);
                    Log.d((String)tag, (String)("log to " + fullPath + " success!"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!LogUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        sLogSwitch = true;
        sLog2ConsoleSwitch = true;
        sGlobalTag = null;
        sTagIsSpace = true;
        sLogHeadSwitch = true;
        sLog2FileSwitch = false;
        sLogBorderSwitch = true;
        sConsoleFilter = 2;
        sFileFilter = 2;
        FILE_SEP = System.getProperty("file.separator");
        LINE_SEP = System.getProperty("line.separator");
        FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS ", Locale.getDefault());
    }

    public static class Builder {
        public Builder() {
            if (defaultDir != null) {
                return;
            }
            if ("mounted".equals(Environment.getExternalStorageState()) && Utils.getContext().getExternalCacheDir() != null) {
                defaultDir = Utils.getContext().getExternalCacheDir() + FILE_SEP + "log" + FILE_SEP;
            } else {
                defaultDir = Utils.getContext().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
            }
        }

        public Builder setLogSwitch(boolean logSwitch) {
            sLogSwitch = logSwitch;
            return this;
        }

        public Builder setConsoleSwitch(boolean consoleSwitch) {
            sLog2ConsoleSwitch = consoleSwitch;
            return this;
        }

        public Builder setGlobalTag(String tag) {
            if (LogUtils.isSpace(tag)) {
                sGlobalTag = "";
                sTagIsSpace = true;
            } else {
                sGlobalTag = tag;
                sTagIsSpace = false;
            }
            return this;
        }

        public Builder setLogHeadSwitch(boolean logHeadSwitch) {
            sLogHeadSwitch = logHeadSwitch;
            return this;
        }

        public Builder setLog2FileSwitch(boolean log2FileSwitch) {
            sLog2FileSwitch = log2FileSwitch;
            return this;
        }

        public Builder setDir(String dir) {
            if (LogUtils.isSpace(dir)) {
                dir = null;
            } else {
                dir = dir.endsWith(FILE_SEP) ? dir : dir + FILE_SEP;
            }
            return this;
        }

        public Builder setDir(File dir) {
            dir = dir == null ? null : dir.getAbsolutePath() + FILE_SEP;
            return this;
        }

        public Builder setBorderSwitch(boolean borderSwitch) {
            sLogBorderSwitch = borderSwitch;
            return this;
        }

        public Builder setConsoleFilter(int consoleFilter) {
            sConsoleFilter = consoleFilter;
            return this;
        }

        public Builder setFileFilter(int fileFilter) {
            sFileFilter = fileFilter;
            return this;
        }

        public String toString() {
            return "switch: " + sLogSwitch + LINE_SEP + "console: " + sLog2ConsoleSwitch + LINE_SEP + "tag: " + (sTagIsSpace ? LogUtils.NULL : sGlobalTag) + LINE_SEP + "head: " + sLogHeadSwitch + LINE_SEP + "file: " + sLog2FileSwitch + LINE_SEP + "dir: " + (dir == null ? defaultDir : dir) + LINE_SEP + "border: " + sLogBorderSwitch + LINE_SEP + "consoleFilter: " + T[sConsoleFilter - 2] + LINE_SEP + "fileFilter: " + T[sFileFilter - 2];
        }
    }
}

