/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.content.Intent;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.codvision.base.utils.third.thirdparty.LogUtils;
import com.codvision.base.utils.third.thirdparty.ToastUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public final class LocationUtils {
    private static OnLocationChangeListener mListener;
    private static MyLocationListener myLocationListener;
    private static LocationManager mLocationManager;
    private static final int CHECK_INTERVAL = 300000;

    private LocationUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isGpsEnabled() {
        LocationManager lm = (LocationManager)Utils.getContext().getSystemService("location");
        return lm.isProviderEnabled("gps");
    }

    public static boolean isNetworkEnabled() {
        LocationManager lm = (LocationManager)Utils.getContext().getSystemService("location");
        return lm.isProviderEnabled("network");
    }

    public static boolean isLocationEnabled() {
        LocationManager lm = (LocationManager)Utils.getContext().getSystemService("location");
        return lm.isProviderEnabled("network") || lm.isProviderEnabled("gps");
    }

    public static void openGpsSettings() {
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        intent.setFlags(0x10000000);
        Utils.getContext().startActivity(intent);
    }

    public static boolean register(long minTime, long minDistance, OnLocationChangeListener listener) {
        if (listener == null) {
            return false;
        }
        mLocationManager = (LocationManager)Utils.getContext().getSystemService("location");
        mListener = listener;
        if (!LocationUtils.isLocationEnabled()) {
            ToastUtils.showShortSafe("\u65e0\u6cd5\u5b9a\u4f4d\uff0c\u8bf7\u6253\u5f00\u5b9a\u4f4d\u670d\u52a1");
            return false;
        }
        String provider = mLocationManager.getBestProvider(LocationUtils.getCriteria(), true);
        Location location = mLocationManager.getLastKnownLocation(provider);
        if (location != null) {
            listener.getLastKnownLocation(location);
        }
        if (myLocationListener == null) {
            myLocationListener = new MyLocationListener();
        }
        mLocationManager.requestLocationUpdates(provider, minTime, (float)minDistance, (LocationListener)myLocationListener);
        return true;
    }

    public static void unregister() {
        if (mLocationManager != null) {
            if (myLocationListener != null) {
                mLocationManager.removeUpdates((LocationListener)myLocationListener);
                myLocationListener = null;
            }
            mLocationManager = null;
        }
    }

    private static Criteria getCriteria() {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(1);
        criteria.setSpeedRequired(false);
        criteria.setCostAllowed(false);
        criteria.setBearingRequired(false);
        criteria.setAltitudeRequired(false);
        criteria.setPowerRequirement(1);
        return criteria;
    }

    public static Address getAddress(double latitude, double longitude) {
        Geocoder geocoder = new Geocoder(Utils.getContext(), Locale.getDefault());
        try {
            List addresses = geocoder.getFromLocation(latitude, longitude, 1);
            if (addresses.size() > 0) {
                return (Address)addresses.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCountryName(double latitude, double longitude) {
        Address address = LocationUtils.getAddress(latitude, longitude);
        return address == null ? "unknown" : address.getCountryName();
    }

    public static String getLocality(double latitude, double longitude) {
        Address address = LocationUtils.getAddress(latitude, longitude);
        return address == null ? "unknown" : address.getLocality();
    }

    public static String getStreet(double latitude, double longitude) {
        Address address = LocationUtils.getAddress(latitude, longitude);
        return address == null ? "unknown" : address.getAddressLine(0);
    }

    public static boolean isBetterLocation(Location newLocation, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = newLocation.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 300000L;
        boolean isSignificantlyOlder = timeDelta < -300000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(newLocation.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = LocationUtils.isSameProvider(newLocation.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    public static boolean isBetterLocation(Location newLocation, Location currentBestLocation, int maxLowAccuracy) {
        if (currentBestLocation == null) {
            return true;
        }
        if (newLocation.getAccuracy() > (float)maxLowAccuracy) {
            return false;
        }
        return LocationUtils.isBetterLocation(newLocation, currentBestLocation);
    }

    public static boolean isSameProvider(String provider0, String provider1) {
        if (provider0 == null) {
            return provider1 == null;
        }
        return provider0.equals(provider1);
    }

    public static interface OnLocationChangeListener {
        public void getLastKnownLocation(Location var1);

        public void onLocationChanged(Location var1);

        public void onStatusChanged(String var1, int var2, Bundle var3);
    }

    private static class MyLocationListener
    implements LocationListener {
        private MyLocationListener() {
        }

        public void onLocationChanged(Location location) {
            if (mListener != null) {
                mListener.onLocationChanged(location);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (mListener != null) {
                mListener.onStatusChanged(provider, status, extras);
            }
            switch (status) {
                case 2: {
                    LogUtils.d("onStatusChanged", "\u5f53\u524dGPS\u72b6\u6001\u4e3a\u53ef\u89c1\u72b6\u6001");
                    break;
                }
                case 0: {
                    LogUtils.d("onStatusChanged", "\u5f53\u524dGPS\u72b6\u6001\u4e3a\u670d\u52a1\u533a\u5916\u72b6\u6001");
                    break;
                }
                case 1: {
                    LogUtils.d("onStatusChanged", "\u5f53\u524dGPS\u72b6\u6001\u4e3a\u6682\u505c\u670d\u52a1\u72b6\u6001");
                    break;
                }
            }
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    }
}

