/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import com.codvision.base.utils.third.thirdparty.FileUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.File;

public final class IntentUtils {
    private IntentUtils() {
        throw new UnsupportedOperationException("u can't fuck me...");
    }

    public static Intent getInstallAppIntent(String filePath, String authority) {
        return IntentUtils.getInstallAppIntent(FileUtils.getFileByPath(filePath), authority);
    }

    public static Intent getInstallAppIntent(File file, String authority) {
        Uri data;
        if (file == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT < 24) {
            data = Uri.fromFile((File)file);
        } else {
            intent.setFlags(1);
            data = FileProvider.getUriForFile((Context)Utils.getContext(), (String)authority, (File)file);
        }
        intent.setDataAndType(data, type);
        return intent.addFlags(0x10000000);
    }

    public static Intent getUninstallAppIntent(String packageName) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return intent.addFlags(0x10000000);
    }

    public static Intent getLaunchAppIntent(String packageName) {
        return Utils.getContext().getPackageManager().getLaunchIntentForPackage(packageName);
    }

    public static Intent getAppDetailsSettingsIntent(String packageName) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return intent.addFlags(0x10000000);
    }

    public static Intent getShareTextIntent(String content) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", content);
        return intent.setFlags(0x10000000);
    }

    public static Intent getShareImageIntent(String content, String imagePath) {
        return IntentUtils.getShareImageIntent(content, FileUtils.getFileByPath(imagePath));
    }

    public static Intent getShareImageIntent(String content, File image) {
        if (!FileUtils.isFileExists(image)) {
            return null;
        }
        return IntentUtils.getShareImageIntent(content, Uri.fromFile((File)image));
    }

    public static Intent getShareImageIntent(String content, Uri uri) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        intent.setType("image/*");
        return intent.setFlags(0x10000000);
    }

    public static Intent getComponentIntent(String packageName, String className) {
        return IntentUtils.getComponentIntent(packageName, className, null);
    }

    public static Intent getComponentIntent(String packageName, String className, Bundle bundle) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        ComponentName cn = new ComponentName(packageName, className);
        intent.setComponent(cn);
        return intent.addFlags(0x10000000);
    }

    public static Intent getShutdownIntent() {
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        return intent.addFlags(0x10000000);
    }

    public static Intent getDialIntent(String phoneNumber) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber)));
        return intent.addFlags(0x10000000);
    }

    public static Intent getCallIntent(String phoneNumber) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber)));
        return intent.addFlags(0x10000000);
    }

    public static Intent getSendSmsIntent(String phoneNumber, String content) {
        Uri uri = Uri.parse((String)("smsto:" + phoneNumber));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", content);
        return intent.addFlags(0x10000000);
    }

    public static Intent getCaptureIntent(Uri outUri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)outUri);
        return intent.addFlags(0x10000001);
    }
}

