/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import com.codvision.base.utils.third.thirdparty.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FragmentUtils {
    private static final int TYPE_ADD_FRAGMENT = 1;
    private static final int TYPE_REMOVE_FRAGMENT = 2;
    private static final int TYPE_REMOVE_TO_FRAGMENT = 4;
    private static final int TYPE_REPLACE_FRAGMENT = 8;
    private static final int TYPE_POP_ADD_FRAGMENT = 16;
    private static final int TYPE_HIDE_FRAGMENT = 32;
    private static final int TYPE_SHOW_FRAGMENT = 64;
    private static final int TYPE_HIDE_SHOW_FRAGMENT = 128;
    private static final String ARGS_ID = "args_id";
    private static final String ARGS_IS_HIDE = "args_is_hide";
    private static final String ARGS_IS_ADD_STACK = "args_is_add_stack";

    private FragmentUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Fragment addFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId) {
        return FragmentUtils.addFragment(fragmentManager, fragment, containerId, false);
    }

    public static Fragment addFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId, boolean isHide) {
        return FragmentUtils.addFragment(fragmentManager, fragment, containerId, isHide, false);
    }

    public static Fragment addFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId, boolean isHide, boolean isAddStack) {
        FragmentUtils.putArgs(fragment, new Args(containerId, isHide, isAddStack));
        return FragmentUtils.operateFragment(fragmentManager, null, fragment, 1, new SharedElement[0]);
    }

    public static Fragment addFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId, boolean isHide, boolean isAddStack, SharedElement ... sharedElement) {
        FragmentUtils.putArgs(fragment, new Args(containerId, isHide, isAddStack));
        return FragmentUtils.operateFragment(fragmentManager, null, fragment, 1, sharedElement);
    }

    public static Fragment hideAddFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment hideFragment, @NonNull Fragment addFragment, @IdRes int containerId, boolean isHide, boolean isAddStack, SharedElement ... sharedElement) {
        FragmentUtils.putArgs(addFragment, new Args(containerId, isHide, isAddStack));
        return FragmentUtils.operateFragment(fragmentManager, hideFragment, addFragment, 1, sharedElement);
    }

    public static Fragment addFragments(@NonNull FragmentManager fragmentManager, @NonNull List<Fragment> fragments, @IdRes int containerId, int showIndex) {
        int size = fragments.size();
        for (int i = 0; i < size; ++i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            FragmentUtils.addFragment(fragmentManager, fragment, containerId, showIndex != i, false);
        }
        return fragments.get(showIndex);
    }

    public static Fragment addFragments(@NonNull FragmentManager fragmentManager, @NonNull List<Fragment> fragments, @IdRes int containerId, int showIndex, List<SharedElement> ... lists) {
        int size = fragments.size();
        for (int i = 0; i < size; ++i) {
            Fragment fragment = fragments.get(i);
            List<SharedElement> list = lists[i];
            if (fragment == null || list == null) continue;
            FragmentUtils.putArgs(fragment, new Args(containerId, showIndex != i, false));
            return FragmentUtils.operateFragment(fragmentManager, null, fragment, 1, list.toArray(new SharedElement[0]));
        }
        return fragments.get(showIndex);
    }

    public static void removeFragment(@NonNull Fragment fragment) {
        FragmentUtils.operateFragment(fragment.getFragmentManager(), null, fragment, 2, new SharedElement[0]);
    }

    public static void removeToFragment(@NonNull Fragment fragment, boolean isIncludeSelf) {
        FragmentUtils.operateFragment(fragment.getFragmentManager(), (Fragment)(isIncludeSelf ? fragment : null), fragment, 4, new SharedElement[0]);
    }

    public static void removeFragments(@NonNull FragmentManager fragmentManager) {
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        if (fragments.isEmpty()) {
            return;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            FragmentUtils.removeFragment(fragment);
        }
    }

    public static void removeAllFragments(@NonNull FragmentManager fragmentManager) {
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        if (fragments.isEmpty()) {
            return;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            FragmentUtils.removeAllFragments(fragment.getChildFragmentManager());
            FragmentUtils.removeFragment(fragment);
        }
    }

    public static Fragment replaceFragment(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, boolean isAddStack) {
        if (srcFragment.getArguments() == null) {
            return null;
        }
        int containerId = srcFragment.getArguments().getInt(ARGS_ID);
        if (containerId == 0) {
            return null;
        }
        return FragmentUtils.replaceFragment(srcFragment.getFragmentManager(), destFragment, containerId, isAddStack);
    }

    public static Fragment replaceFragment(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, boolean isAddStack, SharedElement ... sharedElement) {
        if (srcFragment.getArguments() == null) {
            return null;
        }
        int containerId = srcFragment.getArguments().getInt(ARGS_ID);
        if (containerId == 0) {
            return null;
        }
        return FragmentUtils.replaceFragment(srcFragment.getFragmentManager(), destFragment, containerId, isAddStack, sharedElement);
    }

    public static Fragment replaceFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack) {
        FragmentUtils.putArgs(fragment, new Args(containerId, false, isAddStack));
        return FragmentUtils.operateFragment(fragmentManager, null, fragment, 8, new SharedElement[0]);
    }

    public static Fragment replaceFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack, SharedElement ... sharedElement) {
        FragmentUtils.putArgs(fragment, new Args(containerId, false, isAddStack));
        return FragmentUtils.operateFragment(fragmentManager, null, fragment, 8, sharedElement);
    }

    public static boolean popFragment(@NonNull FragmentManager fragmentManager) {
        return fragmentManager.popBackStackImmediate();
    }

    public static boolean popToFragment(@NonNull FragmentManager fragmentManager, Class<? extends Fragment> fragmentClass, boolean isIncludeSelf) {
        return fragmentManager.popBackStackImmediate(fragmentClass.getName(), isIncludeSelf ? 1 : 0);
    }

    public static void popFragments(@NonNull FragmentManager fragmentManager) {
        while (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStackImmediate();
        }
    }

    public static void popAllFragments(@NonNull FragmentManager fragmentManager) {
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        if (fragments.isEmpty()) {
            return;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            FragmentUtils.popAllFragments(fragment.getChildFragmentManager());
        }
        while (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStackImmediate();
        }
    }

    public static Fragment popAddFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack) {
        FragmentUtils.putArgs(fragment, new Args(containerId, false, isAddStack));
        return FragmentUtils.operateFragment(fragmentManager, null, fragment, 16, new SharedElement[0]);
    }

    public static Fragment popAddFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack, SharedElement ... sharedElements) {
        FragmentUtils.putArgs(fragment, new Args(containerId, false, isAddStack));
        return FragmentUtils.operateFragment(fragmentManager, null, fragment, 16, sharedElements);
    }

    public static Fragment hideFragment(@NonNull Fragment fragment) {
        Args args = FragmentUtils.getArgs(fragment);
        if (args != null) {
            FragmentUtils.putArgs(fragment, new Args(args.id, true, args.isAddStack));
        }
        return FragmentUtils.operateFragment(fragment.getFragmentManager(), null, fragment, 32, new SharedElement[0]);
    }

    public static void hideFragments(@NonNull FragmentManager fragmentManager) {
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        if (fragments.isEmpty()) {
            return;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            FragmentUtils.hideFragment(fragment);
        }
    }

    public static Fragment showFragment(@NonNull Fragment fragment) {
        Args args = FragmentUtils.getArgs(fragment);
        if (args != null) {
            FragmentUtils.putArgs(fragment, new Args(args.id, false, args.isAddStack));
        }
        return FragmentUtils.operateFragment(fragment.getFragmentManager(), null, fragment, 64, new SharedElement[0]);
    }

    public static Fragment hideAllShowFragment(@NonNull Fragment fragment) {
        FragmentUtils.hideFragments(fragment.getFragmentManager());
        return FragmentUtils.operateFragment(fragment.getFragmentManager(), null, fragment, 64, new SharedElement[0]);
    }

    public static Fragment hideShowFragment(@NonNull Fragment hideFragment, @NonNull Fragment showFragment) {
        Args args = FragmentUtils.getArgs(hideFragment);
        if (args != null) {
            FragmentUtils.putArgs(hideFragment, new Args(args.id, true, args.isAddStack));
        }
        if ((args = FragmentUtils.getArgs(showFragment)) != null) {
            FragmentUtils.putArgs(showFragment, new Args(args.id, false, args.isAddStack));
        }
        return FragmentUtils.operateFragment(showFragment.getFragmentManager(), hideFragment, showFragment, 128, new SharedElement[0]);
    }

    private static void putArgs(@NonNull Fragment fragment, Args args) {
        Bundle bundle = fragment.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
            fragment.setArguments(bundle);
        }
        bundle.putInt(ARGS_ID, args.id);
        bundle.putBoolean(ARGS_IS_HIDE, args.isHide);
        bundle.putBoolean(ARGS_IS_ADD_STACK, args.isAddStack);
    }

    private static Args getArgs(@NonNull Fragment fragment) {
        Bundle bundle = fragment.getArguments();
        if (bundle == null || bundle.getInt(ARGS_ID) == 0) {
            return null;
        }
        return new Args(bundle.getInt(ARGS_ID), bundle.getBoolean(ARGS_IS_HIDE), bundle.getBoolean(ARGS_IS_ADD_STACK));
    }

    private static Fragment operateFragment(@NonNull FragmentManager fragmentManager, Fragment srcFragment, @NonNull Fragment destFragment, int type, SharedElement ... sharedElements) {
        if (srcFragment == destFragment) {
            return null;
        }
        if (srcFragment != null && srcFragment.isRemoving()) {
            LogUtils.e(srcFragment.getClass().getName() + " is isRemoving");
            return null;
        }
        String name = destFragment.getClass().getName();
        Bundle args = destFragment.getArguments();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        if (sharedElements == null || sharedElements.length == 0) {
            ft.setTransition(4097);
        } else {
            for (SharedElement element : sharedElements) {
                ft.addSharedElement(element.sharedElement, element.name);
            }
        }
        block0 : switch (type) {
            case 1: {
                if (srcFragment != null) {
                    ft.hide(srcFragment);
                }
                ft.add(args.getInt(ARGS_ID), destFragment, name);
                if (args.getBoolean(ARGS_IS_HIDE)) {
                    ft.hide(destFragment);
                }
                if (!args.getBoolean(ARGS_IS_ADD_STACK)) break;
                ft.addToBackStack(name);
                break;
            }
            case 2: {
                ft.remove(destFragment);
                break;
            }
            case 4: {
                List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
                for (int i = fragments.size() - 1; i >= 0; --i) {
                    Fragment fragment = fragments.get(i);
                    if (fragment == destFragment) {
                        if (srcFragment == null) break block0;
                        ft.remove(fragment);
                        break block0;
                    }
                    ft.remove(fragment);
                }
                break;
            }
            case 8: {
                ft.replace(args.getInt(ARGS_ID), destFragment, name);
                if (!args.getBoolean(ARGS_IS_ADD_STACK)) break;
                ft.addToBackStack(name);
                break;
            }
            case 16: {
                FragmentUtils.popFragment(fragmentManager);
                ft.add(args.getInt(ARGS_ID), destFragment, name);
                if (!args.getBoolean(ARGS_IS_ADD_STACK)) break;
                ft.addToBackStack(name);
                break;
            }
            case 32: {
                ft.hide(destFragment);
                break;
            }
            case 64: {
                ft.show(destFragment);
                break;
            }
            case 128: {
                ft.hide(srcFragment).show(destFragment);
                break;
            }
        }
        ft.commitAllowingStateLoss();
        return destFragment;
    }

    public static Fragment getLastAddFragment(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getLastAddFragmentIsInStack(fragmentManager, false);
    }

    public static Fragment getLastAddFragmentInStack(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getLastAddFragmentIsInStack(fragmentManager, true);
    }

    private static Fragment getLastAddFragmentIsInStack(@NonNull FragmentManager fragmentManager, boolean isInStack) {
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        if (fragments.isEmpty()) {
            return null;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            if (isInStack) {
                if (!fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
                return fragment;
            }
            return fragment;
        }
        return null;
    }

    public static Fragment getTopShowFragment(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getTopShowFragmentIsInStack(fragmentManager, null, false);
    }

    public static Fragment getTopShowFragmentInStack(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getTopShowFragmentIsInStack(fragmentManager, null, true);
    }

    private static Fragment getTopShowFragmentIsInStack(@NonNull FragmentManager fragmentManager, Fragment parentFragment, boolean isInStack) {
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        if (fragments.isEmpty()) {
            return parentFragment;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null || !fragment.isResumed() || !fragment.isVisible() || !fragment.getUserVisibleHint()) continue;
            if (isInStack) {
                if (!fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
                return FragmentUtils.getTopShowFragmentIsInStack(fragment.getChildFragmentManager(), fragment, true);
            }
            return FragmentUtils.getTopShowFragmentIsInStack(fragment.getChildFragmentManager(), fragment, false);
        }
        return parentFragment;
    }

    public static List<Fragment> getFragments(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getFragmentsIsInStack(fragmentManager, false);
    }

    public static List<Fragment> getFragmentsInStack(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getFragmentsIsInStack(fragmentManager, true);
    }

    private static List<Fragment> getFragmentsIsInStack(@NonNull FragmentManager fragmentManager, boolean isInStack) {
        List fragments = fragmentManager.getFragments();
        if (fragments == null || fragments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = (Fragment)fragments.get(i);
            if (fragment == null) continue;
            if (isInStack) {
                if (!fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
                result.add(fragment);
                continue;
            }
            result.add(fragment);
        }
        return result;
    }

    public static List<FragmentNode> getAllFragments(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getAllFragmentsIsInStack(fragmentManager, new ArrayList<FragmentNode>(), false);
    }

    public static List<FragmentNode> getAllFragmentsInStack(@NonNull FragmentManager fragmentManager) {
        return FragmentUtils.getAllFragmentsIsInStack(fragmentManager, new ArrayList<FragmentNode>(), true);
    }

    private static List<FragmentNode> getAllFragmentsIsInStack(@NonNull FragmentManager fragmentManager, List<FragmentNode> result, boolean isInStack) {
        List fragments = fragmentManager.getFragments();
        if (fragments == null || fragments.isEmpty()) {
            return Collections.emptyList();
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = (Fragment)fragments.get(i);
            if (fragment == null) continue;
            if (isInStack) {
                if (!fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
                result.add(new FragmentNode(fragment, FragmentUtils.getAllFragmentsIsInStack(fragment.getChildFragmentManager(), new ArrayList<FragmentNode>(), true)));
                continue;
            }
            result.add(new FragmentNode(fragment, FragmentUtils.getAllFragmentsIsInStack(fragment.getChildFragmentManager(), new ArrayList<FragmentNode>(), false)));
        }
        return result;
    }

    public static Fragment getPreFragment(@NonNull Fragment destFragment) {
        FragmentManager fragmentManager = destFragment.getFragmentManager();
        if (fragmentManager == null) {
            return null;
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        boolean flag = false;
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (flag && fragment != null) {
                return fragment;
            }
            if (fragment != destFragment) continue;
            flag = true;
        }
        return null;
    }

    public static Fragment findFragment(@NonNull FragmentManager fragmentManager, Class<? extends Fragment> fragmentClass) {
        List<Fragment> fragments = FragmentUtils.getFragments(fragmentManager);
        if (fragments.isEmpty()) {
            return null;
        }
        return fragmentManager.findFragmentByTag(fragmentClass.getName());
    }

    public static boolean dispatchBackPress(@NonNull Fragment fragment) {
        return FragmentUtils.dispatchBackPress(fragment.getFragmentManager());
    }

    public static boolean dispatchBackPress(@NonNull FragmentManager fragmentManager) {
        List fragments = fragmentManager.getFragments();
        if (fragments == null || fragments.isEmpty()) {
            return false;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = (Fragment)fragments.get(i);
            if (fragment == null || !fragment.isResumed() || !fragment.isVisible() || !fragment.getUserVisibleHint() || !(fragment instanceof OnBackClickListener) || !((OnBackClickListener)fragment).onBackClick()) continue;
            return true;
        }
        return false;
    }

    public static void setBackgroundColor(@NonNull Fragment fragment, @ColorInt int color) {
        View view = fragment.getView();
        if (view != null) {
            view.setBackgroundColor(color);
        }
    }

    public static void setBackgroundResource(@NonNull Fragment fragment, @DrawableRes int resId) {
        View view = fragment.getView();
        if (view != null) {
            view.setBackgroundResource(resId);
        }
    }

    public static void setBackground(@NonNull Fragment fragment, Drawable background) {
        View view = fragment.getView();
        if (view != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                view.setBackground(background);
            } else {
                view.setBackgroundDrawable(background);
            }
        }
    }

    public static interface OnBackClickListener {
        public boolean onBackClick();
    }

    static class FragmentNode {
        Fragment fragment;
        List<FragmentNode> next;

        public FragmentNode(Fragment fragment, List<FragmentNode> next) {
            this.fragment = fragment;
            this.next = next;
        }

        public String toString() {
            return this.fragment.getClass().getSimpleName() + "->" + (this.next == null || this.next.isEmpty() ? "no child" : this.next.toString());
        }
    }

    public static class SharedElement {
        View sharedElement;
        String name;

        public SharedElement(View sharedElement, String name) {
            this.sharedElement = sharedElement;
            this.name = name;
        }
    }

    static class Args {
        int id;
        boolean isHide;
        boolean isAddStack;

        Args(int id2, boolean isHide, boolean isAddStack) {
            this.id = id2;
            this.isHide = isHide;
            this.isAddStack = isAddStack;
        }
    }
}

