/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.os.Build;
import android.text.Html;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class EncodeUtils {
    private EncodeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String urlEncode(String input) {
        return EncodeUtils.urlEncode(input, "UTF-8");
    }

    public static String urlEncode(String input, String charset) {
        try {
            return URLEncoder.encode(input, charset);
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static String urlDecode(String input) {
        return EncodeUtils.urlDecode(input, "UTF-8");
    }

    public static String urlDecode(String input, String charset) {
        try {
            return URLDecoder.decode(input, charset);
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static byte[] base64Encode(String input) {
        return EncodeUtils.base64Encode(input.getBytes());
    }

    public static byte[] base64Encode(byte[] input) {
        return Base64.encode((byte[])input, (int)2);
    }

    public static String base64Encode2String(byte[] input) {
        return Base64.encodeToString((byte[])input, (int)2);
    }

    public static byte[] base64Decode(String input) {
        return Base64.decode((String)input, (int)2);
    }

    public static byte[] base64Decode(byte[] input) {
        return Base64.decode((byte[])input, (int)2);
    }

    public static byte[] base64UrlSafeEncode(String input) {
        return Base64.encode((byte[])input.getBytes(), (int)8);
    }

    public static String htmlEncode(CharSequence input) {
        if (Build.VERSION.SDK_INT >= 16) {
            return Html.escapeHtml((CharSequence)input);
        }
        StringBuilder out = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                char d;
                if (c >= '\udc00' || i + 1 >= len || (d = input.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                ++i;
                int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                out.append("&#").append(codepoint).append(";");
                continue;
            }
            if (c > '~' || c < ' ') {
                out.append("&#").append((int)c).append(";");
                continue;
            }
            if (c == ' ') {
                while (i + 1 < len && input.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    ++i;
                }
                out.append(' ');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static CharSequence htmlDecode(String input) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)input, (int)0);
        }
        return Html.fromHtml((String)input);
    }
}

