/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Intent;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import com.codvision.base.utils.third.thirdparty.ShellUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public final class DeviceUtils {
    private DeviceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    public static int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID() {
        return Settings.Secure.getString((ContentResolver)Utils.getContext().getContentResolver(), (String)"android_id");
    }

    public static String getMacAddress() {
        String macAddress = DeviceUtils.getMacAddressByWifiInfo();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByNetworkInterface();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByFile();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        return "please open wifi";
    }

    @SuppressLint(value={"HardwareIds"})
    private static String getMacAddressByWifiInfo() {
        try {
            WifiInfo info;
            WifiManager wifi = (WifiManager)Utils.getContext().getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                return info.getMacAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ni : nis) {
                byte[] macBytes;
                if (!ni.getName().equalsIgnoreCase("wlan0") || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02x:", b));
                }
                return res1.deleteCharAt(res1.length() - 1).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByFile() {
        String name;
        ShellUtils.CommandResult result = ShellUtils.execCmd("getprop wifi.interface", false);
        if (result.result == 0 && (name = result.successMsg) != null) {
            result = ShellUtils.execCmd("cat /sys/class/net/" + name + "/address", false);
            if (result.result == 0 && result.successMsg != null) {
                return result.successMsg;
            }
        }
        return "02:00:00:00:00:00";
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        String model = Build.MODEL;
        model = model != null ? model.trim().replaceAll("\\s*", "") : "";
        return model;
    }

    public static void shutdown() {
        ShellUtils.execCmd("reboot -p", true);
        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        intent.setFlags(0x10000000);
        Utils.getContext().startActivity(intent);
    }

    public static void reboot() {
        ShellUtils.execCmd("reboot", true);
        Intent intent = new Intent("android.intent.action.REBOOT");
        intent.putExtra("nowait", 1);
        intent.putExtra("interval", 1);
        intent.putExtra("window", 0);
        Utils.getContext().sendBroadcast(intent);
    }

    public static void reboot(String reason) {
        PowerManager mPowerManager = (PowerManager)Utils.getContext().getSystemService("power");
        try {
            mPowerManager.reboot(reason);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reboot2Recovery() {
        ShellUtils.execCmd("reboot recovery", true);
    }

    public static void reboot2Bootloader() {
        ShellUtils.execCmd("reboot bootloader", true);
    }
}

