/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import com.codvision.base.utils.third.thirdparty.CloseUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class CrashUtils
implements Thread.UncaughtExceptionHandler {
    private static volatile CrashUtils mInstance;
    private Thread.UncaughtExceptionHandler mHandler;
    private boolean mInitialized;
    private String crashDir;
    private String versionName;
    private int versionCode;

    private CrashUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CrashUtils getInstance() {
        if (mInstance != null) return mInstance;
        Class<CrashUtils> clazz = CrashUtils.class;
        synchronized (CrashUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new CrashUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public boolean init() {
        File baseCache;
        if (this.mInitialized) {
            return true;
        }
        if ("mounted".equals(Environment.getExternalStorageState())) {
            baseCache = Utils.getContext().getExternalCacheDir();
            if (baseCache == null) {
                return false;
            }
            this.crashDir = baseCache.getPath() + File.separator + "crash" + File.separator;
        } else {
            baseCache = Utils.getContext().getCacheDir();
            if (baseCache == null) {
                return false;
            }
            this.crashDir = baseCache.getPath() + File.separator + "crash" + File.separator;
        }
        try {
            PackageInfo pi = Utils.getContext().getPackageManager().getPackageInfo(Utils.getContext().getPackageName(), 0);
            this.versionName = pi.versionName;
            this.versionCode = pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        this.mHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mInitialized = true;
        return true;
    }

    @Override
    public void uncaughtException(Thread thread, final Throwable throwable) {
        String now = new SimpleDateFormat("yyMMdd HH-mm-ss", Locale.getDefault()).format(new Date());
        final String fullPath = this.crashDir + now + ".txt";
        if (!CrashUtils.createOrExistsFile(fullPath)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(new FileWriter(fullPath, false));
                    pw.write(CrashUtils.this.getCrashHead());
                    throwable.printStackTrace(pw);
                    for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
                        cause.printStackTrace(pw);
                    }
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable2) {
                        CloseUtils.closeIO(pw);
                        throw throwable2;
                    }
                    CloseUtils.closeIO(pw);
                }
                CloseUtils.closeIO(pw);
            }
        }).start();
        if (this.mHandler != null) {
            this.mHandler.uncaughtException(thread, throwable);
        }
    }

    private String getCrashHead() {
        return "\n************* Crash Log Head ****************\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nBaseApplication VersionName    : " + this.versionName + "\nBaseApplication VersionCode    : " + this.versionCode + "\n************* Crash Log Head ****************\n\n";
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!CrashUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }
}

