/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import com.codvision.base.utils.third.thirdparty.Utils;

public final class ClipboardUtils {
    private ClipboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void copyText(CharSequence text) {
        ClipboardManager clipboard = (ClipboardManager)Utils.getContext().getSystemService("clipboard");
        clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"text", (CharSequence)text));
    }

    public static CharSequence getText() {
        ClipboardManager clipboard = (ClipboardManager)Utils.getContext().getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).coerceToText(Utils.getContext());
        }
        return null;
    }

    public static void copyUri(Uri uri) {
        ClipboardManager clipboard = (ClipboardManager)Utils.getContext().getSystemService("clipboard");
        clipboard.setPrimaryClip(ClipData.newUri((ContentResolver)Utils.getContext().getContentResolver(), (CharSequence)"uri", (Uri)uri));
    }

    public static Uri getUri() {
        ClipboardManager clipboard = (ClipboardManager)Utils.getContext().getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getUri();
        }
        return null;
    }

    public static void copyIntent(Intent intent) {
        ClipboardManager clipboard = (ClipboardManager)Utils.getContext().getSystemService("clipboard");
        clipboard.setPrimaryClip(ClipData.newIntent((CharSequence)"intent", (Intent)intent));
    }

    public static Intent getIntent() {
        ClipboardManager clipboard = (ClipboardManager)Utils.getContext().getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getIntent();
        }
        return null;
    }
}

