/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.widget.DrawerLayout;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import java.lang.reflect.Method;

public class BarUtils {
    private static final int DEFAULT_STATUS_BAR_ALPHA = 112;
    private static final String FAKE_STATUS_BAR_VIEW_TAG = "FAKE_STATUS_BAR_VIEW_TAG";
    private static final String FAKE_TRANSLUCENT_VIEW_TAG = "FAKE_TRANSLUCENT_VIEW_TAG";
    private static final int TAG_KEY_HAVE_SET_OFFSET = -123;

    private BarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setColor(Activity activity, @ColorInt int color) {
        BarUtils.setColor(activity, color, 112);
    }

    public static void setColor(Activity activity, @ColorInt int color, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(BarUtils.calculateStatusColor(color, statusBarAlpha));
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
            View fakeStatusBarView = decorView.findViewWithTag((Object)FAKE_STATUS_BAR_VIEW_TAG);
            if (fakeStatusBarView != null) {
                if (fakeStatusBarView.getVisibility() == 8) {
                    fakeStatusBarView.setVisibility(0);
                }
                fakeStatusBarView.setBackgroundColor(BarUtils.calculateStatusColor(color, statusBarAlpha));
            } else {
                decorView.addView(BarUtils.createStatusBarView(activity, color, statusBarAlpha));
            }
            BarUtils.setRootView(activity);
        }
    }

    public static void setColorForSwipeBack(Activity activity, int color) {
        BarUtils.setColorForSwipeBack(activity, color, 112);
    }

    public static void setColorForSwipeBack(Activity activity, @ColorInt int color, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
            View rootView = contentView.getChildAt(0);
            int statusBarHeight = BarUtils.getStatusBarHeight((Context)activity);
            if (rootView != null && rootView instanceof CoordinatorLayout) {
                final CoordinatorLayout coordinatorLayout = (CoordinatorLayout)rootView;
                if (Build.VERSION.SDK_INT < 21) {
                    boolean isNeedRequestLayout;
                    coordinatorLayout.setFitsSystemWindows(false);
                    contentView.setBackgroundColor(BarUtils.calculateStatusColor(color, statusBarAlpha));
                    boolean bl = isNeedRequestLayout = contentView.getPaddingTop() < statusBarHeight;
                    if (isNeedRequestLayout) {
                        contentView.setPadding(0, statusBarHeight, 0, 0);
                        coordinatorLayout.post(new Runnable(){

                            @Override
                            public void run() {
                                coordinatorLayout.requestLayout();
                            }
                        });
                    }
                } else {
                    coordinatorLayout.setStatusBarBackgroundColor(BarUtils.calculateStatusColor(color, statusBarAlpha));
                }
            } else {
                contentView.setPadding(0, statusBarHeight, 0, 0);
                contentView.setBackgroundColor(BarUtils.calculateStatusColor(color, statusBarAlpha));
            }
            BarUtils.setTransparentForWindow(activity);
        }
    }

    public static void setColorNoTranslucent(Activity activity, @ColorInt int color) {
        BarUtils.setColor(activity, color, 0);
    }

    @Deprecated
    public static void setColorDiff(Activity activity, @ColorInt int color) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.transparentStatusBar(activity);
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View fakeStatusBarView = contentView.findViewWithTag((Object)FAKE_STATUS_BAR_VIEW_TAG);
        if (fakeStatusBarView != null) {
            if (fakeStatusBarView.getVisibility() == 8) {
                fakeStatusBarView.setVisibility(0);
            }
            fakeStatusBarView.setBackgroundColor(color);
        } else {
            contentView.addView(BarUtils.createStatusBarView(activity, color));
        }
        BarUtils.setRootView(activity);
    }

    public static void setTranslucent(Activity activity) {
        BarUtils.setTranslucent(activity, 112);
    }

    public static void setTranslucent(Activity activity, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.setTransparent(activity);
        BarUtils.addTranslucentView(activity, statusBarAlpha);
    }

    public static void setTranslucentForCoordinatorLayout(Activity activity, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.transparentStatusBar(activity);
        BarUtils.addTranslucentView(activity, statusBarAlpha);
    }

    public static void setTransparent(Activity activity) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.transparentStatusBar(activity);
        BarUtils.setRootView(activity);
    }

    @Deprecated
    public static void setTranslucentDiff(Activity activity) {
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            BarUtils.setRootView(activity);
        }
    }

    public static void setColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color) {
        BarUtils.setColorForDrawerLayout(activity, drawerLayout, color, 112);
    }

    public static void setColorNoTranslucentForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color) {
        BarUtils.setColorForDrawerLayout(activity, drawerLayout, color, 0);
    }

    public static void setColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
        ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
        View fakeStatusBarView = contentLayout.findViewWithTag((Object)FAKE_STATUS_BAR_VIEW_TAG);
        if (fakeStatusBarView != null) {
            if (fakeStatusBarView.getVisibility() == 8) {
                fakeStatusBarView.setVisibility(0);
            }
            fakeStatusBarView.setBackgroundColor(color);
        } else {
            contentLayout.addView(BarUtils.createStatusBarView(activity, color), 0);
        }
        if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
            contentLayout.getChildAt(1).setPadding(contentLayout.getPaddingLeft(), BarUtils.getStatusBarHeight((Context)activity) + contentLayout.getPaddingTop(), contentLayout.getPaddingRight(), contentLayout.getPaddingBottom());
        }
        BarUtils.setDrawerLayoutProperty(drawerLayout, contentLayout);
        BarUtils.addTranslucentView(activity, statusBarAlpha);
    }

    private static void setDrawerLayoutProperty(DrawerLayout drawerLayout, ViewGroup drawerLayoutContentLayout) {
        ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
        drawerLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setClipToPadding(true);
        drawer.setFitsSystemWindows(false);
    }

    @Deprecated
    public static void setColorForDrawerLayoutDiff(Activity activity, DrawerLayout drawerLayout, @ColorInt int color) {
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
            View fakeStatusBarView = contentLayout.findViewWithTag((Object)FAKE_STATUS_BAR_VIEW_TAG);
            if (fakeStatusBarView != null) {
                if (fakeStatusBarView.getVisibility() == 8) {
                    fakeStatusBarView.setVisibility(0);
                }
                fakeStatusBarView.setBackgroundColor(BarUtils.calculateStatusColor(color, 112));
            } else {
                contentLayout.addView(BarUtils.createStatusBarView(activity, color), 0);
            }
            if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
                contentLayout.getChildAt(1).setPadding(0, BarUtils.getStatusBarHeight((Context)activity), 0, 0);
            }
            BarUtils.setDrawerLayoutProperty(drawerLayout, contentLayout);
        }
    }

    public static void setTranslucentForDrawerLayout(Activity activity, DrawerLayout drawerLayout) {
        BarUtils.setTranslucentForDrawerLayout(activity, drawerLayout, 112);
    }

    public static void setTranslucentForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.setTransparentForDrawerLayout(activity, drawerLayout);
        BarUtils.addTranslucentView(activity, statusBarAlpha);
    }

    public static void setTransparentForDrawerLayout(Activity activity, DrawerLayout drawerLayout) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
        ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
        if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
            contentLayout.getChildAt(1).setPadding(0, BarUtils.getStatusBarHeight((Context)activity), 0, 0);
        }
        BarUtils.setDrawerLayoutProperty(drawerLayout, contentLayout);
    }

    @Deprecated
    public static void setTranslucentForDrawerLayoutDiff(Activity activity, DrawerLayout drawerLayout) {
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
            contentLayout.setFitsSystemWindows(true);
            contentLayout.setClipToPadding(true);
            ViewGroup vg = (ViewGroup)drawerLayout.getChildAt(1);
            vg.setFitsSystemWindows(false);
            drawerLayout.setFitsSystemWindows(false);
        }
    }

    public static void setTransparentForImageView(Activity activity, View needOffsetView) {
        BarUtils.setTranslucentForImageView(activity, 0, needOffsetView);
    }

    public static void setTranslucentForImageView(Activity activity, View needOffsetView) {
        BarUtils.setTranslucentForImageView(activity, 112, needOffsetView);
    }

    public static void setTranslucentForImageView(Activity activity, @IntRange(from=0L, to=255L) int statusBarAlpha, View needOffsetView) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.setTransparentForWindow(activity);
        BarUtils.addTranslucentView(activity, statusBarAlpha);
        if (needOffsetView != null) {
            Object haveSetOffset = needOffsetView.getTag(-123);
            if (haveSetOffset != null && ((Boolean)haveSetOffset).booleanValue()) {
                return;
            }
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)needOffsetView.getLayoutParams();
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin + BarUtils.getStatusBarHeight((Context)activity), layoutParams.rightMargin, layoutParams.bottomMargin);
            needOffsetView.setTag(-123, (Object)true);
        }
    }

    public static void setTranslucentForImageViewInFragment(Activity activity, View needOffsetView) {
        BarUtils.setTranslucentForImageViewInFragment(activity, 112, needOffsetView);
    }

    public static void setTransparentForImageViewInFragment(Activity activity, View needOffsetView) {
        BarUtils.setTranslucentForImageViewInFragment(activity, 0, needOffsetView);
    }

    public static void setTranslucentForImageViewInFragment(Activity activity, @IntRange(from=0L, to=255L) int statusBarAlpha, View needOffsetView) {
        BarUtils.setTranslucentForImageView(activity, statusBarAlpha, needOffsetView);
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            BarUtils.clearPreviousSetting(activity);
        }
    }

    public static void hideFakeStatusBarView(Activity activity) {
        View fakeTranslucentView;
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)FAKE_STATUS_BAR_VIEW_TAG);
        if (fakeStatusBarView != null) {
            fakeStatusBarView.setVisibility(8);
        }
        if ((fakeTranslucentView = decorView.findViewWithTag((Object)FAKE_TRANSLUCENT_VIEW_TAG)) != null) {
            fakeTranslucentView.setVisibility(8);
        }
    }

    @TargetApi(value=19)
    private static void clearPreviousSetting(Activity activity) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)FAKE_STATUS_BAR_VIEW_TAG);
        if (fakeStatusBarView != null) {
            decorView.removeView(fakeStatusBarView);
            ViewGroup rootView = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
            rootView.setPadding(0, 0, 0, 0);
        }
    }

    private static void addTranslucentView(Activity activity, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View fakeTranslucentView = contentView.findViewWithTag((Object)FAKE_TRANSLUCENT_VIEW_TAG);
        if (fakeTranslucentView != null) {
            if (fakeTranslucentView.getVisibility() == 8) {
                fakeTranslucentView.setVisibility(0);
            }
            fakeTranslucentView.setBackgroundColor(Color.argb((int)statusBarAlpha, (int)0, (int)0, (int)0));
        } else {
            contentView.addView(BarUtils.createTranslucentStatusBarView(activity, statusBarAlpha));
        }
    }

    private static View createStatusBarView(Activity activity, @ColorInt int color) {
        return BarUtils.createStatusBarView(activity, color, 0);
    }

    private static View createStatusBarView(Activity activity, @ColorInt int color, int alpha) {
        View statusBarView = new View((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, BarUtils.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(BarUtils.calculateStatusColor(color, alpha));
        statusBarView.setTag((Object)FAKE_STATUS_BAR_VIEW_TAG);
        return statusBarView;
    }

    private static void setRootView(Activity activity) {
        ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View childView = parent.getChildAt(i);
            if (!(childView instanceof ViewGroup)) continue;
            childView.setFitsSystemWindows(true);
            ((ViewGroup)childView).setClipToPadding(true);
        }
    }

    private static void setTransparentForWindow(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().setStatusBarColor(0);
            activity.getWindow().getDecorView().setSystemUiVisibility(1280);
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().setFlags(0x4000000, 0x4000000);
        }
    }

    @TargetApi(value=19)
    private static void transparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().addFlags(0x8000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
    }

    private static View createTranslucentStatusBarView(Activity activity, int alpha) {
        View statusBarView = new View((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, BarUtils.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
        statusBarView.setTag((Object)FAKE_TRANSLUCENT_VIEW_TAG);
        return statusBarView;
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    private static int calculateStatusColor(@ColorInt int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static void setTransparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            activity.getWindow().addFlags(0x8000000);
        }
    }

    public static void hideStatusBar(Activity activity) {
        activity.requestWindowFeature(1);
        activity.getWindow().setFlags(1024, 1024);
    }

    public static boolean isStatusBarExists(Activity activity) {
        WindowManager.LayoutParams params = activity.getWindow().getAttributes();
        return (params.flags & 0x400) != 1024;
    }

    public static int getActionBarHeight(Activity activity) {
        TypedValue tv = new TypedValue();
        if (activity.getTheme().resolveAttribute(16843499, tv, true)) {
            return TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)activity.getResources().getDisplayMetrics());
        }
        return 0;
    }

    public static void showNotificationBar(Context context, boolean isSettingPanel) {
        String methodName = Build.VERSION.SDK_INT <= 16 ? "expand" : (isSettingPanel ? "expandSettingsPanel" : "expandNotificationsPanel");
        BarUtils.invokePanels(context, methodName);
    }

    public static void hideNotificationBar(Context context) {
        String methodName = Build.VERSION.SDK_INT <= 16 ? "collapse" : "collapsePanels";
        BarUtils.invokePanels(context, methodName);
    }

    private static void invokePanels(Context context, String methodName) {
        try {
            Object service = context.getSystemService("statusbar");
            Class<?> statusBarManager = Class.forName("android.app.StatusBarManager");
            Method expand = statusBarManager.getMethod(methodName, new Class[0]);
            expand.invoke(service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

