/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import com.codvision.base.utils.third.thirdparty.CleanUtils;
import com.codvision.base.utils.third.thirdparty.EncryptUtils;
import com.codvision.base.utils.third.thirdparty.FileUtils;
import com.codvision.base.utils.third.thirdparty.IntentUtils;
import com.codvision.base.utils.third.thirdparty.LogUtils;
import com.codvision.base.utils.third.thirdparty.ProcessUtils;
import com.codvision.base.utils.third.thirdparty.ShellUtils;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class AppUtils {
    private AppUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isInstallApp(String packageName) {
        return !AppUtils.isSpace(packageName) && IntentUtils.getLaunchAppIntent(packageName) != null;
    }

    public static void installApp(String filePath, String authority) {
        AppUtils.installApp(FileUtils.getFileByPath(filePath), authority);
    }

    public static void installApp(File file, String authority) {
        if (!FileUtils.isFileExists(file)) {
            return;
        }
        Utils.getContext().startActivity(IntentUtils.getInstallAppIntent(file, authority));
    }

    public static void installApp(Activity activity, String filePath, String authority, int requestCode) {
        AppUtils.installApp(activity, FileUtils.getFileByPath(filePath), authority, requestCode);
    }

    public static void installApp(Activity activity, File file, String authority, int requestCode) {
        if (!FileUtils.isFileExists(file)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getInstallAppIntent(file, authority), requestCode);
    }

    public static boolean installAppSilent(String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (!FileUtils.isFileExists(file)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install " + filePath;
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(command, !AppUtils.isSystemApp(), true);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static void uninstallApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        Utils.getContext().startActivity(IntentUtils.getUninstallAppIntent(packageName));
    }

    public static void uninstallApp(Activity activity, String packageName, int requestCode) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getUninstallAppIntent(packageName), requestCode);
    }

    public static boolean uninstallAppSilent(String packageName, boolean isKeepData) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(command, !AppUtils.isSystemApp(), true);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static boolean isAppRoot() {
        ShellUtils.CommandResult result = ShellUtils.execCmd("echo root", true);
        if (result.result == 0) {
            return true;
        }
        if (result.errorMsg != null) {
            LogUtils.d("isAppRoot", result.errorMsg);
        }
        return false;
    }

    public static void launchApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        Utils.getContext().startActivity(IntentUtils.getLaunchAppIntent(packageName));
    }

    public static void launchApp(Activity activity, String packageName, int requestCode) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        activity.startActivityForResult(IntentUtils.getLaunchAppIntent(packageName), requestCode);
    }

    public static String getAppPackageName() {
        return Utils.getContext().getPackageName();
    }

    public static void getAppDetailsSettings() {
        AppUtils.getAppDetailsSettings(Utils.getContext().getPackageName());
    }

    public static void getAppDetailsSettings(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        Utils.getContext().startActivity(IntentUtils.getAppDetailsSettingsIntent(packageName));
    }

    public static String getAppName() {
        return AppUtils.getAppName(Utils.getContext().getPackageName());
    }

    public static String getAppName(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Drawable getAppIcon() {
        return AppUtils.getAppIcon(Utils.getContext().getPackageName());
    }

    public static Drawable getAppIcon(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppPath() {
        return AppUtils.getAppPath(Utils.getContext().getPackageName());
    }

    public static String getAppPath(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppVersionName() {
        return AppUtils.getAppVersionName(Utils.getContext().getPackageName());
    }

    public static String getAppVersionName(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppVersionCode() {
        return AppUtils.getAppVersionCode(Utils.getContext().getPackageName());
    }

    public static int getAppVersionCode(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return -1;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? -1 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isSystemApp() {
        return AppUtils.isSystemApp(Utils.getContext().getPackageName());
    }

    public static boolean isSystemApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAppDebug() {
        return AppUtils.isAppDebug(Utils.getContext().getPackageName());
    }

    public static boolean isAppDebug(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Signature[] getAppSignature() {
        return AppUtils.getAppSignature(Utils.getContext().getPackageName());
    }

    public static Signature[] getAppSignature(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 64);
            return pi == null ? null : pi.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppSignatureSHA1() {
        return AppUtils.getAppSignatureSHA1(Utils.getContext().getPackageName());
    }

    public static String getAppSignatureSHA1(String packageName) {
        Signature[] signature = AppUtils.getAppSignature(packageName);
        if (signature == null) {
            return null;
        }
        return EncryptUtils.encryptSHA1ToString(signature[0].toByteArray()).replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
    }

    public static boolean isAppForeground() {
        ActivityManager manager = (ActivityManager)Utils.getContext().getSystemService("activity");
        List info = manager.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.importance != 100) continue;
            return aInfo.processName.equals(Utils.getContext().getPackageName());
        }
        return false;
    }

    public static boolean isAppForeground(String packageName) {
        return !AppUtils.isSpace(packageName) && packageName.equals(ProcessUtils.getForegroundProcessName());
    }

    public static AppInfo getAppInfo() {
        return AppUtils.getAppInfo(Utils.getContext().getPackageName());
    }

    public static AppInfo getAppInfo(String packageName) {
        try {
            PackageManager pm = Utils.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return AppUtils.getBean(pm, pi);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static AppInfo getBean(PackageManager pm, PackageInfo pi) {
        if (pm == null || pi == null) {
            return null;
        }
        ApplicationInfo ai = pi.applicationInfo;
        String packageName = pi.packageName;
        String name = ai.loadLabel(pm).toString();
        Drawable icon = ai.loadIcon(pm);
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSystem = (1 & ai.flags) != 0;
        return new AppInfo(packageName, name, icon, packagePath, versionName, versionCode, isSystem);
    }

    public static List<AppInfo> getAppsInfo() {
        ArrayList<AppInfo> list = new ArrayList<AppInfo>();
        PackageManager pm = Utils.getContext().getPackageManager();
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo pi : installedPackages) {
            AppInfo ai = AppUtils.getBean(pm, pi);
            if (ai == null) continue;
            list.add(ai);
        }
        return list;
    }

    public static boolean cleanAppData(String ... dirPaths) {
        File[] dirs = new File[dirPaths.length];
        int i = 0;
        for (String dirPath : dirPaths) {
            dirs[i++] = new File(dirPath);
        }
        return AppUtils.cleanAppData(dirs);
    }

    public static boolean cleanAppData(File ... dirs) {
        boolean isSuccess = CleanUtils.cleanInternalCache();
        isSuccess &= CleanUtils.cleanInternalDbs();
        isSuccess &= CleanUtils.cleanInternalSP();
        isSuccess &= CleanUtils.cleanInternalFiles();
        isSuccess &= CleanUtils.cleanExternalCache();
        for (File dir : dirs) {
            isSuccess &= CleanUtils.cleanCustomCache(dir);
        }
        return isSuccess;
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class AppInfo {
        private String name;
        private Drawable icon;
        private String packageName;
        private String packagePath;
        private String versionName;
        private int versionCode;
        private boolean isSystem;

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public void setSystem(boolean isSystem) {
            this.isSystem = isSystem;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public AppInfo(String packageName, String name, Drawable icon, String packagePath, String versionName, int versionCode, boolean isSystem) {
            this.setName(name);
            this.setIcon(icon);
            this.setPackageName(packageName);
            this.setPackagePath(packagePath);
            this.setVersionName(versionName);
            this.setVersionCode(versionCode);
            this.setSystem(isSystem);
        }

        public String toString() {
            return "pkg name: " + this.getPackageName() + "\napp name: " + this.getName() + "\napp path: " + this.getPackagePath() + "\napp v name: " + this.getVersionName() + "\napp v code: " + this.getVersionCode() + "\nis system: " + this.isSystem();
        }
    }
}

