/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.third.thirdparty;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.util.ArrayMap;
import com.codvision.base.utils.third.thirdparty.Utils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;

public final class ActivityUtils {
    private ActivityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isActivityExists(String packageName, String className) {
        Intent intent = new Intent();
        intent.setClassName(packageName, className);
        return Utils.getContext().getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(Utils.getContext().getPackageManager()) != null && Utils.getContext().getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    public static void startActivity(Activity activity, Class<?> cls) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), cls.getName(), null);
    }

    public static void startActivity(Bundle extras, Activity activity, Class<?> cls) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), cls.getName(), null);
    }

    public static void startActivity(Activity activity, Class<?> cls, int enterAnim, int exitAnim) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), cls.getName(), null);
        activity.overridePendingTransition(enterAnim, exitAnim);
    }

    public static void startActivity(Bundle extras, Activity activity, Class<?> cls, int enterAnim, int exitAnim) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), cls.getName(), null);
        activity.overridePendingTransition(enterAnim, exitAnim);
    }

    public static void startActivity(Activity activity, Class<?> cls, Bundle options) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), cls.getName(), options);
    }

    public static void startActivity(Bundle extras, Activity activity, Class<?> cls, Bundle options) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), cls.getName(), options);
    }

    public static void startActivity(String pkg, String cls) {
        ActivityUtils.startActivity(Utils.getContext(), null, pkg, cls, null);
    }

    public static void startActivity(Bundle extras, String pkg, String cls) {
        ActivityUtils.startActivity(Utils.getContext(), extras, pkg, cls, extras);
    }

    public static void startActivity(String pkg, String cls, Bundle options) {
        ActivityUtils.startActivity(Utils.getContext(), null, pkg, cls, options);
    }

    public static void startActivity(Bundle extras, String pkg, String cls, Bundle options) {
        ActivityUtils.startActivity(Utils.getContext(), extras, pkg, cls, options);
    }

    private static void startActivity(Context context, Bundle extras, String pkg, String cls, Bundle options) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.setComponent(new ComponentName(pkg, cls));
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (options == null || Build.VERSION.SDK_INT < 16) {
            context.startActivity(intent);
        } else {
            context.startActivity(intent, options);
        }
    }

    public static String getLauncherActivity(String packageName) {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(0x10000000);
        PackageManager pm = Utils.getContext().getPackageManager();
        List info = pm.queryIntentActivities(intent, 0);
        for (ResolveInfo aInfo : info) {
            if (!aInfo.activityInfo.packageName.equals(packageName)) continue;
            return aInfo.activityInfo.name;
        }
        return "no " + packageName;
    }

    public static Activity getTopActivity() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            HashMap activities = null;
            activities = Build.VERSION.SDK_INT < 19 ? (HashMap)activitiesField.get(activityThread) : (ArrayMap)activitiesField.get(activityThread);
            for (Object activityRecord : activities.values()) {
                Class<?> activityRecordClass = activityRecord.getClass();
                Field pausedField = activityRecordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityRecord)) continue;
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                return (Activity)activityField.get(activityRecord);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

