/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.utils.file;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Files {
    public static final long K = 1024L;
    public static final long M = 0x100000L;
    public static final long G = 0x40000000L;

    public static MultipartBody filesToMultipartBody(List<File> files) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        for (File file : files) {
            String mime = Files.getMimeType(file);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)mime), (File)file);
            builder.addFormDataPart("file", file.getName(), requestBody);
        }
        builder.setType(MultipartBody.FORM);
        MultipartBody multipartBody = builder.build();
        return multipartBody;
    }

    public static List<MultipartBody.Part> filesToMultipartBodyParts(List<File> files) {
        ArrayList<MultipartBody.Part> parts = new ArrayList<MultipartBody.Part>(files.size());
        for (File file : files) {
            parts.add(Files.fileToMultipartBodyPart(file));
        }
        return parts;
    }

    public static MultipartBody.Part fileToMultipartBodyPart(File file) {
        String mime = Files.getMimeType(file);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)mime), (File)file);
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestBody);
        return part;
    }

    private static String getSuffix(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        String fileName = file.getName();
        if ("".equals(fileName) || fileName.endsWith(".")) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index + 1).toLowerCase(Locale.US);
        }
        return null;
    }

    public static String getMimeType(File file) {
        String suffix = Files.getSuffix(file);
        if (suffix == null) {
            return "file/*";
        }
        String type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(suffix);
        if (type != null || !type.isEmpty()) {
            return type;
        }
        return "file/*";
    }

    public static String parseMimeType(File file) {
        String fileName = file.getName();
        String type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(Files.getExtensionName(fileName));
        return null == type ? "file/*" : type;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static boolean openFile(File file, Context context) {
        Uri data;
        Intent in = new Intent("android.intent.action.VIEW");
        in.addCategory("android.intent.category.DEFAULT");
        if (Build.VERSION.SDK_INT >= 24) {
            data = FileProvider.getUriForFile((Context)context, (String)Files.parseFileProviderAuth(context), (File)file);
            in.addFlags(1);
        } else {
            data = Uri.fromFile((File)file);
        }
        in.addFlags(0x10000000);
        in.setDataAndType(data, Files.parseMimeType(file));
        if (Files.isIntentAvailable(context, in)) {
            context.startActivity(in);
            return true;
        }
        return false;
    }

    private static String parseFileProviderAuth(Context context) {
        return String.format("%s.fileprovider", context.getPackageName());
    }

    private static boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 1);
        return list.size() > 0;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme)) {
            Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            if (null != cursor) {
                int index;
                if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                    data = cursor.getString(index);
                }
                cursor.close();
            }
            if (data == null) {
                data = Files.getImageAbsolutePath(context, uri);
            }
        }
        return data;
    }

    public static String getImageAbsolutePath(Context context, Uri imageUri) {
        if (context == null || imageUri == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)imageUri)) {
            if (Files.isExternalStorageDocument(imageUri)) {
                String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (Files.isDownloadsDocument(imageUri)) {
                    String id = DocumentsContract.getDocumentId((Uri)imageUri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    return Files.getDataColumn(context, contentUri, null, null);
                }
                if (Files.isMediaDocument(imageUri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return Files.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(imageUri.getScheme())) {
                if (Files.isGooglePhotosUri(imageUri)) {
                    return imageUri.getLastPathSegment();
                }
                return Files.getDataColumn(context, imageUri, null, null);
            }
            if ("file".equalsIgnoreCase(imageUri.getScheme())) {
                return imageUri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow(column);
                String string = cursor.getString(index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static Uri getUriFromFile(Context context, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)context, (String)String.format("%s.fileprovider", context.getPackageName()), (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static double getFileSizeFormatM(File srcFile) {
        return (double)srcFile.length() / 1048576.0;
    }

    public static File createImageFile(Context context, String dirname) {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "DLD_" + timeStamp + "_";
        try {
            File dir = new File(context.getExternalFilesDir(Environment.DIRECTORY_PICTURES), dirname);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File image = File.createTempFile(imageFileName, ".jpg", dir);
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

