/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.services;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.codvision.base.BaseConst;
import com.codvision.base.services.TaskCenter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PacketService
extends Service {
    private static final String CHANNEL_ID = "100";
    private static final CharSequence CHANNEL_NAME = "PacketService";
    private static ThreadPoolExecutor poolExecutor;
    private static volatile boolean isDestroy;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = null;
            channel = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, 4);
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            manager.createNotificationChannel(channel);
            Notification notification = new Notification.Builder(this.getApplicationContext(), CHANNEL_ID).build();
            this.startForeground(1, notification);
        }
        return 3;
    }

    public void onCreate() {
        super.onCreate();
        poolExecutor = new ThreadPoolExecutor(BaseConst.MODULE_SIZE, BaseConst.MODULE_SIZE * 3 / 2, (long)BaseConst.PACKET_DURATION, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new Factory());
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.submit(new LoopRunnable());
    }

    public void onDestroy() {
        isDestroy = true;
        if (Build.VERSION.SDK_INT >= 26) {
            this.stopForeground(true);
        }
        super.onDestroy();
    }

    static {
        isDestroy = false;
    }

    private class LoopRunnable
    implements Runnable {
        private LoopRunnable() {
        }

        @Override
        public void run() {
            try {
                while (!isDestroy) {
                    TaskCenter.executeTasks(poolExecutor);
                    Thread.sleep(BaseConst.PACKET_DURATION);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class Factory
    implements ThreadFactory {
        private final AtomicInteger mCount = new AtomicInteger(1);

        Factory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new Thread(r, "PacketService  Task#" + this.mCount.getAndIncrement());
        }
    }
}

