/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.retrofit;

import com.codvision.base.retrofit.HttpExtInfoInterceptor;
import com.codvision.base.retrofit.IExtInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public final class RetrofitCenter {
    public static volatile String tokenValue;
    private static final Map<String, Retrofit> RETROFIT_MAP;
    public static final String URL_TAG = "REMOTE_URL";

    public static void init(String baseUrl, ClientConfig clientConfig) {
        RetrofitCenter.init(baseUrl, clientConfig, null, null);
    }

    public static void init(String baseUrl, ClientConfig clientConfig, List<Converter.Factory> converters, List<CallAdapter.Factory> callAdapters) {
        if (!RetrofitCenter.isInitRetrofit(baseUrl)) {
            Retrofit retrofit = RetrofitCenter.createRetrofit(baseUrl, RetrofitCenter.createHttpClient(clientConfig), converters, callAdapters);
            RETROFIT_MAP.put(baseUrl, retrofit);
        }
    }

    public static void init(String baseUrl) {
        RetrofitCenter.init(baseUrl, null);
    }

    public static void init(Class<?> clazz) {
        RetrofitCenter.init(RetrofitCenter.getBaseUrl(clazz), null);
    }

    private static String getBaseUrl(Class clazz) {
        try {
            Field url = clazz.getField(URL_TAG);
            url.setAccessible(true);
            return (String)url.get(clazz);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.getMessage();
            e.printStackTrace();
        }
        throw new RuntimeException("The class is not contains Field:REMOTE_URL");
    }

    public static boolean isInitRetrofit(String baseUrl) {
        return RETROFIT_MAP.get(baseUrl) != null;
    }

    public static boolean isInitRetrofit(Class<?> clazz) {
        return RetrofitCenter.isInitRetrofit(RetrofitCenter.getBaseUrl(clazz));
    }

    public static Retrofit getApi(String baseUrl) {
        Retrofit retrofit = RETROFIT_MAP.get(baseUrl);
        if (retrofit == null) {
            RetrofitCenter.init(baseUrl);
        }
        return retrofit;
    }

    public static <T> T getApi(Class<T> clazz) {
        return (T)RetrofitCenter.getApi(RetrofitCenter.getBaseUrl(clazz)).create(clazz);
    }

    private static Retrofit createRetrofit(String baseUrl) {
        return RetrofitCenter.createRetrofit(baseUrl, RetrofitCenter.createHttpClient(), null, null);
    }

    private static Retrofit createRetrofit(String baseUrl, OkHttpClient httpClient, List<Converter.Factory> converters, List<CallAdapter.Factory> callAdapters) {
        if (null == baseUrl) {
            throw new RuntimeException("The Required BaseUrl is null!");
        }
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(baseUrl);
        builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        if (null != callAdapters) {
            for (CallAdapter.Factory callAdapter : callAdapters) {
                builder.addCallAdapterFactory(callAdapter);
            }
        }
        builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        if (null != converters) {
            for (Converter.Factory converter : converters) {
                builder.addConverterFactory(converter);
            }
        }
        if (null == httpClient) {
            builder.client(RetrofitCenter.createHttpClient());
        } else {
            builder.client(httpClient);
        }
        return builder.build();
    }

    private static OkHttpClient createHttpClient() {
        ClientConfig clientConfig = new ClientConfig.Builder().build();
        return RetrofitCenter.createHttpClient(clientConfig);
    }

    private static OkHttpClient createHttpClient(ClientConfig clientConfig) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(clientConfig.connectTimeOut, TimeUnit.MILLISECONDS);
        builder.readTimeout(clientConfig.readTimeOut, TimeUnit.MILLISECONDS);
        builder.writeTimeout(clientConfig.writeTimeOut, TimeUnit.MILLISECONDS);
        builder.retryOnConnectionFailure(true);
        if (null != clientConfig.interceptors) {
            for (Interceptor interceptor : clientConfig.interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        if (null != clientConfig.extInfos) {
            builder.addInterceptor((Interceptor)new HttpExtInfoInterceptor(clientConfig.extInfos));
        }
        return builder.build();
    }

    public static void refreshToken(String newVal) {
        tokenValue = newVal;
    }

    public static String getTokenValue() {
        return tokenValue;
    }

    public static void clearToken() {
        RetrofitCenter.refreshToken("");
    }

    static {
        RETROFIT_MAP = new ConcurrentHashMap<String, Retrofit>();
    }

    public static final class ClientConfig {
        long connectTimeOut;
        long readTimeOut;
        long writeTimeOut;
        List<Interceptor> interceptors;
        List<IExtInfo> extInfos;

        private ClientConfig(Builder builder) {
            this.connectTimeOut = builder.connectTimeOut;
            this.readTimeOut = builder.readTimeOut;
            this.writeTimeOut = builder.writeTimeOut;
            this.interceptors = builder.interceptors;
            this.extInfos = builder.extInfos;
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            this.interceptors.add((Interceptor)loggingInterceptor);
        }

        public static final class Builder {
            private long connectTimeOut = TimeUnit.SECONDS.toMillis(15L);
            private long readTimeOut = TimeUnit.SECONDS.toMillis(50L);
            private long writeTimeOut = TimeUnit.SECONDS.toMillis(50L);
            private List<Interceptor> interceptors = new ArrayList<Interceptor>();
            private List<IExtInfo> extInfos = new ArrayList<IExtInfo>();

            public Builder withConnectTimeOut(long val) {
                this.connectTimeOut = val;
                return this;
            }

            public Builder withReadTimeOut(long val) {
                this.readTimeOut = val;
                return this;
            }

            public Builder withWriteTimeOut(long val) {
                this.writeTimeOut = val;
                return this;
            }

            public Builder withInterceptors(List<Interceptor> val) {
                this.interceptors.addAll(val);
                return this;
            }

            public Builder withExtInfos(List<IExtInfo> val) {
                this.extInfos.addAll(val);
                return this;
            }

            public Builder clearExtInfos() {
                this.extInfos.clear();
                return this;
            }

            public Builder clearInterceptors() {
                this.interceptors.clear();
                return this;
            }

            public ClientConfig build() {
                return new ClientConfig(this);
            }
        }
    }
}

