/*
 * Decompiled with CFR 0.152.
 */
package com.codvision.base.retrofit;

import com.codvision.base.BaseConst;
import com.codvision.base.retrofit.IExtInfo;
import com.codvision.base.retrofit.RetrofitCenter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class HttpExtInfoInterceptor
implements Interceptor {
    private List<IExtInfo> extInfo;

    public HttpExtInfoInterceptor(List<IExtInfo> val) {
        this.extInfo = val;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Headers.Builder headersBuilder = request.headers().newBuilder();
        HttpUrl.Builder urlBuilder = request.url().newBuilder();
        Request.Builder requestBuilder = request.newBuilder();
        if (null == this.extInfo) {
            return chain.proceed(request);
        }
        Map<String, String> values = null;
        block5: for (IExtInfo info : this.extInfo) {
            values = info.getValues();
            if (values.containsKey(BaseConst.TOKEN_KEY)) {
                values.put(BaseConst.TOKEN_KEY, RetrofitCenter.tokenValue);
            }
            switch (info.getPos()) {
                case Headers: {
                    for (Map.Entry<String, String> entry : values.entrySet()) {
                        headersBuilder.add(entry.getKey(), entry.getValue());
                    }
                    continue block5;
                }
                case Query: {
                    for (Map.Entry<String, String> entry : values.entrySet()) {
                        urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
                    }
                    continue block5;
                }
                case Body: {
                    break;
                }
            }
        }
        requestBuilder.url(urlBuilder.build());
        requestBuilder.headers(headersBuilder.build());
        return chain.proceed(requestBuilder.build());
    }
}

