/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.tool;

import android.content.Context;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import java.lang.ref.WeakReference;
import me.xujichang.util.tool.BaiduTransform;
import me.xujichang.util.tool.LogTool;
import me.xujichang.util.tool.Transform;

public class LocationTool {
    private WeakReference<Context> contextWeakReference;
    private static LocationTool instance;
    private LocationManager locationManager;
    private LocalizationListener localizationListener;
    private SelfGpsListener gpsListener;
    private SelfLocationListener locationListener;

    public static LocationTool getInstance() {
        if (null == instance) {
            instance = new LocationTool();
        }
        return instance;
    }

    public void startGetLocation(Context context, @NonNull LocalizationListener localizationListener) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.localizationListener = localizationListener;
        this.startWithGps();
    }

    private void startWithGps() {
        boolean isOpened = this.checkGpsStatus();
        if (!isOpened) {
            this.localizationListener.onGpsDisable();
        } else {
            this.getGPSLocation();
        }
    }

    private boolean checkGpsStatus() {
        return this.locationManager.isProviderEnabled("gps");
    }

    private void getGPSLocation() {
        if (ActivityCompat.checkSelfPermission((Context)((Context)this.contextWeakReference.get()), (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)((Context)this.contextWeakReference.get()), (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            this.localizationListener.onGpsPermissionDenied(new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"});
            return;
        }
        String serviceName = "location";
        String gpsProvider = "gps";
        this.locationManager = (LocationManager)((Context)this.contextWeakReference.get()).getSystemService(serviceName);
        Location location = this.locationManager.getLastKnownLocation(gpsProvider);
        this.updateToNewLocation(location);
        this.gpsListener = new SelfGpsListener();
        this.locationManager.addGpsStatusListener((GpsStatus.Listener)this.gpsListener);
        this.locationListener = new SelfLocationListener();
        this.locationManager.requestLocationUpdates(gpsProvider, 2000L, 10.0f, (LocationListener)this.locationListener);
    }

    private void updateToNewLocation(Location location) {
        LogTool.d("Last Known Location:" + (null == location ? "location is null" : location.toString()));
        this.localizationListener.onGpsLocation(location);
    }

    public boolean compare(Object tempTarget, Object target) {
        return false;
    }

    public static double[] convertBaidu2Gps(double[] target) {
        double[] mars = BaiduTransform.TransBaidu2Mars(target[0], target[1]);
        return Transform.Mars2WGS(mars[1], mars[0]);
    }

    public void onDestroy() {
        if (null != this.locationManager) {
            if (null != this.gpsListener) {
                this.locationManager.removeGpsStatusListener((GpsStatus.Listener)this.gpsListener);
            }
            if (null != this.locationListener) {
                this.locationManager.removeUpdates((LocationListener)this.locationListener);
            }
        }
    }

    private class SelfGpsListener
    implements GpsStatus.Listener {
        private SelfGpsListener() {
        }

        public void onGpsStatusChanged(int event) {
            switch (event) {
                case 3: {
                    LocationTool.this.localizationListener.onGpsFirstFix();
                    break;
                }
                case 4: {
                    LocationTool.this.localizationListener.onGpsStatusChanged();
                    break;
                }
                case 1: {
                    LocationTool.this.localizationListener.onGpsStart();
                    break;
                }
                case 2: {
                    LocationTool.this.localizationListener.onGpsStop();
                    break;
                }
            }
        }
    }

    public static class SimpleLocalizationListener
    implements LocalizationListener {
        @Override
        public void onGpsDisable() {
        }

        @Override
        public void onGpsPermissionDenied(String[] permissions) {
        }

        @Override
        public void onGpsLocation(Location location) {
        }

        @Override
        public void onGpsStatusChanged() {
        }

        @Override
        public void onGpsEnable() {
        }

        @Override
        public void onGpsStop() {
        }

        @Override
        public void onGpsFirstFix() {
        }

        @Override
        public void onGpsStart() {
        }

        @Override
        public void onLocationStatusChanged(int status, Bundle extras) {
        }
    }

    public static interface LocalizationListener {
        public void onGpsDisable();

        public void onGpsPermissionDenied(String[] var1);

        public void onGpsLocation(Location var1);

        public void onGpsStatusChanged();

        public void onGpsEnable();

        public void onGpsStop();

        public void onGpsFirstFix();

        public void onGpsStart();

        public void onLocationStatusChanged(int var1, Bundle var2);
    }

    private class SelfLocationListener
    implements LocationListener {
        private SelfLocationListener() {
        }

        public void onLocationChanged(Location location) {
            LogTool.d("LocationListener:" + location.toString());
            if ("gps".equals(location.getProvider())) {
                LocationTool.this.localizationListener.onGpsLocation(location);
                LocationTool.this.locationManager.removeGpsStatusListener((GpsStatus.Listener)LocationTool.this.gpsListener);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            LogTool.d("LocationListener:Status Changed:");
            LocationTool.this.localizationListener.onLocationStatusChanged(status, extras);
        }

        public void onProviderEnabled(String provider) {
            LogTool.d("LocationListener: enable");
            LocationTool.this.localizationListener.onGpsEnable();
        }

        public void onProviderDisabled(String provider) {
            LogTool.d("LocationListener: disable");
            LocationTool.this.localizationListener.onGpsDisable();
        }
    }
}

