/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.download;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import android.view.View;
import android.webkit.MimeTypeMap;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.internal.MDButton;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.observers.ResourceObserver;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import me.xujichang.util.tool.StringTool;
import okhttp3.ResponseBody;

public class DownLoadTool {
    private static final String FILE_APK = ".apk";
    private static DownLoadTool instance;
    private String fileName;
    private File storeDir;
    private WeakReference<Context> contextWeakReference;
    private boolean showProgress;
    private MaterialDialog progressDialog;
    private CompositeDisposable disposable;
    private String title;
    private int tempProgress;
    private DownLoadStatusCallback statusCallback;

    private DownLoadTool() {
        this.disposable = new CompositeDisposable();
    }

    protected DownLoadTool(String pS) {
    }

    private DownLoadTool init(Builder builder) {
        this.fileName = builder.fileName;
        this.storeDir = builder.storeFile;
        this.contextWeakReference = new WeakReference<Context>(builder.context);
        this.showProgress = builder.showProgress;
        this.title = builder.title;
        this.disposable = new CompositeDisposable();
        return this;
    }

    private static DownLoadTool getInstance() {
        if (null == instance) {
            instance = new DownLoadTool();
        }
        instance.clear();
        return instance;
    }

    private void clear() {
        this.fileName = null;
        this.storeDir = null;
        this.contextWeakReference = null;
        this.showProgress = true;
        this.title = null;
        this.tempProgress = -1;
        this.disposable = null;
        this.progressDialog = null;
    }

    public void apply(Observable<ResponseBody> observable) {
        this.apply(observable, null);
    }

    public void apply(Observable<ResponseBody> observable, DownLoadStatusCallback statusCallback) {
        observable.flatMap((Function)new Function<ResponseBody, ObservableSource<Integer>>(){

            public ObservableSource<Integer> apply(final ResponseBody body) throws Exception {
                ObservableOnSubscribe<Integer> subscribe = new ObservableOnSubscribe<Integer>(){

                    public void subscribe(ObservableEmitter<Integer> e) throws Exception {
                        DownLoadTool.this.writeResponseBodyToDisk(body, (ObservableEmitter<Integer>)e);
                    }
                };
                return Observable.create((ObservableOnSubscribe)subscribe);
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(this.createObservable(statusCallback));
    }

    private ResourceObserver<Integer> createObservable() {
        return this.createObservable(null);
    }

    private ResourceObserver<Integer> createObservable(final DownLoadStatusCallback statusCallback) {
        ResourceObserver<Integer> observer = new ResourceObserver<Integer>(){

            public void onNext(Integer integer) {
                if (null != statusCallback && integer > DownLoadTool.this.tempProgress) {
                    statusCallback.onNext(integer);
                }
                if (DownLoadTool.this.showProgress && integer > DownLoadTool.this.tempProgress) {
                    DownLoadTool.this.onDialogProgress(integer);
                }
                DownLoadTool.this.tempProgress = integer;
            }

            public void onError(Throwable e) {
                if (null != statusCallback) {
                    statusCallback.onError(e);
                }
                if (DownLoadTool.this.showProgress) {
                    DownLoadTool.this.onDialogError(StringTool.getErrorMsg(e));
                }
            }

            public void onComplete() {
                if (null != statusCallback) {
                    statusCallback.onComplete(DownLoadTool.this.fileName);
                }
                if (DownLoadTool.this.showProgress) {
                    DownLoadTool.this.onDialogComplete();
                }
            }

            protected void onStart() {
                if (null != statusCallback) {
                    statusCallback.onStart();
                }
                if (DownLoadTool.this.showProgress) {
                    DownLoadTool.this.createProgressDialog();
                }
            }
        };
        this.disposable.add((Disposable)observer);
        return observer;
    }

    private void onDialogComplete() {
        this.progressDialog.setContent((CharSequence)(this.fileName + "\u4e0b\u8f7d\u5b8c\u6210\uff01"));
        this.onDefaultComplete();
    }

    private void onDefaultComplete() {
        MDButton positiveButton = this.progressDialog.getActionButton(DialogAction.POSITIVE);
        MDButton negativeButton = this.progressDialog.getActionButton(DialogAction.NEGATIVE);
        if (this.fileName.endsWith(FILE_APK)) {
            positiveButton.setVisibility(0);
            positiveButton.setText((CharSequence)"\u5b89\u88c5");
            positiveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DownLoadTool.this.installApk();
                }
            });
            negativeButton.setText((CharSequence)"\u53d6\u6d88");
            negativeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DownLoadTool.this.progressDialog.dismiss();
                }
            });
        } else {
            positiveButton.setVisibility(0);
            positiveButton.setText((CharSequence)"\u786e\u5b9a");
            positiveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DownLoadTool.this.progressDialog.dismiss();
                }
            });
            negativeButton.setText((CharSequence)"\u67e5\u770b");
            negativeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null == DownLoadTool.this.contextWeakReference.get()) {
                        return;
                    }
                    Intent intent = new Intent("android.intent.action.GET_CONTENT");
                    intent.setDataAndType(DownLoadTool.this.getUri(DownLoadTool.this.storeDir), "*/*");
                    intent.addCategory("android.intent.category.OPENABLE");
                    ((Context)DownLoadTool.this.contextWeakReference.get()).startActivity(intent);
                }
            });
        }
    }

    private void installApk() {
        Context context = (Context)this.contextWeakReference.get();
        if (null == context) {
            return;
        }
        File storeFile = new File(this.storeDir + File.separator + this.fileName);
        Uri uri = this.getUri(storeFile);
        Intent intent = new Intent("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setFlags(1);
        } else {
            intent.addFlags(0x10000000);
        }
        intent.setDataAndType(uri, MimeTypeMap.getSingleton().getMimeTypeFromExtension("apk"));
        context.startActivity(intent);
        this.progressDialog.dismiss();
    }

    private void installApk(File file) {
        Uri uri = null;
        Intent intent = new Intent("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            uri = FileProvider.getUriForFile((Context)((Context)this.contextWeakReference.get()), (String)"android.support.v4.content.fileprovider", (File)file);
            intent.setFlags(1);
        } else {
            uri = Uri.fromFile((File)file);
            intent.addFlags(0x10000000);
        }
        intent.setDataAndType(uri, MimeTypeMap.getSingleton().getMimeTypeFromExtension("apk"));
        ((Context)this.contextWeakReference.get()).startActivity(intent);
        this.progressDialog.dismiss();
    }

    private void onDialogError(String msg) {
        if (null != this.progressDialog) {
            this.progressDialog.setContent((CharSequence)(this.fileName + " \u4e0b\u8f7d\u5931\u8d25:error{" + msg + "}"));
        }
    }

    private void onDialogProgress(Integer integer) {
        if (null == this.progressDialog) {
            this.createProgressDialog();
        }
        this.progressDialog.setProgress(integer.intValue());
    }

    private void createProgressDialog() {
        Context context = (Context)this.contextWeakReference.get();
        if (null == context) {
            return;
        }
        this.progressDialog = new MaterialDialog.Builder(context).title((CharSequence)this.title).content((CharSequence)(this.fileName + "\u4e0b\u8f7d\u4e2d...")).progress(false, 100).cancelable(false).positiveText((CharSequence)"\u786e\u5b9a").negativeText((CharSequence)"\u53d6\u6d88").onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                if (!DownLoadTool.this.disposable.isDisposed()) {
                    DownLoadTool.this.disposable.dispose();
                }
            }
        }).dismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                dialog = null;
            }
        }).build();
        this.progressDialog.getActionButton(DialogAction.POSITIVE).setVisibility(8);
        this.progressDialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseBodyToDisk(ResponseBody body, ObservableEmitter<Integer> emitter) {
        if (emitter.isDisposed()) {
            return;
        }
        Context context = (Context)this.contextWeakReference.get();
        if (context == null) {
            emitter.onError((Throwable)new RuntimeException("context is null"));
            return;
        }
        if (null == this.storeDir || !this.storeDir.exists()) {
            this.storeDir = context.getExternalFilesDir(null);
        }
        try {
            File futureStudioIconFile = new File(this.storeDir + File.separator + this.fileName);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int read;
                byte[] fileReader = new byte[1024];
                long fileSize = body.contentLength();
                long fileSizeDownloaded = 0L;
                inputStream = body.byteStream();
                outputStream = new FileOutputStream(futureStudioIconFile);
                while ((read = inputStream.read(fileReader)) != -1) {
                    outputStream.write(fileReader, 0, read);
                    emitter.onNext((Object)((int)((fileSizeDownloaded += (long)read) * 100L / fileSize)));
                }
                outputStream.flush();
                emitter.onComplete();
            }
            catch (IOException e) {
                if (!emitter.isDisposed()) {
                    emitter.onError((Throwable)e);
                } else {
                    e.printStackTrace();
                }
                this.deleteFile();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            if (!emitter.isDisposed()) {
                emitter.onError((Throwable)e);
            } else {
                e.printStackTrace();
            }
            this.deleteFile();
        }
    }

    private void deleteFile() {
        File storeFile = new File(this.storeDir + File.separator + this.fileName);
        if (storeFile.exists()) {
            storeFile.delete();
        }
    }

    private String getReallyFileName(String url) {
        String filename = "";
        int index = url.lastIndexOf("/");
        filename = url.substring(index + 1, url.length());
        index = filename.lastIndexOf(".");
        String extension = filename.substring(index + 1, filename.length());
        if (null == MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension)) {
            filename = System.currentTimeMillis() + "";
        }
        return filename;
    }

    private Uri getUri(File file) {
        Context context = (Context)this.contextWeakReference.get();
        Uri uri = null;
        uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)context, (String)"android.support.v4.content.fileprovider", (File)file) : Uri.fromFile((File)file);
        return uri;
    }

    public void setStatusCallback(DownLoadStatusCallback statusCallback) {
        this.statusCallback = statusCallback;
    }

    public static class SimpleDownloadStatusCallBack
    implements DownLoadStatusCallback {
        @Override
        public void onNext(Integer next) {
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onComplete(String fileName) {
        }
    }

    public static interface DownLoadStatusCallback {
        public void onNext(Integer var1);

        public void onStart();

        public void onError(Throwable var1);

        public void onComplete(String var1);
    }

    public static class Builder {
        private String fileName;
        private Context context;
        private File storeFile;
        private boolean showProgress;
        private String title;

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder storeDir(File storeFile) {
            this.storeFile = storeFile;
            return this;
        }

        public Builder showProgress(boolean showProgress) {
            this.showProgress = showProgress;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public DownLoadTool build() {
            return DownLoadTool.getInstance().init(this);
        }
    }
}

