/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.activity;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.graphics.Palette;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import me.xujichang.util.R;
import me.xujichang.util.tool.LogTool;

public class SuperActionBarActivity
extends AppCompatActivity
implements View.OnClickListener {
    private ImageView actionbarLeftImg;
    private TextView actionbarLeftText;
    private TextView actionbarTitle;
    private TextView actionbarRightText;
    private ImageView actionbarRightImg;
    private LinearLayout actionBar;
    private ViewGroup root;
    private ImageView mIvErrorTypeImg;
    private TextView mTvErrorMsg;
    private ImageView mIvErrorToRepair;
    private LinearLayout mLlErrorFloatTip;
    private LinearLayout mStatusBar;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        super.setContentView(R.layout.activity_root);
        this.root = (ViewGroup)this.findViewById(R.id.activity_layout_container);
        this.mLlErrorFloatTip = (LinearLayout)this.findViewById(R.id.ll_error_float_container);
        this.actionBar = (LinearLayout)this.findViewById(R.id.activity_actionbar_container);
        this.mStatusBar = (LinearLayout)this.findViewById(R.id.status_bar);
        this.actionbarRightImg = (ImageView)this.actionBar.findViewById(R.id.actionbar_right_img);
        this.actionbarRightText = (TextView)this.actionBar.findViewById(R.id.actionbar_right_text);
        this.actionbarTitle = (TextView)this.actionBar.findViewById(R.id.actionbar_title);
        this.actionbarLeftText = (TextView)this.actionBar.findViewById(R.id.actionbar_left_text);
        this.actionbarLeftImg = (ImageView)this.actionBar.findViewById(R.id.actionbar_left_img);
        this.mIvErrorTypeImg = (ImageView)this.mLlErrorFloatTip.findViewById(R.id.iv_error_type_img);
        this.mTvErrorMsg = (TextView)this.mLlErrorFloatTip.findViewById(R.id.tv_error_msg);
        this.mIvErrorToRepair = (ImageView)this.mLlErrorFloatTip.findViewById(R.id.iv_error_to_repair);
        LogTool.d("\u83b7\u53d6\u5b8c\u63a7\u4ef6");
    }

    public void setContentView(View view) {
        LogTool.d("\u6dfb\u52a0\u5b50\u5e03\u5c40");
        this.root.addView(view, -1, -1);
        this.paletteColor((View)this.actionBar);
    }

    private void paletteColor(View view) {
        Drawable background = view.getBackground();
        if (background instanceof ColorDrawable) {
            ColorDrawable colorDrawable = (ColorDrawable)background;
            int color2 = colorDrawable.getColor();
            this.initStatusBar(color2);
            LogTool.d("Color Drawable");
        } else {
            LogTool.d("Bitmap Drawable");
            BitmapDrawable bitmapDrawable = (BitmapDrawable)background;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            Palette.from((Bitmap)bitmap).generate(new Palette.PaletteAsyncListener(){

                public void onGenerated(Palette palette) {
                    Palette.Swatch a = palette.getVibrantSwatch();
                    if (null != a) {
                        SuperActionBarActivity.this.initStatusBar(a.getRgb());
                    }
                }
            });
        }
    }

    private void initStatusBar(int color2) {
        Window window = this.getWindow();
        int version = Build.VERSION.SDK_INT;
        if (version < 19) {
            return;
        }
        ColorDrawable colorDrawable = new ColorDrawable(color2);
        colorDrawable.setAlpha(230);
        int barcolor = colorDrawable.getColor();
        this.actionBar.setBackgroundColor(barcolor);
        colorDrawable = null;
        if (version < 21) {
            window.addFlags(0x4000000);
            int height = SuperActionBarActivity.getStatusBarHeight((Context)this);
            LogTool.d("\u539f\u6765\u7684\u9ad8\u5ea6\uff1a" + this.mStatusBar.getLayoutParams().height);
            ViewGroup.LayoutParams params = this.mStatusBar.getLayoutParams();
            params.height = height;
            this.mStatusBar.setLayoutParams(params);
            this.mStatusBar.setVisibility(0);
            this.mStatusBar.setBackgroundColor(color2);
            LogTool.d("\u540e\u6765\u7684\u9ad8\u5ea6\uff1a" + this.mStatusBar.getLayoutParams().height);
        } else {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color2);
        }
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelSize(resId);
        }
        return result;
    }

    public void setContentView(int layoutResID) {
        this.setContentView(View.inflate((Context)this, (int)layoutResID, null));
    }

    protected void setActionBarTitle(String title) {
        if (TextUtils.isEmpty((CharSequence)title)) {
            this.actionbarTitle.setVisibility(8);
        } else {
            this.actionbarTitle.setVisibility(0);
            this.actionbarTitle.setText((CharSequence)title);
            this.actionbarTitle.setOnClickListener((View.OnClickListener)this);
        }
    }

    protected void setActionBarDrawable(@DrawableRes int id2) {
        this.actionBar.setBackgroundResource(id2);
        this.paletteColor((View)this.actionBar);
    }

    protected void setActionBarColor(@ColorInt int color2) {
        this.actionBar.setBackgroundColor(color2);
        this.initStatusBar(color2);
    }

    protected void showBackArrow() {
        this.actionbarLeftImg.setVisibility(0);
        this.actionbarLeftImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    private void keepBalance() {
        if (this.actionbarLeftImg.getVisibility() == 0) {
            if (this.actionbarRightImg.getVisibility() != 0) {
                this.actionbarRightImg.setVisibility(4);
            }
        } else if (this.actionbarRightImg.getVisibility() == 0) {
            this.actionbarLeftImg.setVisibility(4);
        }
        if (this.actionbarLeftText.getVisibility() == 0) {
            if (this.actionbarRightText.getVisibility() != 0) {
                this.actionbarRightText.setVisibility(4);
            }
        } else if (this.actionbarRightText.getVisibility() == 0) {
            this.actionbarLeftText.setVisibility(4);
        }
    }

    protected void setLeftText(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            this.actionbarLeftText.setVisibility(8);
        } else {
            this.actionbarLeftText.setVisibility(0);
            this.actionbarLeftText.setText((CharSequence)str);
            this.actionbarLeftText.setOnClickListener((View.OnClickListener)this);
        }
        this.keepBalance();
    }

    protected void setLeftImg(@DrawableRes int id2) {
        this.actionbarLeftImg.setVisibility(0);
        this.actionbarLeftImg.setImageResource(id2);
        this.actionbarLeftImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    protected void showForwardArrow() {
        this.actionbarRightImg.setVisibility(0);
        this.actionbarRightImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    protected void setRightText(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            this.actionbarRightText.setVisibility(8);
        } else {
            this.actionbarRightText.setVisibility(0);
            this.actionbarRightText.setText((CharSequence)str);
            this.actionbarRightText.setOnClickListener((View.OnClickListener)this);
        }
        this.keepBalance();
    }

    protected void setRightImg(@DrawableRes int id2) {
        this.actionbarRightImg.setVisibility(0);
        this.actionbarRightImg.setImageResource(id2);
        this.actionbarRightImg.setOnClickListener((View.OnClickListener)this);
        this.keepBalance();
    }

    protected void onTitleClick() {
    }

    protected void onRightAreaClick() {
    }

    protected void onLeftAreaClick() {
        this.onBackPressed();
    }

    protected void hideActionBar() {
        this.actionBar.setVisibility(8);
    }

    @Nullable
    protected LinearLayout getSuperActionBar() {
        return this.actionBar;
    }

    protected ViewGroup getSuperRoot() {
        return this.root;
    }

    protected boolean isActionBarShow() {
        return this.actionBar.getVisibility() == 0;
    }

    protected void setErrorMsg(String msg, boolean show) {
        this.mTvErrorMsg.setText((CharSequence)msg);
        this.showView((View)this.mTvErrorMsg, show);
    }

    protected void setErrorIcon(@DrawableRes int id2, boolean show) {
        if (id2 != -1) {
            if (id2 != 0) {
                this.mIvErrorTypeImg.setImageResource(id2);
            }
        } else {
            show = false;
        }
        this.showView((View)this.mIvErrorTypeImg, show);
    }

    protected void setErrorIcon(@DrawableRes int id2) {
        if (id2 != -1) {
            if (id2 != 0) {
                this.mIvErrorTypeImg.setImageResource(id2);
            }
        } else {
            this.mIvErrorTypeImg.setVisibility(8);
        }
    }

    private void showView(View view, boolean show) {
        view.setVisibility(show ? 0 : 8);
    }

    protected void setErrorIcon(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        this.mIvErrorTypeImg.setImageDrawable(drawable2);
    }

    protected void setErrorRepairIcon(@DrawableRes int id2) {
        if (id2 != -1) {
            this.mIvErrorToRepair.setImageResource(id2);
        } else {
            this.mIvErrorToRepair.setVisibility(8);
        }
    }

    protected void setIvErrorRepair(Drawable drawable2) {
        this.mIvErrorToRepair.setImageDrawable(drawable2);
    }

    protected void showErrorTip(String msg) {
        this.showErrorTip(0, msg, 0, false);
    }

    protected void showErrorTip(String msg, boolean canDeal) {
        this.showErrorTip(0, msg, 0, canDeal);
    }

    protected void showErrorTip(@DrawableRes int errorTypeRes, String msg, @DrawableRes int repairRes, boolean canDeal) {
        this.setErrorIcon(errorTypeRes, true);
        this.setErrorRepairIcon(repairRes, canDeal);
        this.setErrorMsg(msg, true);
        this.mLlErrorFloatTip.setVisibility(0);
        this.mLlErrorFloatTip.setOnClickListener((View.OnClickListener)(canDeal ? this : null));
    }

    private void setErrorRepairIcon(@DrawableRes int repairRes, boolean show) {
        if (repairRes != 0) {
            this.mIvErrorToRepair.setImageResource(repairRes);
        }
        this.showView((View)this.mIvErrorToRepair, show);
    }

    protected void onErrorTipClick() {
    }

    protected void hideErrorTip() {
        this.mLlErrorFloatTip.setVisibility(8);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.actionbar_left_img || id2 == R.id.actionbar_left_text) {
            this.onLeftAreaClick();
        } else if (id2 == R.id.actionbar_right_text || id2 == R.id.actionbar_right_img) {
            this.onRightAreaClick();
        } else if (id2 == R.id.actionbar_title) {
            this.onTitleClick();
        } else if (id2 == R.id.ll_error_float_container) {
            this.onErrorTipClick();
        }
    }
}

